/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;

public abstract class RandomIterCSM
extends RandomIterFallback {
    protected ComponentSampleModel sampleModel;
    protected int pixelStride;
    protected int scanlineStride;
    protected int[] bandOffsets;
    protected int numBands;

    public RandomIterCSM(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
        this.sampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
        this.numBands = this.sampleModel.getNumBands();
        this.pixelStride = this.sampleModel.getPixelStride();
        this.scanlineStride = this.sampleModel.getScanlineStride();
    }

    protected void dataBufferChanged() {
    }

    protected final void makeCurrent(int n2, int n3) {
        int n4 = this.xTiles[n2];
        int n5 = this.yTiles[n3];
        if (n4 != this.xID || n5 != this.yID || this.dataBuffer == null) {
            this.xID = n4;
            this.yID = n5;
            Raster raster = this.im.getTile(this.xID, this.yID);
            this.dataBuffer = raster.getDataBuffer();
            this.dataBufferChanged();
            this.bandOffsets = this.dataBuffer.getOffsets();
        }
    }

    public float getSampleFloat(int n2, int n3, int n4) {
        return this.getSample(n2, n3, n4);
    }

    public double getSampleDouble(int n2, int n3, int n4) {
        return this.getSample(n2, n3, n4);
    }

    public int[] getPixel(int n2, int n3, int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray[n4] = this.getSample(n2, n3, n4);
            ++n4;
        }
        return nArray;
    }

    public float[] getPixel(int n2, int n3, float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n4 = 0;
        while (n4 < this.numBands) {
            fArray[n4] = this.getSampleFloat(n2, n3, n4);
            ++n4;
        }
        return fArray;
    }

    public double[] getPixel(int n2, int n3, double[] dArray) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        int n4 = 0;
        while (n4 < this.numBands) {
            dArray[n4] = this.getSampleDouble(n2, n3, n4);
            ++n4;
        }
        return dArray;
    }
}

