/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codecimpl.JaiI18N;

class TIFFFaxDecoder {
    private int bitPointer;
    private int bytePointer;
    private byte[] data;
    private int w;
    private int h;
    private int fillOrder;
    private int changingElemSize = 0;
    private int[] prevChangingElems;
    private int[] currChangingElems;
    private int lastChangingElement = 0;
    private int compression = 2;
    private int uncompressedMode = 0;
    private int fillBits = 0;
    private int oneD;
    static int[] table1 = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    static int[] table2 = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};
    static byte[] flipTable = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};
    static short[] white = new short[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
    static short[] additionalMakeup = new short[]{28679, 28679, 31752, -32759, -31735, -30711, -29687, -28663, 29703, 29703, 30727, 30727, -27639, -26615, -25591, -24567};
    static short[] initBlack = new short[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
    static short[] twoBitBlack = new short[]{292, 260, 226, 226};
    static short[] black = new short[]{62, 62, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 588, 588, 588, 588, 588, 588, 588, 588, 1680, 1680, 20499, 22547, 24595, 26643, 1776, 1776, 1808, 1808, -24557, -22509, -20461, -18413, 1904, 1904, 1936, 1936, -16365, -14317, 782, 782, 782, 782, 814, 814, 814, 814, -12269, -10221, 10257, 10257, 12305, 12305, 14353, 14353, 16403, 18451, 1712, 1712, 1744, 1744, 28691, 30739, -32749, -30701, -28653, -26605, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 750, 750, 750, 750, 1616, 1616, 1648, 1648, 1424, 1424, 1456, 1456, 1488, 1488, 1520, 1520, 1840, 1840, 1872, 1872, 1968, 1968, 8209, 8209, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 1552, 1552, 1584, 1584, 2000, 2000, 2032, 2032, 976, 976, 1008, 1008, 1040, 1040, 1072, 1072, 1296, 1296, 1328, 1328, 718, 718, 718, 718, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 4113, 4113, 6161, 6161, 848, 848, 880, 880, 912, 912, 944, 944, 622, 622, 622, 622, 654, 654, 654, 654, 1104, 1104, 1136, 1136, 1168, 1168, 1200, 1200, 1232, 1232, 1264, 1264, 686, 686, 686, 686, 1360, 1360, 1392, 1392, 12, 12, 12, 12, 12, 12, 12, 12, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390};
    static byte[] twoDCodes = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};

    public TIFFFaxDecoder(int n2, int n3, int n4) {
        this.fillOrder = n2;
        this.w = n3;
        this.h = n4;
        this.bitPointer = 0;
        this.bytePointer = 0;
        this.prevChangingElems = new int[n3 + 1];
        this.currChangingElems = new int[n3 + 1];
    }

    public void decode1D(byte[] byArray, byte[] byArray2, int n2, int n3) {
        this.data = byArray2;
        int n4 = 0;
        int n5 = (this.w + 7) / 8;
        this.bitPointer = 0;
        this.bytePointer = 0;
        int n6 = 0;
        while (n6 < n3) {
            this.decodeNextScanline(byArray, n4, n2);
            n4 += n5;
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decodeNextScanline(byte[] var1_1, int var2_2, int var3_3) {
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var10_7 = true;
        var11_8 = false;
        this.changingElemSize = 0;
        ** GOTO lbl90
        {
            var7_9 = this.nextNBits(10);
            var8_10 = TIFFFaxDecoder.white[var7_9];
            var6_6 = var8_10 & 1;
            var4_4 = var8_10 >>> 1 & 15;
            if (var4_4 == 12) {
                var9_11 = this.nextLesserThan8Bits(2);
                var7_9 = var7_9 << 2 & 12 | var9_11;
                var8_10 = TIFFFaxDecoder.additionalMakeup[var7_9];
                var4_4 = var8_10 >>> 1 & 7;
                var5_5 = var8_10 >>> 4 & 4095;
                var3_3 += var5_5;
                this.updatePointer(4 - var4_4);
            } else {
                if (var4_4 == 0) {
                    throw new Error(JaiI18N.getString("TIFFFaxDecoder0"));
                }
                if (var4_4 == 15) {
                    this.updatePointer(12);
                    return;
                }
                var5_5 = var8_10 >>> 5 & 2047;
                var3_3 += var5_5;
                this.updatePointer(10 - var4_4);
                if (var6_6 == 0) {
                    var10_7 = false;
                    this.currChangingElems[this.changingElemSize++] = var3_3;
                }
            }
            do {
                if (var10_7) continue block0;
                if (var3_3 != this.w) ** GOTO lbl84
                if (this.compression != 2) break block0;
                this.advancePointer();
                break block0;
lbl-1000:
                // 1 sources

                {
                    var7_9 = this.nextLesserThan8Bits(4);
                    var8_10 = TIFFFaxDecoder.initBlack[var7_9];
                    var6_6 = var8_10 & 1;
                    var4_4 = var8_10 >>> 1 & 15;
                    var5_5 = var8_10 >>> 5 & 2047;
                    if (var5_5 == 100) {
                        var7_9 = this.nextNBits(9);
                        var8_10 = TIFFFaxDecoder.black[var7_9];
                        var6_6 = var8_10 & 1;
                        var4_4 = var8_10 >>> 1 & 15;
                        var5_5 = var8_10 >>> 5 & 2047;
                        if (var4_4 == 12) {
                            this.updatePointer(5);
                            var7_9 = this.nextLesserThan8Bits(4);
                            var8_10 = TIFFFaxDecoder.additionalMakeup[var7_9];
                            var4_4 = var8_10 >>> 1 & 7;
                            var5_5 = var8_10 >>> 4 & 4095;
                            this.setToBlack(var1_1, var2_2, var3_3, var5_5);
                            var3_3 += var5_5;
                            this.updatePointer(4 - var4_4);
                            continue;
                        }
                        if (var4_4 == 15) {
                            this.updatePointer(12);
                            return;
                        }
                        this.setToBlack(var1_1, var2_2, var3_3, var5_5);
                        var3_3 += var5_5;
                        this.updatePointer(9 - var4_4);
                        if (var6_6 != 0) continue;
                        var10_7 = true;
                        this.currChangingElems[this.changingElemSize++] = var3_3;
                        continue;
                    }
                    if (var5_5 == 200) {
                        var7_9 = this.nextLesserThan8Bits(2);
                        var8_10 = TIFFFaxDecoder.twoBitBlack[var7_9];
                        var5_5 = var8_10 >>> 5 & 2047;
                        var4_4 = var8_10 >>> 1 & 15;
                        this.setToBlack(var1_1, var2_2, var3_3, var5_5);
                        this.updatePointer(2 - var4_4);
                        var10_7 = true;
                        this.currChangingElems[this.changingElemSize++] = var3_3 += var5_5;
                        continue;
                    }
                    this.setToBlack(var1_1, var2_2, var3_3, var5_5);
                    this.updatePointer(4 - var4_4);
                    var10_7 = true;
                    this.currChangingElems[this.changingElemSize++] = var3_3 += var5_5;
lbl84:
                    // 6 sources

                    ** while (!var10_7)
                }
lbl85:
                // 1 sources

                if (var3_3 != this.w) continue;
                if (this.compression != 2) break block0;
                this.advancePointer();
                break block0;
lbl90:
                // 2 sources

            } while (var3_3 < this.w);
        }
        this.currChangingElems[this.changingElemSize++] = var3_3;
    }

    public void decode2D(byte[] byArray, byte[] byArray2, int n2, int n3, long l2) {
        this.data = byArray2;
        this.compression = 3;
        this.bitPointer = 0;
        this.bytePointer = 0;
        int n4 = (this.w + 7) / 8;
        int[] nArray = new int[2];
        int n5 = 0;
        this.oneD = (int)(l2 & 1L);
        this.uncompressedMode = (int)((l2 & 2L) >> 1);
        this.fillBits = (int)((l2 & 4L) >> 2);
        if (this.readEOL(true) != 1) {
            throw new Error(JaiI18N.getString("TIFFFaxDecoder3"));
        }
        int n6 = 0;
        this.decodeNextScanline(byArray, n6, n2);
        n6 += n4;
        int n7 = 1;
        while (n7 < n3) {
            if (this.readEOL(false) == 0) {
                int[] nArray2 = this.prevChangingElems;
                this.prevChangingElems = this.currChangingElems;
                this.currChangingElems = nArray2;
                n5 = 0;
                int n8 = -1;
                boolean bl = true;
                int n9 = n2;
                this.lastChangingElement = 0;
                while (n9 < this.w) {
                    this.getNextChangingElement(n8, bl, nArray);
                    int n10 = nArray[0];
                    int n11 = nArray[1];
                    int n12 = this.nextLesserThan8Bits(7);
                    n12 = twoDCodes[n12] & 0xFF;
                    int n13 = (n12 & 0x78) >>> 3;
                    int n14 = n12 & 7;
                    if (n13 == 0) {
                        if (!bl) {
                            this.setToBlack(byArray, n6, n9, n11 - n9);
                        }
                        n9 = n8 = n11;
                        this.updatePointer(7 - n14);
                        continue;
                    }
                    if (n13 == 1) {
                        int n15;
                        this.updatePointer(7 - n14);
                        if (bl) {
                            n15 = this.decodeWhiteCodeWord();
                            this.currChangingElems[n5++] = n9 += n15;
                            n15 = this.decodeBlackCodeWord();
                            this.setToBlack(byArray, n6, n9, n15);
                            this.currChangingElems[n5++] = n9 += n15;
                        } else {
                            n15 = this.decodeBlackCodeWord();
                            this.setToBlack(byArray, n6, n9, n15);
                            this.currChangingElems[n5++] = n9 += n15;
                            n15 = this.decodeWhiteCodeWord();
                            this.currChangingElems[n5++] = n9 += n15;
                        }
                        n8 = n9;
                        continue;
                    }
                    if (n13 <= 8) {
                        int n16 = n10 + (n13 - 5);
                        this.currChangingElems[n5++] = n16;
                        if (!bl) {
                            this.setToBlack(byArray, n6, n9, n16 - n9);
                        }
                        n9 = n8 = n16;
                        bl = !bl;
                        this.updatePointer(7 - n14);
                        continue;
                    }
                    throw new Error(JaiI18N.getString("TIFFFaxDecoder4"));
                }
                this.currChangingElems[n5++] = n9;
                this.changingElemSize = n5;
            } else {
                this.decodeNextScanline(byArray, n6, n2);
            }
            n6 += n4;
            ++n7;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void decodeT6(byte[] var1_1, byte[] var2_2, int var3_3, int var4_4, long var5_5) {
        this.data = var2_2;
        this.compression = 4;
        this.bitPointer = 0;
        this.bytePointer = 0;
        var7_6 = (this.w + 7) / 8;
        var8_7 = false;
        var20_8 = new int[2];
        this.uncompressedMode = (int)((var5_5 & 2L) >> 1);
        var21_9 = this.currChangingElems;
        this.changingElemSize = 0;
        var21_9[this.changingElemSize++] = this.w;
        var21_9[this.changingElemSize++] = this.w;
        var22_10 = 0;
        var24_11 = 0;
        while (var24_11 < var4_4) {
            var9_12 = -1;
            var17_19 = true;
            var19_21 = this.prevChangingElems;
            this.prevChangingElems = this.currChangingElems;
            this.currChangingElems = var19_21;
            var21_9 = var19_21;
            var18_20 = 0;
            var23_22 = var3_3;
            this.lastChangingElement = 0;
            while (var23_22 < this.w) {
                block22: {
                    this.getNextChangingElement(var9_12, var17_19, var20_8);
                    var11_14 = var20_8[0];
                    var12_15 = var20_8[1];
                    var13_16 = this.nextLesserThan8Bits(7);
                    var13_16 = TIFFFaxDecoder.twoDCodes[var13_16] & 255;
                    var14_17 = (var13_16 & 120) >>> 3;
                    var15_18 = var13_16 & 7;
                    if (var14_17 == 0) {
                        if (!var17_19) {
                            this.setToBlack(var1_1, var22_10, var23_22, var12_15 - var23_22);
                        }
                        var23_22 = var9_12 = var12_15;
                        this.updatePointer(7 - var15_18);
                        continue;
                    }
                    if (var14_17 == 1) {
                        this.updatePointer(7 - var15_18);
                        if (var17_19) {
                            var25_23 = this.decodeWhiteCodeWord();
                            var21_9[var18_20++] = var23_22 += var25_23;
                            var25_23 = this.decodeBlackCodeWord();
                            this.setToBlack(var1_1, var22_10, var23_22, var25_23);
                            var21_9[var18_20++] = var23_22 += var25_23;
                        } else {
                            var25_23 = this.decodeBlackCodeWord();
                            this.setToBlack(var1_1, var22_10, var23_22, var25_23);
                            var21_9[var18_20++] = var23_22 += var25_23;
                            var25_23 = this.decodeWhiteCodeWord();
                            var21_9[var18_20++] = var23_22 += var25_23;
                        }
                        var9_12 = var23_22;
                        continue;
                    }
                    if (var14_17 <= 8) {
                        var10_13 = var11_14 + (var14_17 - 5);
                        var21_9[var18_20++] = var10_13;
                        if (!var17_19) {
                            this.setToBlack(var1_1, var22_10, var23_22, var10_13 - var23_22);
                        }
                        var23_22 = var9_12 = var10_13;
                        var17_19 = var17_19 == false;
                        this.updatePointer(7 - var15_18);
                        continue;
                    }
                    if (var14_17 != 11) break block22;
                    if (this.nextLesserThan8Bits(3) != 7) {
                        throw new Error(JaiI18N.getString("TIFFFaxDecoder5"));
                    }
                    var25_23 = 0;
                    var26_24 = false;
                    ** GOTO lbl98
                    {
                        ++var25_23;
                        do {
                            if (this.nextLesserThan8Bits(1) != 1) continue block2;
                            if (var25_23 > 5) {
                                if (!var17_19 && (var25_23 -= 6) > 0) {
                                    var21_9[var18_20++] = var23_22;
                                }
                                var23_22 += var25_23;
                                if (var25_23 > 0) {
                                    var17_19 = true;
                                }
                                if (this.nextLesserThan8Bits(1) == 0) {
                                    if (!var17_19) {
                                        var21_9[var18_20++] = var23_22;
                                    }
                                    var17_19 = true;
                                } else {
                                    if (var17_19) {
                                        var21_9[var18_20++] = var23_22;
                                    }
                                    var17_19 = false;
                                }
                                var26_24 = true;
                            }
                            if (var25_23 == 5) {
                                if (!var17_19) {
                                    var21_9[var18_20++] = var23_22;
                                }
                                var23_22 += var25_23;
                                var17_19 = true;
                                continue;
                            }
                            var21_9[var18_20++] = var23_22 += var25_23;
                            this.setToBlack(var1_1, var22_10, var23_22, 1);
                            ++var23_22;
                            var17_19 = false;
lbl98:
                            // 3 sources

                        } while (!var26_24);
                    }
                    continue;
                }
                throw new Error(JaiI18N.getString("TIFFFaxDecoder5"));
            }
            if (var18_20 <= this.w) {
                var21_9[var18_20++] = var23_22;
            }
            this.changingElemSize = var18_20;
            var22_10 += var7_6;
            ++var24_11;
        }
    }

    private void setToBlack(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 8 * n2 + n3;
        int n6 = n5 + n4;
        int n7 = n5 >> 3;
        int n8 = n5 & 7;
        if (n8 > 0) {
            int n9 = 1 << 7 - n8;
            byte by = byArray[n7];
            while (n9 > 0 && n5 < n6) {
                by = (byte)(by | n9);
                n9 >>= 1;
                ++n5;
            }
            byArray[n7] = by;
        }
        n7 = n5 >> 3;
        while (n5 < n6 - 7) {
            byArray[n7++] = -1;
            n5 += 8;
        }
        while (n5 < n6) {
            int n10 = n7 = n5 >> 3;
            byArray[n10] = (byte)(byArray[n10] | 1 << 7 - (n5 & 7));
            ++n5;
        }
    }

    private int decodeWhiteCodeWord() {
        int n2 = -1;
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            int n4 = this.nextNBits(10);
            short s2 = white[n4];
            int n5 = s2 & 1;
            int n6 = s2 >>> 1 & 0xF;
            if (n6 == 12) {
                int n7 = this.nextLesserThan8Bits(2);
                n4 = n4 << 2 & 0xC | n7;
                s2 = additionalMakeup[n4];
                n6 = s2 >>> 1 & 7;
                n2 = s2 >>> 4 & 0xFFF;
                n3 += n2;
                this.updatePointer(4 - n6);
                continue;
            }
            if (n6 == 0) {
                throw new Error(JaiI18N.getString("TIFFFaxDecoder0"));
            }
            if (n6 == 15) {
                throw new Error(JaiI18N.getString("TIFFFaxDecoder1"));
            }
            n2 = s2 >>> 5 & 0x7FF;
            n3 += n2;
            this.updatePointer(10 - n6);
            if (n5 != 0) continue;
            bl = false;
        }
        return n3;
    }

    private int decodeBlackCodeWord() {
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        while (!bl) {
            int n4 = this.nextLesserThan8Bits(4);
            short s2 = initBlack[n4];
            int n5 = s2 & 1;
            int n6 = s2 >>> 1 & 0xF;
            n2 = s2 >>> 5 & 0x7FF;
            if (n2 == 100) {
                n4 = this.nextNBits(9);
                s2 = black[n4];
                n5 = s2 & 1;
                n6 = s2 >>> 1 & 0xF;
                n2 = s2 >>> 5 & 0x7FF;
                if (n6 == 12) {
                    this.updatePointer(5);
                    n4 = this.nextLesserThan8Bits(4);
                    s2 = additionalMakeup[n4];
                    n6 = s2 >>> 1 & 7;
                    n2 = s2 >>> 4 & 0xFFF;
                    n3 += n2;
                    this.updatePointer(4 - n6);
                    continue;
                }
                if (n6 == 15) {
                    throw new Error(JaiI18N.getString("TIFFFaxDecoder2"));
                }
                n3 += n2;
                this.updatePointer(9 - n6);
                if (n5 != 0) continue;
                bl = true;
                continue;
            }
            if (n2 == 200) {
                n4 = this.nextLesserThan8Bits(2);
                s2 = twoBitBlack[n4];
                n2 = s2 >>> 5 & 0x7FF;
                n3 += n2;
                n6 = s2 >>> 1 & 0xF;
                this.updatePointer(2 - n6);
                bl = true;
                continue;
            }
            n3 += n2;
            this.updatePointer(4 - n6);
            bl = true;
        }
        return n3;
    }

    private boolean seekEOL() {
        int n2 = this.data.length * 8 - 1;
        int n3 = this.bytePointer * 8 + this.bitPointer;
        while (n3 <= n2 - 12) {
            int n4 = this.nextNBits(12);
            n3 += 12;
            while (n4 != 1 && n3 < n2) {
                n4 = (n4 & 0x7FF) << 1 | this.nextLesserThan8Bits(1) & 1;
                ++n3;
            }
            if (n4 != 1) continue;
            this.updatePointer(12);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int readEOL(boolean var1_1) {
        block9: {
            block8: {
                if (this.oneD == 0 && !this.seekEOL()) {
                    throw new Error(JaiI18N.getString("TIFFFaxDecoder9"));
                }
                if (this.fillBits != 0) break block8;
                var2_2 = this.nextNBits(12);
                if (var1_1 && var2_2 == 0 && this.nextNBits(4) == 1) {
                    this.fillBits = 1;
                    return 1;
                }
                if (var2_2 != 1) {
                    throw new Error(JaiI18N.getString("TIFFFaxDecoder6"));
                }
                break block9;
            }
            if (this.fillBits != 1) break block9;
            var2_3 = 8 - this.bitPointer;
            if (this.nextNBits(var2_3) != 0) {
                throw new Error(JaiI18N.getString("TIFFFaxDecoder8"));
            }
            if (var2_3 < 4 && this.nextNBits(8) != 0) {
                throw new Error(JaiI18N.getString("TIFFFaxDecoder8"));
            }
            var3_4 = this.nextNBits(8);
            if (!var1_1 || (var3_4 & 240) != 16) ** GOTO lbl26
            this.fillBits = 0;
            this.updatePointer(4);
            break block9;
lbl-1000:
            // 1 sources

            {
                if (var3_4 != 0) {
                    throw new Error(JaiI18N.getString("TIFFFaxDecoder8"));
                }
                var3_4 = this.nextNBits(8);
lbl26:
                // 2 sources

                ** while (var3_4 != 1)
            }
        }
        if (this.oneD == 0) {
            return 1;
        }
        return this.nextLesserThan8Bits(1);
    }

    private void getNextChangingElement(int n2, boolean bl, int[] nArray) {
        int n3;
        int[] nArray2 = this.prevChangingElems;
        int n4 = this.changingElemSize;
        int n5 = n3 = this.lastChangingElement > 0 ? this.lastChangingElement - 1 : 0;
        n3 = bl ? (n3 &= 0xFFFFFFFE) : (n3 |= 1);
        int n6 = n3;
        while (n6 < n4) {
            int n7 = nArray2[n6];
            if (n7 > n2) {
                this.lastChangingElement = n6;
                nArray[0] = n7;
                break;
            }
            n6 += 2;
        }
        if (n6 + 1 < n4) {
            nArray[1] = nArray2[n6 + 1];
        }
    }

    private int nextNBits(int n2) {
        byte by;
        byte by2;
        byte by3;
        int n3 = this.data.length - 1;
        int n4 = this.bytePointer;
        if (this.fillOrder == 1) {
            by3 = this.data[n4];
            if (n4 == n3) {
                by2 = 0;
                by = 0;
            } else if (n4 + 1 == n3) {
                by2 = this.data[n4 + 1];
                by = 0;
            } else {
                by2 = this.data[n4 + 1];
                by = this.data[n4 + 2];
            }
        } else if (this.fillOrder == 2) {
            by3 = flipTable[this.data[n4] & 0xFF];
            if (n4 == n3) {
                by2 = 0;
                by = 0;
            } else if (n4 + 1 == n3) {
                by2 = flipTable[this.data[n4 + 1] & 0xFF];
                by = 0;
            } else {
                by2 = flipTable[this.data[n4 + 1] & 0xFF];
                by = flipTable[this.data[n4 + 2] & 0xFF];
            }
        } else {
            throw new Error(JaiI18N.getString("TIFFFaxDecoder7"));
        }
        int n5 = 8 - this.bitPointer;
        int n6 = n2 - n5;
        int n7 = 0;
        if (n6 > 8) {
            n7 = n6 - 8;
            n6 = 8;
        }
        ++this.bytePointer;
        int n8 = (by3 & table1[n5]) << n2 - n5;
        int n9 = (by2 & table2[n6]) >>> 8 - n6;
        int n10 = 0;
        if (n7 != 0) {
            n9 <<= n7;
            n10 = (by & table2[n7]) >>> 8 - n7;
            n9 |= n10;
            ++this.bytePointer;
            this.bitPointer = n7;
        } else if (n6 == 8) {
            this.bitPointer = 0;
            ++this.bytePointer;
        } else {
            this.bitPointer = n6;
        }
        int n11 = n8 | n9;
        return n11;
    }

    private int nextLesserThan8Bits(int n2) {
        int n3;
        byte by;
        byte by2;
        int n4 = this.data.length - 1;
        int n5 = this.bytePointer;
        if (this.fillOrder == 1) {
            by2 = this.data[n5];
            by = n5 == n4 ? (byte)0 : this.data[n5 + 1];
        } else if (this.fillOrder == 2) {
            by2 = flipTable[this.data[n5] & 0xFF];
            by = n5 == n4 ? (byte)0 : flipTable[this.data[n5 + 1] & 0xFF];
        } else {
            throw new Error(JaiI18N.getString("TIFFFaxDecoder7"));
        }
        int n6 = 8 - this.bitPointer;
        int n7 = n2 - n6;
        int n8 = n6 - n2;
        if (n8 >= 0) {
            n3 = (by2 & table1[n6]) >>> n8;
            this.bitPointer += n2;
            if (this.bitPointer == 8) {
                this.bitPointer = 0;
                ++this.bytePointer;
            }
        } else {
            n3 = (by2 & table1[n6]) << -n8;
            int n9 = (by & table2[n7]) >>> 8 - n7;
            n3 |= n9;
            ++this.bytePointer;
            this.bitPointer = n7;
        }
        return n3;
    }

    private void updatePointer(int n2) {
        int n3;
        if (n2 > 8) {
            this.bytePointer -= n2 / 8;
            n2 %= 8;
        }
        if ((n3 = this.bitPointer - n2) < 0) {
            --this.bytePointer;
            this.bitPointer = 8 + n3;
        } else {
            this.bitPointer = n3;
        }
    }

    private boolean advancePointer() {
        if (this.bitPointer != 0) {
            ++this.bytePointer;
            this.bitPointer = 0;
        }
        return true;
    }
}

