/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codecimpl.ChunkStream;
import com.sun.media.jai.codecimpl.IDATOutputStream;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGImageEncoder
extends ImageEncoderImpl {
    private static final int PNG_COLOR_GRAY = 0;
    private static final int PNG_COLOR_RGB = 2;
    private static final int PNG_COLOR_PALETTE = 3;
    private static final int PNG_COLOR_GRAY_ALPHA = 4;
    private static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final byte[] magic = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private PNGEncodeParam param;
    private RenderedImage image;
    private int width;
    private int height;
    private int bitDepth;
    private int bitShift;
    private int numBands;
    private int colorType;
    private int bpp;
    private boolean skipAlpha = false;
    private boolean compressGray = false;
    private boolean interlace;
    private byte[] redPalette = null;
    private byte[] greenPalette = null;
    private byte[] bluePalette = null;
    private byte[] alphaPalette = null;
    private DataOutputStream dataOutput;
    private byte[] prevRow = null;
    private byte[] currRow = null;
    private byte[][] filteredRows = null;
    private static final float[] srgbChroma = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};

    private static int filterPrintableLatin1(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5 = byArray[n4] & 0xFF;
            if (n3 != 32 || n5 != 32) {
                if (n5 > 32 && n5 <= 126 || n5 >= 161 && n5 <= 255) {
                    byArray[n2++] = (byte)n5;
                }
                n3 = n5;
            }
            ++n4;
        }
        return n2;
    }

    public PNGImageEncoder(OutputStream outputStream, PNGEncodeParam pNGEncodeParam) {
        super(outputStream, pNGEncodeParam);
        if (pNGEncodeParam != null) {
            this.param = pNGEncodeParam;
        }
        this.dataOutput = new DataOutputStream(outputStream);
    }

    private void writeMagic() throws IOException {
        this.dataOutput.write(magic);
    }

    private void writeIHDR() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IHDR");
        chunkStream.writeInt(this.width);
        chunkStream.writeInt(this.height);
        chunkStream.writeByte((byte)this.bitDepth);
        chunkStream.writeByte((byte)this.colorType);
        chunkStream.writeByte(0);
        chunkStream.writeByte(0);
        chunkStream.writeByte(this.interlace ? 1 : 0);
        chunkStream.writeToStream(this.dataOutput);
    }

    private static int clamp(int n2, int n3) {
        return n2 > n3 ? n3 : n2;
    }

    private void encodePass(OutputStream outputStream, Raster raster, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = raster.getWidth();
        int n9 = raster.getHeight();
        int n10 = 8 / this.bitDepth;
        int n11 = n8 * this.numBands;
        int[] nArray = new int[n11];
        int n12 = (n11 - (n2 *= this.numBands) + (n4 *= this.numBands) - 1) / n4;
        int n13 = n12 * this.numBands;
        if (this.bitDepth < 8) {
            n13 = (n13 + n10 - 1) / n10;
        } else if (this.bitDepth == 16) {
            n13 *= 2;
        }
        if (n13 == 0) {
            return;
        }
        this.currRow = new byte[n13 + this.bpp];
        this.prevRow = new byte[n13 + this.bpp];
        this.filteredRows = new byte[5][n13 + this.bpp];
        int n14 = (1 << this.bitDepth) - 1;
        int n15 = n7 + n3;
        while (n15 < n7 + n9) {
            int n16;
            int n17;
            int n18;
            raster.getPixels(n6, n15, n8, 1, nArray);
            if (this.compressGray) {
                n18 = 8 - this.bitDepth;
                n17 = 0;
                while (n17 < n8) {
                    int n19 = n17++;
                    nArray[n19] = nArray[n19] >> n18;
                }
            }
            n18 = this.bpp;
            n17 = 0;
            int n20 = 0;
            switch (this.bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int n21;
                    int n22 = n10 - 1;
                    int n23 = n2;
                    while (n23 < n11) {
                        n21 = PNGImageEncoder.clamp(nArray[n23] >> this.bitShift, n14);
                        n20 = n20 << this.bitDepth | n21;
                        if ((n17++ & n22) == n22) {
                            this.currRow[n18++] = (byte)n20;
                            n20 = 0;
                        }
                        n23 += n4;
                    }
                    if ((n17 & n22) == 0) break;
                    this.currRow[n18++] = (byte)(n20 <<= (8 / this.bitDepth - (n17 & n22)) * this.bitDepth);
                    break;
                }
                case 8: {
                    int n24;
                    int n21 = n2;
                    while (n21 < n11) {
                        n24 = 0;
                        while (n24 < this.numBands) {
                            this.currRow[n18++] = (byte)PNGImageEncoder.clamp(nArray[n21 + n24] >> this.bitShift, n14);
                            ++n24;
                        }
                        n21 += n4;
                    }
                    break;
                }
                case 16: {
                    int n24 = n2;
                    while (n24 < n11) {
                        n16 = 0;
                        while (n16 < this.numBands) {
                            int n25 = PNGImageEncoder.clamp(nArray[n24 + n16] >> this.bitShift, n14);
                            this.currRow[n18++] = (byte)(n25 >> 8);
                            this.currRow[n18++] = (byte)(n25 & 0xFF);
                            ++n16;
                        }
                        n24 += n4;
                    }
                    break;
                }
            }
            n16 = this.param.filterRow(this.currRow, this.prevRow, this.filteredRows, n13, this.bpp);
            outputStream.write(n16);
            outputStream.write(this.filteredRows[n16], this.bpp, n13);
            byte[] byArray = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = byArray;
            n15 += n5;
        }
    }

    private void writeIDAT() throws IOException {
        IDATOutputStream iDATOutputStream = new IDATOutputStream(this.dataOutput, 8192);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)iDATOutputStream, new Deflater(9));
        Raster raster = this.image.getData();
        if (this.skipAlpha) {
            int n2 = raster.getNumBands() - 1;
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = n3;
                ++n3;
            }
            raster = raster.createChild(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, nArray);
        }
        if (this.interlace) {
            this.encodePass(deflaterOutputStream, raster, 0, 0, 8, 8);
            this.encodePass(deflaterOutputStream, raster, 4, 0, 8, 8);
            this.encodePass(deflaterOutputStream, raster, 0, 4, 4, 8);
            this.encodePass(deflaterOutputStream, raster, 2, 0, 4, 4);
            this.encodePass(deflaterOutputStream, raster, 0, 2, 2, 4);
            this.encodePass(deflaterOutputStream, raster, 1, 0, 2, 2);
            this.encodePass(deflaterOutputStream, raster, 0, 1, 1, 2);
        } else {
            this.encodePass(deflaterOutputStream, raster, 0, 0, 1, 1);
        }
        deflaterOutputStream.finish();
        iDATOutputStream.flush();
    }

    private void writeIEND() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IEND");
        chunkStream.writeToStream(this.dataOutput);
    }

    private void writeCHRM() throws IOException {
        if (this.param.isChromaticitySet() || this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("cHRM");
            float[] fArray = !this.param.isSRGBIntentSet() ? this.param.getChromaticity() : srgbChroma;
            int n2 = 0;
            while (n2 < 8) {
                chunkStream.writeInt((int)(fArray[n2] * 100000.0f));
                ++n2;
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeGAMA() throws IOException {
        if (this.param.isGammaSet() || this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("gAMA");
            float f2 = !this.param.isSRGBIntentSet() ? this.param.getGamma() : 0.45454544f;
            chunkStream.writeInt((int)(f2 * 100000.0f));
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeICCP() throws IOException {
        if (this.param.isICCProfileDataSet()) {
            ChunkStream chunkStream = new ChunkStream("iCCP");
            String string = this.param.getICCProfileName();
            if (string == null || string.length() < 1) {
                string = "JAI-Placed Profile";
            } else if ((string = string.trim()).length() > 79) {
                string = string.substring(0, 79);
            }
            byte[] byArray = string.getBytes("ISO-8859-1");
            int n2 = PNGImageEncoder.filterPrintableLatin1(byArray);
            byte[] byArray2 = this.param.getICCProfileData();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray2);
            deflaterOutputStream.finish();
            chunkStream.write(byArray, 0, n2);
            chunkStream.writeByte(0);
            chunkStream.writeByte(0);
            chunkStream.write(byteArrayOutputStream.toByteArray());
            deflaterOutputStream.close();
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeSBIT() throws IOException {
        if (this.param.isSignificantBitsSet()) {
            ChunkStream chunkStream = new ChunkStream("sBIT");
            int[] nArray = this.param.getSignificantBits();
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                chunkStream.writeByte(nArray[n3]);
                ++n3;
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeSRGB() throws IOException {
        if (this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("sRGB");
            int n2 = this.param.getSRGBIntent();
            chunkStream.write(n2);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writePLTE() throws IOException {
        if (this.redPalette == null) {
            return;
        }
        ChunkStream chunkStream = new ChunkStream("PLTE");
        int n2 = 0;
        while (n2 < this.redPalette.length) {
            chunkStream.writeByte(this.redPalette[n2]);
            chunkStream.writeByte(this.greenPalette[n2]);
            chunkStream.writeByte(this.bluePalette[n2]);
            ++n2;
        }
        chunkStream.writeToStream(this.dataOutput);
    }

    private void writeBKGD() throws IOException {
        if (this.param.isBackgroundSet()) {
            ChunkStream chunkStream = new ChunkStream("bKGD");
            switch (this.colorType) {
                case 0: 
                case 4: {
                    int n2 = ((PNGEncodeParam.Gray)this.param).getBackgroundGray();
                    chunkStream.writeShort(n2);
                    break;
                }
                case 3: {
                    int n3 = ((PNGEncodeParam.Palette)this.param).getBackgroundPaletteIndex();
                    chunkStream.writeByte(n3);
                    break;
                }
                case 2: 
                case 6: {
                    int[] nArray = ((PNGEncodeParam.RGB)this.param).getBackgroundRGB();
                    chunkStream.writeShort(nArray[0]);
                    chunkStream.writeShort(nArray[1]);
                    chunkStream.writeShort(nArray[2]);
                }
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeHIST() throws IOException {
        if (this.param.isPaletteHistogramSet()) {
            ChunkStream chunkStream = new ChunkStream("hIST");
            int[] nArray = this.param.getPaletteHistogram();
            int n2 = 0;
            while (n2 < nArray.length) {
                chunkStream.writeShort(nArray[n2]);
                ++n2;
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeTRNS() throws IOException {
        if (this.param.isTransparencySet() && this.colorType != 4 && this.colorType != 6) {
            ChunkStream chunkStream = new ChunkStream("tRNS");
            if (this.param instanceof PNGEncodeParam.Palette) {
                byte[] byArray = ((PNGEncodeParam.Palette)this.param).getPaletteTransparency();
                int n2 = 0;
                while (n2 < byArray.length) {
                    chunkStream.writeByte(byArray[n2]);
                    ++n2;
                }
            } else if (this.param instanceof PNGEncodeParam.Gray) {
                int n3 = ((PNGEncodeParam.Gray)this.param).getTransparentGray();
                chunkStream.writeShort(n3);
            } else if (this.param instanceof PNGEncodeParam.RGB) {
                int[] nArray = ((PNGEncodeParam.RGB)this.param).getTransparentRGB();
                chunkStream.writeShort(nArray[0]);
                chunkStream.writeShort(nArray[1]);
                chunkStream.writeShort(nArray[2]);
            }
            chunkStream.writeToStream(this.dataOutput);
        } else if (this.colorType == 3) {
            int n4;
            int n5 = n4 = Math.min(255, this.alphaPalette.length - 1);
            while (n5 >= 0) {
                if (this.alphaPalette[n5] != -1) break;
                --n5;
            }
            if (n5 >= 0) {
                ChunkStream chunkStream = new ChunkStream("tRNS");
                int n6 = 0;
                while (n6 <= n5) {
                    chunkStream.writeByte(this.alphaPalette[n6]);
                    ++n6;
                }
                chunkStream.writeToStream(this.dataOutput);
            }
        }
    }

    private void writePHYS() throws IOException {
        if (this.param.isPhysicalDimensionSet()) {
            ChunkStream chunkStream = new ChunkStream("pHYs");
            int[] nArray = this.param.getPhysicalDimension();
            chunkStream.writeInt(nArray[0]);
            chunkStream.writeInt(nArray[1]);
            chunkStream.writeByte((byte)nArray[2]);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeSPLT() throws IOException {
        if (this.param.isSuggestedPaletteSet()) {
            ChunkStream chunkStream = new ChunkStream("sPLT");
            System.out.println("sPLT not supported yet.");
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeTIME() throws IOException {
        if (this.param.isModificationTimeSet()) {
            ChunkStream chunkStream = new ChunkStream("tIME");
            Date date = this.param.getModificationTime();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setTime(date);
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(2);
            int n4 = gregorianCalendar.get(5);
            int n5 = gregorianCalendar.get(11);
            int n6 = gregorianCalendar.get(12);
            int n7 = gregorianCalendar.get(13);
            chunkStream.writeShort(n2);
            chunkStream.writeByte(n3 + 1);
            chunkStream.writeByte(n4);
            chunkStream.writeByte(n5);
            chunkStream.writeByte(n6);
            chunkStream.writeByte(n7);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeTEXT() throws IOException {
        if (this.param.isTextSet()) {
            String[] stringArray = this.param.getText();
            int n2 = 0;
            while (n2 < stringArray.length / 2) {
                stringArray[n2 << 1] = stringArray[n2 << 1].trim();
                byte[] byArray = stringArray[2 * n2].getBytes("ISO-8859-1");
                int n3 = PNGImageEncoder.filterPrintableLatin1(byArray);
                ChunkStream chunkStream = new ChunkStream("tEXt");
                chunkStream.write(byArray, 0, Math.min(n3, 79));
                stringArray[(n2 << 1) + 1] = stringArray[(n2 << 1) + 1].trim();
                byte[] byArray2 = stringArray[(n2 << 1) + 1].getBytes();
                n3 = PNGImageEncoder.filterPrintableLatin1(byArray2);
                chunkStream.write(0);
                chunkStream.write(byArray2, 0, n3);
                chunkStream.writeToStream(this.dataOutput);
                ++n2;
            }
        }
    }

    private void writeZTXT() throws IOException {
        if (this.param.isCompressedTextSet()) {
            String[] stringArray = this.param.getCompressedText();
            int n2 = 0;
            while (n2 < stringArray.length / 2) {
                stringArray[n2 << 1] = stringArray[n2 << 1].trim();
                byte[] byArray = stringArray[2 * n2].getBytes();
                int n3 = PNGImageEncoder.filterPrintableLatin1(byArray);
                ChunkStream chunkStream = new ChunkStream("zTXt");
                chunkStream.write(byArray, 0, Math.min(n3, 79));
                stringArray[(n2 << 1) + 1] = stringArray[(n2 << 1) + 1].trim();
                byte[] byArray2 = stringArray[2 * n2 + 1].getBytes();
                n3 = PNGImageEncoder.filterPrintableLatin1(byArray2);
                chunkStream.write(0);
                chunkStream.write(0);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(chunkStream);
                deflaterOutputStream.write(byArray2, 0, n3);
                deflaterOutputStream.finish();
                chunkStream.writeToStream(this.dataOutput);
                ++n2;
            }
        }
    }

    private void writePrivateChunks() throws IOException {
        int n2 = this.param.getNumPrivateChunks();
        int n3 = 0;
        while (n3 < n2) {
            String string = this.param.getPrivateChunkType(n3);
            char c2 = string.charAt(3);
            byte[] byArray = this.param.getPrivateChunkData(n3);
            ChunkStream chunkStream = new ChunkStream(string);
            chunkStream.write(byArray);
            chunkStream.writeToStream(this.dataOutput);
            ++n3;
        }
    }

    private PNGEncodeParam.Gray createGrayParam(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        PNGEncodeParam.Gray gray = new PNGEncodeParam.Gray();
        int n2 = 0;
        int n3 = 255 / ((1 << this.bitDepth) - 1);
        int n4 = 1 << this.bitDepth;
        int n5 = 0;
        while (n5 < n4) {
            byte by = byArray[n5];
            if (by != n5 * n3 || by != byArray2[n5] || by != byArray3[n5]) {
                return null;
            }
            byte by2 = byArray4[n5];
            if (by2 == 0) {
                gray.setTransparentGray(n5);
                if (++n2 > 1) {
                    return null;
                }
            } else if (by2 != -1) {
                return null;
            }
            ++n5;
        }
        return gray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(RenderedImage renderedImage) throws IOException {
        Object object;
        this.image = renderedImage;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        SampleModel sampleModel = this.image.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        this.bitDepth = -1;
        this.bitShift = 0;
        if (this.param instanceof PNGEncodeParam.Gray) {
            object = (PNGEncodeParam.Gray)this.param;
            if (((PNGEncodeParam.Gray)object).isBitDepthSet()) {
                this.bitDepth = ((PNGEncodeParam)object).getBitDepth();
            }
            if (((PNGEncodeParam.Gray)object).isBitShiftSet()) {
                this.bitShift = ((PNGEncodeParam.Gray)object).getBitShift();
            }
        }
        if (this.bitDepth == -1) {
            this.bitDepth = nArray[0];
            int n2 = 1;
            while (n2 < nArray.length) {
                if (nArray[n2] != this.bitDepth) {
                    throw new RuntimeException();
                }
                ++n2;
            }
            if (this.bitDepth > 2 && this.bitDepth < 4) {
                this.bitDepth = 4;
            } else if (this.bitDepth > 4 && this.bitDepth < 8) {
                this.bitDepth = 8;
            } else if (this.bitDepth > 8 && this.bitDepth < 16) {
                this.bitDepth = 16;
            } else if (this.bitDepth > 16) {
                throw new RuntimeException();
            }
        }
        this.numBands = sampleModel.getNumBands();
        this.bpp = this.numBands * (this.bitDepth == 16 ? 2 : 1);
        object = this.image.getColorModel();
        if (object instanceof IndexColorModel) {
            if (this.bitDepth < 1 || this.bitDepth > 8) {
                throw new RuntimeException();
            }
            if (sampleModel.getNumBands() != 1) {
                throw new RuntimeException();
            }
            IndexColorModel indexColorModel = (IndexColorModel)object;
            int n3 = indexColorModel.getMapSize();
            this.redPalette = new byte[n3];
            this.greenPalette = new byte[n3];
            this.bluePalette = new byte[n3];
            this.alphaPalette = new byte[n3];
            indexColorModel.getReds(this.redPalette);
            indexColorModel.getGreens(this.greenPalette);
            indexColorModel.getBlues(this.bluePalette);
            indexColorModel.getAlphas(this.alphaPalette);
            this.bpp = 1;
            if (this.param == null) {
                this.param = this.createGrayParam(this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette);
            }
            if (this.param == null) {
                this.param = new PNGEncodeParam.Palette();
            }
            if (this.param instanceof PNGEncodeParam.Palette) {
                PNGEncodeParam.Palette palette = (PNGEncodeParam.Palette)this.param;
                if (palette.isPaletteSet()) {
                    int[] nArray2 = palette.getPalette();
                    n3 = nArray2.length / 3;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3) {
                        this.redPalette[n5] = (byte)nArray2[n4++];
                        this.greenPalette[n5] = (byte)nArray2[n4++];
                        this.bluePalette[n5] = (byte)nArray2[n4++];
                        this.alphaPalette[n5] = -1;
                        ++n5;
                    }
                }
                this.colorType = 3;
            } else {
                if (!(this.param instanceof PNGEncodeParam.Gray)) throw new RuntimeException();
                this.alphaPalette = null;
                this.bluePalette = null;
                this.greenPalette = null;
                this.redPalette = null;
                this.colorType = 0;
            }
        } else if (this.numBands == 1) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.Gray();
            }
            this.colorType = 0;
        } else if (this.numBands == 2) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.Gray();
            }
            if (this.param.isTransparencySet()) {
                this.skipAlpha = true;
                this.numBands = 1;
                if (nArray[0] == 8 && this.bitDepth < 8) {
                    this.compressGray = true;
                }
                this.bpp = this.bitDepth == 16 ? 2 : 1;
                this.colorType = 0;
            } else {
                if (this.bitDepth < 8) {
                    this.bitDepth = 8;
                }
                this.colorType = 4;
            }
        } else if (this.numBands == 3) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.RGB();
            }
            this.colorType = 2;
        } else if (this.numBands == 4) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.RGB();
            }
            if (this.param.isTransparencySet()) {
                this.skipAlpha = true;
                this.numBands = 3;
                this.bpp = this.bitDepth == 16 ? 6 : 3;
                this.colorType = 2;
            } else {
                this.colorType = 6;
            }
        }
        this.interlace = this.param.getInterlacing();
        this.writeMagic();
        this.writeIHDR();
        this.writeCHRM();
        this.writeGAMA();
        this.writeICCP();
        this.writeSBIT();
        this.writeSRGB();
        this.writePLTE();
        this.writeHIST();
        this.writeTRNS();
        this.writeBKGD();
        this.writePHYS();
        this.writeSPLT();
        this.writeTIME();
        this.writeTEXT();
        this.writeZTXT();
        this.writePrivateChunks();
        this.writeIDAT();
        this.writeIEND();
        this.dataOutput.flush();
    }
}

