/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.PNGDecodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.PNGChunk;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class PNGImage
extends SimpleRenderedImage {
    public static final int PNG_COLOR_GRAY = 0;
    public static final int PNG_COLOR_RGB = 2;
    public static final int PNG_COLOR_PALETTE = 3;
    public static final int PNG_COLOR_GRAY_ALPHA = 4;
    public static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final String[] colorTypeNames = new String[]{"Grayscale", "Error", "Truecolor", "Index", "Grayscale with alpha", "Error", "Truecolor with alpha"};
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    private static final int RED_OFFSET = 2;
    private static final int GREEN_OFFSET = 1;
    private static final int BLUE_OFFSET = 0;
    private int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int paletteEntries;
    private byte[] redPalette;
    private byte[] greenPalette;
    private byte[] bluePalette;
    private byte[] alphaPalette;
    private int bkgdRed;
    private int bkgdGreen;
    private int bkgdBlue;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;
    private int maxOpacity;
    private int[] significantBits = null;
    private boolean hasBackground = false;
    private boolean suppressAlpha = false;
    private boolean expandPalette = false;
    private boolean output8BitGray = false;
    private boolean outputHasAlphaPalette = false;
    private boolean performGammaCorrection = false;
    private boolean expandGrayAlpha = false;
    private boolean generateEncodeParam = false;
    private PNGDecodeParam decodeParam = null;
    private PNGEncodeParam encodeParam = null;
    private boolean emitProperties = true;
    private float fileGamma = 0.45455f;
    private float userExponent = 1.0f;
    private float displayExponent = 2.2f;
    private float[] chromaticity = null;
    private int sRGBRenderingIntent = -1;
    private ICC_Profile iccProfile = null;
    private String iccProfileName = null;
    private int postProcess = 0;
    private static final int POST_NONE = 0;
    private static final int POST_GAMMA = 1;
    private static final int POST_GRAY_LUT = 2;
    private static final int POST_GRAY_LUT_ADD_TRANS = 3;
    private static final int POST_PALETTE_TO_RGB = 4;
    private static final int POST_PALETTE_TO_RGBA = 5;
    private static final int POST_ADD_GRAY_TRANS = 6;
    private static final int POST_ADD_RGB_TRANS = 7;
    private static final int POST_REMOVE_GRAY_TRANS = 8;
    private static final int POST_REMOVE_RGB_TRANS = 9;
    private static final int POST_EXP_MASK = 16;
    private static final int POST_GRAY_ALPHA_EXP = 16;
    private static final int POST_GAMMA_EXP = 17;
    private static final int POST_GRAY_LUT_ADD_TRANS_EXP = 19;
    private static final int POST_ADD_GRAY_TRANS_EXP = 22;
    private Vector streamVec = new Vector();
    private DataInputStream dataStream;
    private int bytesPerPixel;
    private int inputBands;
    private int outputBands;
    private int chunkIndex = 0;
    private Vector textKeys = new Vector();
    private Vector textStrings = new Vector();
    private Vector ztextKeys = new Vector();
    private Vector ztextStrings = new Vector();
    private WritableRaster theTile;
    private int[] gammaLut = null;
    private final byte[][] expandBits = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
    private int[] grayLut = null;
    static /* synthetic */ Class class$com$sun$media$jai$codecimpl$PNGImageDecoder;

    private void initGammaLut(int n2) {
        double d2 = (double)this.userExponent / (double)(this.fileGamma * this.displayExponent);
        int n3 = 1 << n2;
        int n4 = n2 == 16 ? 65535 : 255;
        this.gammaLut = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            double d3 = (double)n5 / (double)(n3 - 1);
            double d4 = Math.pow(d3, d2);
            int n6 = (int)(d4 * (double)n4 + 0.5);
            if (n6 > n4) {
                n6 = n4;
            }
            this.gammaLut[n5] = n6;
            ++n5;
        }
    }

    private void initGrayLut(int n2) {
        int n3 = 1 << n2;
        this.grayLut = new int[n3];
        if (this.performGammaCorrection) {
            int n4 = 0;
            while (n4 < n3) {
                this.grayLut[n4] = this.gammaLut[n4];
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                this.grayLut[n5] = this.expandBits[n2][n5];
                ++n5;
            }
        }
    }

    public PNGImage(InputStream inputStream, PNGDecodeParam pNGDecodeParam) throws IOException {
        String string;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (pNGDecodeParam == null) {
            pNGDecodeParam = new PNGDecodeParam();
        }
        this.decodeParam = pNGDecodeParam;
        this.suppressAlpha = pNGDecodeParam.getSuppressAlpha();
        this.expandPalette = pNGDecodeParam.getExpandPalette();
        this.output8BitGray = pNGDecodeParam.getOutput8BitGray();
        this.expandGrayAlpha = pNGDecodeParam.getExpandGrayAlpha();
        if (pNGDecodeParam.getPerformGammaCorrection()) {
            this.userExponent = pNGDecodeParam.getUserExponent();
            this.displayExponent = pNGDecodeParam.getDisplayExponent();
            this.performGammaCorrection = true;
            this.output8BitGray = true;
        }
        this.generateEncodeParam = pNGDecodeParam.getGenerateEncodeParam();
        if (this.emitProperties) {
            this.properties.put("file_type", "PNG v. 1.0");
        }
        try {
            long l2 = dataInputStream.readLong();
            if (l2 != -8552249625308161526L) {
                String string2 = JaiI18N.getString("PNGImageDecoder0");
                throw new RuntimeException(string2);
            }
        }
        catch (Exception exception) {
            string = JaiI18N.getString("PNGImageDecoder1");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
        }
        block4: while (true) {
            try {
                while (true) {
                    PNGChunk pNGChunk;
                    if ((string = PNGImage.getChunkType(dataInputStream)).equals("IHDR")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_IHDR_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("PLTE")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_PLTE_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("IDAT")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.streamVec.add(new ByteArrayInputStream(pNGChunk.getData()));
                        continue;
                    }
                    if (string.equals("IEND")) {
                        PNGChunk pNGChunk2 = PNGImage.readChunk(dataInputStream);
                        this.parse_IEND_chunk(pNGChunk2);
                        break block4;
                    }
                    if (string.equals("bKGD")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_bKGD_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("cHRM")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_cHRM_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("gAMA")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_gAMA_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("hIST")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_hIST_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("iCCP")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_iCCP_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("pHYs")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_pHYs_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("sBIT")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_sBIT_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("sRGB")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_sRGB_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("tEXt")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_tEXt_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("tIME")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_tIME_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("tRNS")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_tRNS_chunk(pNGChunk);
                        continue;
                    }
                    if (string.equals("zTXt")) {
                        pNGChunk = PNGImage.readChunk(dataInputStream);
                        this.parse_zTXt_chunk(pNGChunk);
                        continue;
                    }
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    String string3 = pNGChunk.getTypeString();
                    byte[] byArray = pNGChunk.getData();
                    if (this.encodeParam != null) {
                        this.encodeParam.addPrivateChunk(string3, byArray);
                    }
                    if (!this.emitProperties) continue;
                    String string4 = "chunk_" + this.chunkIndex++ + ":" + string3;
                    this.properties.put(string4.toLowerCase(), byArray);
                }
            }
            catch (Exception exception) {
                string = JaiI18N.getString("PNGImageDecoder2");
                ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
                continue;
            }
            break;
        }
        if (this.significantBits == null) {
            this.significantBits = new int[this.inputBands];
            int n2 = 0;
            while (n2 < this.inputBands) {
                this.significantBits[n2] = this.bitDepth;
                ++n2;
            }
            if (this.emitProperties) {
                this.properties.put("significant_bits", this.significantBits);
            }
        }
    }

    private static String getChunkType(DataInputStream dataInputStream) {
        try {
            dataInputStream.mark(8);
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            dataInputStream.reset();
            String string = new String();
            string = string + (char)(n3 >> 24);
            string = string + (char)(n3 >> 16 & 0xFF);
            string = string + (char)(n3 >> 8 & 0xFF);
            string = string + (char)(n3 & 0xFF);
            return string;
        }
        catch (Exception exception) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PNGImageDecoder20"), exception, class$com$sun$media$jai$codecimpl$PNGImageDecoder == null ? (class$com$sun$media$jai$codecimpl$PNGImageDecoder = PNGImage.class$("com.sun.media.jai.codecimpl.PNGImageDecoder")) : class$com$sun$media$jai$codecimpl$PNGImageDecoder, false);
            return null;
        }
    }

    private static PNGChunk readChunk(DataInputStream dataInputStream) {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            int n4 = dataInputStream.readInt();
            return new PNGChunk(n2, n3, byArray, n4);
        }
        catch (Exception exception) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PNGImageDecoder21"), exception, class$com$sun$media$jai$codecimpl$PNGImageDecoder == null ? (class$com$sun$media$jai$codecimpl$PNGImageDecoder = PNGImage.class$("com.sun.media.jai.codecimpl.PNGImageDecoder")) : class$com$sun$media$jai$codecimpl$PNGImageDecoder, false);
            return null;
        }
    }

    private void parse_IHDR_chunk(PNGChunk pNGChunk) {
        this.tileWidth = this.width = pNGChunk.getInt4(0);
        this.tileHeight = this.height = pNGChunk.getInt4(4);
        this.bitDepth = pNGChunk.getInt1(8);
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder3"));
        }
        this.maxOpacity = (1 << this.bitDepth) - 1;
        this.colorType = pNGChunk.getInt1(9);
        if (this.colorType != 0 && this.colorType != 2 && this.colorType != 3 && this.colorType != 4 && this.colorType != 6) {
            System.out.println(JaiI18N.getString("PNGImageDecoder4"));
        }
        if (this.colorType == 2 && this.bitDepth < 8) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder5"));
        }
        if (this.colorType == 3 && this.bitDepth == 16) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder6"));
        }
        if (this.colorType == 4 && this.bitDepth < 8) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder7"));
        }
        if (this.colorType == 6 && this.bitDepth < 8) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder8"));
        }
        if (this.emitProperties) {
            this.properties.put("color_type", colorTypeNames[this.colorType]);
        }
        if (this.generateEncodeParam) {
            this.encodeParam = this.colorType == 3 ? new PNGEncodeParam.Palette() : (this.colorType == 0 || this.colorType == 4 ? new PNGEncodeParam.Gray() : new PNGEncodeParam.RGB());
            this.decodeParam.setEncodeParam(this.encodeParam);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setBitDepth(this.bitDepth);
        }
        if (this.emitProperties) {
            this.properties.put("bit_depth", new Integer(this.bitDepth));
        }
        if (this.performGammaCorrection) {
            float f2 = 0.45454544f * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f2);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", new Float(f2));
            }
        }
        this.compressionMethod = pNGChunk.getInt1(10);
        if (this.compressionMethod != 0) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder9"));
        }
        this.filterMethod = pNGChunk.getInt1(11);
        if (this.filterMethod != 0) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder10"));
        }
        this.interlaceMethod = pNGChunk.getInt1(12);
        if (this.interlaceMethod == 0) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(false);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "None");
            }
        } else if (this.interlaceMethod == 1) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(true);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "Adam7");
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder11"));
        }
        this.bytesPerPixel = this.bitDepth == 16 ? 2 : 1;
        switch (this.colorType) {
            case 0: {
                this.inputBands = 1;
                this.outputBands = 1;
                if (this.output8BitGray && this.bitDepth < 8) {
                    this.postProcess = 2;
                    break;
                }
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 2: {
                this.inputBands = 3;
                this.bytesPerPixel *= 3;
                this.outputBands = 3;
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 3: {
                this.inputBands = 1;
                this.bytesPerPixel = 1;
                int n2 = this.outputBands = this.expandPalette ? 3 : 1;
                if (this.expandPalette) {
                    this.postProcess = 4;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 4: {
                this.inputBands = 2;
                this.bytesPerPixel *= 2;
                if (this.suppressAlpha) {
                    this.outputBands = 1;
                    this.postProcess = 8;
                    break;
                }
                this.postProcess = this.performGammaCorrection ? 1 : 0;
                if (this.expandGrayAlpha) {
                    this.postProcess |= 0x10;
                    this.outputBands = 4;
                    break;
                }
                this.outputBands = 2;
                break;
            }
            case 6: {
                this.inputBands = 4;
                this.bytesPerPixel *= 4;
                int n3 = this.outputBands = !this.suppressAlpha ? 4 : 3;
                this.postProcess = this.suppressAlpha ? 9 : (this.performGammaCorrection ? 1 : 0);
            }
        }
    }

    private void parse_IEND_chunk(PNGChunk pNGChunk) throws Exception {
        Object object;
        Object object2;
        String[] stringArray;
        int n2 = this.textKeys.size();
        String[] stringArray2 = new String[2 * n2];
        int n3 = 0;
        while (n3 < n2) {
            String string = (String)this.textKeys.elementAt(n3);
            stringArray = (String)this.textStrings.elementAt(n3);
            stringArray2[2 * n3] = string;
            stringArray2[2 * n3 + 1] = stringArray;
            if (this.emitProperties) {
                String string2 = "text_" + n3 + ":" + string;
                this.properties.put(string2.toLowerCase(), stringArray);
            }
            ++n3;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setText(stringArray2);
        }
        int n4 = this.ztextKeys.size();
        stringArray = new String[2 * n4];
        int n5 = 0;
        while (n5 < n4) {
            object2 = (String)this.ztextKeys.elementAt(n5);
            object = (String)this.ztextStrings.elementAt(n5);
            stringArray[2 * n5] = object2;
            stringArray[2 * n5 + 1] = object;
            if (this.emitProperties) {
                String string = "ztext_" + n5 + ":" + (String)object2;
                this.properties.put(string.toLowerCase(), object);
            }
            ++n5;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setCompressedText(stringArray);
        }
        if (this.sRGBRenderingIntent != -1 && this.iccProfile != null) {
            this.iccProfile = null;
        }
        if (this.encodeParam != null && this.iccProfile != null) {
            this.encodeParam.setICCProfileData(this.iccProfile.getData());
            this.encodeParam.setICCProfileName(this.iccProfileName);
        }
        object2 = new SequenceInputStream(this.streamVec.elements());
        object = new InflaterInputStream((InputStream)object2, new Inflater());
        this.dataStream = new DataInputStream((InputStream)object);
        int n6 = this.bitDepth;
        if (this.colorType == 0 && this.bitDepth < 8 && this.output8BitGray) {
            n6 = 8;
        }
        if (this.colorType == 3 && this.expandPalette) {
            n6 = 8;
        }
        int n7 = (this.outputBands * this.width * n6 + 7) / 8;
        int n8 = n6 == 16 ? n7 / 2 : n7;
        this.theTile = this.createRaster(this.width, this.height, this.outputBands, n8, n6);
        if (this.performGammaCorrection && this.gammaLut == null) {
            this.initGammaLut(this.bitDepth);
        }
        if (this.postProcess == 2 || this.postProcess == 3 || this.postProcess == 19) {
            this.initGrayLut(this.bitDepth);
        }
        this.decodeImage(this.interlaceMethod == 1);
        this.sampleModel = this.theTile.getSampleModel();
        if (this.colorType == 3 && !this.expandPalette) {
            this.colorModel = this.outputHasAlphaPalette ? new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette) : new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette);
        } else if (this.colorType == 0 && this.bitDepth < 8 && !this.output8BitGray) {
            byte[] byArray = this.expandBits[this.bitDepth];
            this.colorModel = new IndexColorModel(this.bitDepth, byArray.length, byArray, byArray, byArray);
        } else {
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel, this.iccProfile == null ? null : new ICC_ColorSpace(this.iccProfile));
        }
    }

    private void parse_PLTE_chunk(PNGChunk pNGChunk) {
        this.paletteEntries = pNGChunk.getLength() / 3;
        this.redPalette = new byte[this.paletteEntries];
        this.greenPalette = new byte[this.paletteEntries];
        this.bluePalette = new byte[this.paletteEntries];
        int n2 = 0;
        if (this.performGammaCorrection) {
            if (this.gammaLut == null) {
                this.initGammaLut(this.bitDepth == 16 ? 16 : 8);
            }
            int n3 = 0;
            while (n3 < this.paletteEntries) {
                byte by = pNGChunk.getByte(n2++);
                byte by2 = pNGChunk.getByte(n2++);
                byte by3 = pNGChunk.getByte(n2++);
                this.redPalette[n3] = (byte)this.gammaLut[by & 0xFF];
                this.greenPalette[n3] = (byte)this.gammaLut[by2 & 0xFF];
                this.bluePalette[n3] = (byte)this.gammaLut[by3 & 0xFF];
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.paletteEntries) {
                this.redPalette[n4] = pNGChunk.getByte(n2++);
                this.greenPalette[n4] = pNGChunk.getByte(n2++);
                this.bluePalette[n4] = pNGChunk.getByte(n2++);
                ++n4;
            }
        }
    }

    private void parse_bKGD_chunk(PNGChunk pNGChunk) {
        this.hasBackground = true;
        switch (this.colorType) {
            case 3: {
                int n2 = pNGChunk.getByte(0) & 0xFF;
                this.bkgdRed = this.redPalette[n2] & 0xFF;
                this.bkgdGreen = this.greenPalette[n2] & 0xFF;
                this.bkgdBlue = this.bluePalette[n2] & 0xFF;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Palette)this.encodeParam).setBackgroundPaletteIndex(n2);
                break;
            }
            case 0: 
            case 4: {
                int n3;
                this.bkgdGreen = this.bkgdBlue = (n3 = pNGChunk.getInt2(0));
                this.bkgdRed = this.bkgdBlue;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Gray)this.encodeParam).setBackgroundGray(n3);
                break;
            }
            case 2: 
            case 6: {
                int n4 = (1 << this.bitDepth) - 1;
                this.bkgdRed = pNGChunk.getInt2(0) & n4;
                this.bkgdGreen = pNGChunk.getInt2(2) & n4;
                this.bkgdBlue = pNGChunk.getInt2(4) & n4;
                int[] nArray = new int[]{this.bkgdRed, this.bkgdGreen, this.bkgdBlue};
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.RGB)this.encodeParam).setBackgroundRGB(nArray);
            }
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.bitDepth < 8) {
            n5 = this.expandBits[this.bitDepth][this.bkgdRed];
            n6 = this.expandBits[this.bitDepth][this.bkgdGreen];
            n7 = this.expandBits[this.bitDepth][this.bkgdBlue];
        } else if (this.bitDepth == 8) {
            n5 = this.bkgdRed;
            n6 = this.bkgdGreen;
            n7 = this.bkgdBlue;
        } else if (this.bitDepth == 16) {
            n5 = this.bkgdRed >> 8;
            n6 = this.bkgdGreen >> 8;
            n7 = this.bkgdBlue >> 8;
        }
        if (this.emitProperties) {
            this.properties.put("background_color", new Color(n5, n6, n7));
        }
    }

    private void parse_cHRM_chunk(PNGChunk pNGChunk) {
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.chromaticity = new float[8];
        this.chromaticity[0] = (float)pNGChunk.getInt4(0) / 100000.0f;
        this.chromaticity[1] = (float)pNGChunk.getInt4(4) / 100000.0f;
        this.chromaticity[2] = (float)pNGChunk.getInt4(8) / 100000.0f;
        this.chromaticity[3] = (float)pNGChunk.getInt4(12) / 100000.0f;
        this.chromaticity[4] = (float)pNGChunk.getInt4(16) / 100000.0f;
        this.chromaticity[5] = (float)pNGChunk.getInt4(20) / 100000.0f;
        this.chromaticity[6] = (float)pNGChunk.getInt4(24) / 100000.0f;
        this.chromaticity[7] = (float)pNGChunk.getInt4(28) / 100000.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setChromaticity(this.chromaticity);
        }
        if (this.emitProperties) {
            this.properties.put("white_point_x", new Float(this.chromaticity[0]));
            this.properties.put("white_point_y", new Float(this.chromaticity[1]));
            this.properties.put("red_x", new Float(this.chromaticity[2]));
            this.properties.put("red_y", new Float(this.chromaticity[3]));
            this.properties.put("green_x", new Float(this.chromaticity[4]));
            this.properties.put("green_y", new Float(this.chromaticity[5]));
            this.properties.put("blue_x", new Float(this.chromaticity[6]));
            this.properties.put("blue_y", new Float(this.chromaticity[7]));
        }
    }

    private void parse_gAMA_chunk(PNGChunk pNGChunk) {
        float f2;
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.fileGamma = (float)pNGChunk.getInt4(0) / 100000.0f;
        float f3 = f2 = this.performGammaCorrection ? this.displayExponent / this.userExponent : 1.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setGamma(this.fileGamma * f2);
        }
        if (this.emitProperties) {
            this.properties.put("gamma", new Float(this.fileGamma * f2));
        }
    }

    private void parse_hIST_chunk(PNGChunk pNGChunk) {
        if (this.redPalette == null) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder18"));
        }
        int n2 = this.redPalette.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = pNGChunk.getInt2(2 * n3);
            ++n3;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setPaletteHistogram(nArray);
        }
    }

    private void parse_iCCP_chunk(PNGChunk pNGChunk) {
        byte by;
        byte[] byArray = new byte[80];
        int n2 = 0;
        while (n2 < 79 && (by = pNGChunk.getByte(n2)) != 0) {
            byArray[n2++] = by;
        }
        byArray[n2] = 0;
        String string = new String(byArray);
        byte by2 = pNGChunk.getByte(n2++);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(pNGChunk.getData(), n2, pNGChunk.getLength() - n2));
        try {
            this.iccProfile = ICC_Profile.getInstance(inflaterInputStream);
            this.iccProfileName = string;
        }
        catch (IOException iOException) {
            this.iccProfile = null;
            this.iccProfileName = null;
        }
    }

    private void parse_pHYs_chunk(PNGChunk pNGChunk) {
        int n2 = pNGChunk.getInt4(0);
        int n3 = pNGChunk.getInt4(4);
        int n4 = pNGChunk.getInt1(8);
        if (this.encodeParam != null) {
            this.encodeParam.setPhysicalDimension(n2, n3, n4);
        }
        if (this.emitProperties) {
            this.properties.put("x_pixels_per_unit", new Integer(n2));
            this.properties.put("y_pixels_per_unit", new Integer(n3));
            this.properties.put("pixel_aspect_ratio", new Float((float)n2 / (float)n3));
            if (n4 == 1) {
                this.properties.put("pixel_units", "Meters");
            } else if (n4 != 0) {
                throw new RuntimeException(JaiI18N.getString("PNGImageDecoder12"));
            }
        }
    }

    private void parse_sBIT_chunk(PNGChunk pNGChunk) {
        this.significantBits = this.colorType == 3 ? new int[3] : new int[this.inputBands];
        int n2 = 0;
        while (n2 < this.significantBits.length) {
            int n3;
            int n4 = pNGChunk.getByte(n2);
            int n5 = n3 = this.colorType == 3 ? 8 : this.bitDepth;
            if (n4 <= 0 || n4 > n3) {
                throw new RuntimeException(JaiI18N.getString("PNGImageDecoder13"));
            }
            this.significantBits[n2] = n4;
            ++n2;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setSignificantBits(this.significantBits);
        }
        if (this.emitProperties) {
            this.properties.put("significant_bits", this.significantBits);
        }
    }

    private void parse_sRGB_chunk(PNGChunk pNGChunk) {
        this.sRGBRenderingIntent = pNGChunk.getByte(0);
        this.fileGamma = 0.45455f;
        this.chromaticity = new float[8];
        this.chromaticity[0] = 3.127f;
        this.chromaticity[1] = 3.29f;
        this.chromaticity[2] = 6.4f;
        this.chromaticity[3] = 3.3f;
        this.chromaticity[4] = 3.0f;
        this.chromaticity[5] = 6.0f;
        this.chromaticity[6] = 1.5f;
        this.chromaticity[7] = 0.6f;
        if (this.performGammaCorrection) {
            float f2 = this.fileGamma * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f2);
                this.encodeParam.setChromaticity(this.chromaticity);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", new Float(f2));
                this.properties.put("white_point_x", new Float(this.chromaticity[0]));
                this.properties.put("white_point_y", new Float(this.chromaticity[1]));
                this.properties.put("red_x", new Float(this.chromaticity[2]));
                this.properties.put("red_y", new Float(this.chromaticity[3]));
                this.properties.put("green_x", new Float(this.chromaticity[4]));
                this.properties.put("green_y", new Float(this.chromaticity[5]));
                this.properties.put("blue_x", new Float(this.chromaticity[6]));
                this.properties.put("blue_y", new Float(this.chromaticity[7]));
            }
        }
    }

    private void parse_tEXt_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        String string2 = new String();
        int n2 = 0;
        while ((by = pNGChunk.getByte(n2++)) != 0) {
            string = string + (char)by;
        }
        int n3 = n2;
        while (n3 < pNGChunk.getLength()) {
            string2 = string2 + (char)pNGChunk.getByte(n3);
            ++n3;
        }
        this.textKeys.add(string);
        this.textStrings.add(string2);
    }

    private void parse_tIME_chunk(PNGChunk pNGChunk) {
        int n2 = pNGChunk.getInt2(0);
        int n3 = pNGChunk.getInt1(2) - 1;
        int n4 = pNGChunk.getInt1(3);
        int n5 = pNGChunk.getInt1(4);
        int n6 = pNGChunk.getInt1(5);
        int n7 = pNGChunk.getInt1(6);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n2, n3, n4, n5, n6, n7);
        Date date = gregorianCalendar.getTime();
        if (this.encodeParam != null) {
            this.encodeParam.setModificationTime(date);
        }
        if (this.emitProperties) {
            this.properties.put("timestamp", date);
        }
    }

    private void parse_tRNS_chunk(PNGChunk pNGChunk) {
        if (this.colorType == 3) {
            int n2 = pNGChunk.getLength();
            if (n2 > this.paletteEntries) {
                throw new RuntimeException(JaiI18N.getString("PNGImageDecoder14"));
            }
            this.alphaPalette = new byte[this.paletteEntries];
            int n3 = 0;
            while (n3 < n2) {
                this.alphaPalette[n3] = pNGChunk.getByte(n3);
                ++n3;
            }
            int n4 = n2;
            while (n4 < this.paletteEntries) {
                this.alphaPalette[n4] = -1;
                ++n4;
            }
            if (!this.suppressAlpha) {
                if (this.expandPalette) {
                    this.postProcess = 5;
                    this.outputBands = 4;
                } else {
                    this.outputHasAlphaPalette = true;
                }
            }
        } else if (this.colorType == 0) {
            this.grayTransparentAlpha = pNGChunk.getInt2(0);
            if (!this.suppressAlpha) {
                if (this.bitDepth < 8) {
                    this.output8BitGray = true;
                    this.maxOpacity = 255;
                    this.postProcess = 3;
                } else {
                    this.postProcess = 6;
                }
                if (this.expandGrayAlpha) {
                    this.outputBands = 4;
                    this.postProcess |= 0x10;
                } else {
                    this.outputBands = 2;
                }
                if (this.encodeParam != null) {
                    ((PNGEncodeParam.Gray)this.encodeParam).setTransparentGray(this.grayTransparentAlpha);
                }
            }
        } else if (this.colorType == 2) {
            this.redTransparentAlpha = pNGChunk.getInt2(0);
            this.greenTransparentAlpha = pNGChunk.getInt2(2);
            this.blueTransparentAlpha = pNGChunk.getInt2(4);
            if (!this.suppressAlpha) {
                this.outputBands = 4;
                this.postProcess = 7;
                if (this.encodeParam != null) {
                    int[] nArray = new int[]{this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha};
                    ((PNGEncodeParam.RGB)this.encodeParam).setTransparentRGB(nArray);
                }
            }
        } else if (this.colorType == 4 || this.colorType == 6) {
            throw new RuntimeException(JaiI18N.getString("PNGImageDecoder15"));
        }
    }

    private void parse_zTXt_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        String string2 = new String();
        int n2 = 0;
        while ((by = pNGChunk.getByte(n2++)) != 0) {
            string = string + (char)by;
        }
        byte by2 = pNGChunk.getByte(n2++);
        try {
            int n3;
            int n4 = pNGChunk.getLength() - n2;
            byte[] byArray = pNGChunk.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n4);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            while ((n3 = ((InputStream)inflaterInputStream).read()) != -1) {
                string2 = string2 + (char)n3;
            }
            this.ztextKeys.add(string);
            this.ztextStrings.add(string2);
        }
        catch (Exception exception) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PNGImageDecoder21"), exception, this, false);
        }
    }

    private WritableRaster createRaster(int n2, int n3, int n4, int n5, int n6) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n6 < 8 && n4 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n3 * n5);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n2, n3, n6, point);
        } else if (n6 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n3 * n5);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n5, n4, this.bandOffsets[n4], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n3 * n5);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n2, n3, n5, n4, this.bandOffsets[n4], point);
        }
        return writableRaster;
    }

    private static void decodeSubFilter(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        while (n4 < n2) {
            int n5 = byArray[n4] & 0xFF;
            byArray[n4] = (byte)(n5 += byArray[n4 - n3] & 0xFF);
            ++n4;
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n3] & 0xFF;
            int n5 = byArray2[n3] & 0xFF;
            byArray[n3] = (byte)(n4 + n5);
            ++n3;
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        while (n6 < n3) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4 / 2);
            ++n6;
        }
        int n7 = n3;
        while (n7 < n2) {
            n5 = byArray[n7] & 0xFF;
            int n8 = byArray[n7 - n3] & 0xFF;
            n4 = byArray2[n7] & 0xFF;
            byArray[n7] = (byte)(n5 + (n8 + n4) / 2);
            ++n7;
        }
    }

    private static int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = Math.abs(n5 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = Math.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        while (n6 < n3) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4);
            ++n6;
        }
        int n7 = n3;
        while (n7 < n2) {
            n5 = byArray[n7] & 0xFF;
            int n8 = byArray[n7 - n3] & 0xFF;
            n4 = byArray2[n7] & 0xFF;
            int n9 = byArray2[n7 - n3] & 0xFF;
            byArray[n7] = (byte)(n5 + PNGImage.paethPredictor(n8, n4, n9));
            ++n7;
        }
    }

    private void processPixels(int n2, Raster raster, WritableRaster writableRaster, int n3, int n4, int n5, int n6) {
        int[] nArray = raster.getPixel(0, 0, (int[])null);
        int[] nArray2 = writableRaster.getPixel(0, 0, (int[])null);
        int n7 = n3;
        switch (n2) {
            case 0: {
                int n8 = 0;
                while (n8 < n6) {
                    raster.getPixel(n8, 0, nArray);
                    writableRaster.setPixel(n7, n5, nArray);
                    n7 += n4;
                    ++n8;
                }
                break;
            }
            case 1: {
                int n9 = 0;
                while (n9 < n6) {
                    raster.getPixel(n9, 0, nArray);
                    int n10 = 0;
                    while (n10 < this.inputBands) {
                        int n11 = nArray[n10];
                        nArray[n10] = this.gammaLut[n11];
                        ++n10;
                    }
                    writableRaster.setPixel(n7, n5, nArray);
                    n7 += n4;
                    ++n9;
                }
                break;
            }
            case 2: {
                int n12 = 0;
                while (n12 < n6) {
                    raster.getPixel(n12, 0, nArray);
                    nArray2[0] = this.grayLut[nArray[0]];
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n12;
                }
                break;
            }
            case 3: {
                int n13 = 0;
                while (n13 < n6) {
                    raster.getPixel(n13, 0, nArray);
                    int n14 = nArray[0];
                    nArray2[0] = this.grayLut[n14];
                    nArray2[1] = n14 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n13;
                }
                break;
            }
            case 4: {
                int n15 = 0;
                while (n15 < n6) {
                    raster.getPixel(n15, 0, nArray);
                    int n16 = nArray[0];
                    nArray2[0] = this.redPalette[n16];
                    nArray2[1] = this.greenPalette[n16];
                    nArray2[2] = this.bluePalette[n16];
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n15;
                }
                break;
            }
            case 5: {
                int n17 = 0;
                while (n17 < n6) {
                    raster.getPixel(n17, 0, nArray);
                    int n18 = nArray[0];
                    nArray2[0] = this.redPalette[n18];
                    nArray2[1] = this.greenPalette[n18];
                    nArray2[2] = this.bluePalette[n18];
                    nArray2[3] = this.alphaPalette[n18];
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n17;
                }
                break;
            }
            case 6: {
                int n19 = 0;
                while (n19 < n6) {
                    raster.getPixel(n19, 0, nArray);
                    int n20 = nArray[0];
                    if (this.performGammaCorrection) {
                        n20 = this.gammaLut[n20];
                    }
                    nArray2[0] = n20;
                    nArray2[1] = n20 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n19;
                }
                break;
            }
            case 7: {
                int n21 = 0;
                while (n21 < n6) {
                    raster.getPixel(n21, 0, nArray);
                    int n22 = nArray[0];
                    int n23 = nArray[1];
                    int n24 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n22];
                        nArray2[1] = this.gammaLut[n23];
                        nArray2[2] = this.gammaLut[n24];
                    } else {
                        nArray2[0] = n22;
                        nArray2[1] = n23;
                        nArray2[2] = n24;
                    }
                    nArray2[3] = n22 == this.redTransparentAlpha && n23 == this.greenTransparentAlpha && n24 == this.blueTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n21;
                }
                break;
            }
            case 8: {
                int n25 = 0;
                while (n25 < n6) {
                    raster.getPixel(n25, 0, nArray);
                    int n26 = nArray[0];
                    nArray2[0] = this.performGammaCorrection ? this.gammaLut[n26] : n26;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n25;
                }
                break;
            }
            case 9: {
                int n27 = 0;
                while (n27 < n6) {
                    raster.getPixel(n27, 0, nArray);
                    int n28 = nArray[0];
                    int n29 = nArray[1];
                    int n30 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n28];
                        nArray2[1] = this.gammaLut[n29];
                        nArray2[2] = this.gammaLut[n30];
                    } else {
                        nArray2[0] = n28;
                        nArray2[1] = n29;
                        nArray2[2] = n30;
                    }
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n27;
                }
                break;
            }
            case 17: {
                int n31 = 0;
                while (n31 < n6) {
                    int n32;
                    raster.getPixel(n31, 0, nArray);
                    int n33 = nArray[0];
                    int n34 = nArray[1];
                    nArray2[0] = n32 = this.gammaLut[n33];
                    nArray2[1] = n32;
                    nArray2[2] = n32;
                    nArray2[3] = n34;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n31;
                }
                break;
            }
            case 16: {
                int n35 = 0;
                while (n35 < n6) {
                    raster.getPixel(n35, 0, nArray);
                    int n36 = nArray[0];
                    int n37 = nArray[1];
                    nArray2[0] = n36;
                    nArray2[1] = n36;
                    nArray2[2] = n36;
                    nArray2[3] = n37;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n35;
                }
                break;
            }
            case 22: {
                int n38 = 0;
                while (n38 < n6) {
                    raster.getPixel(n38, 0, nArray);
                    int n39 = nArray[0];
                    if (this.performGammaCorrection) {
                        n39 = this.gammaLut[n39];
                    }
                    nArray2[0] = n39;
                    nArray2[1] = n39;
                    nArray2[2] = n39;
                    nArray2[3] = n39 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n38;
                }
                break;
            }
            case 19: {
                int n40 = 0;
                while (n40 < n6) {
                    int n41;
                    raster.getPixel(n40, 0, nArray);
                    int n42 = nArray[0];
                    nArray2[0] = n41 = this.grayLut[n42];
                    nArray2[1] = n41;
                    nArray2[2] = n41;
                    nArray2[3] = n42 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                    ++n40;
                }
                break;
            }
        }
    }

    private void decodePass(WritableRaster writableRaster, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 == 0 || n7 == 0) {
            return;
        }
        int n8 = (this.inputBands * n6 * this.bitDepth + 7) / 8;
        int n9 = this.bitDepth == 16 ? n8 / 2 : n8;
        byte[] byArray = new byte[n8];
        byte[] byArray2 = new byte[n8];
        WritableRaster writableRaster2 = this.createRaster(n6, 1, this.inputBands, n9, this.bitDepth);
        DataBuffer dataBuffer = writableRaster2.getDataBuffer();
        int n10 = dataBuffer.getDataType();
        byte[] byArray3 = null;
        short[] sArray = null;
        if (n10 == 0) {
            byArray3 = ((DataBufferByte)dataBuffer).getData();
        } else {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        }
        int n11 = 0;
        int n12 = n3;
        while (n11 < n7) {
            int n13 = 0;
            try {
                n13 = this.dataStream.read();
                this.dataStream.readFully(byArray, 0, n8);
            }
            catch (Exception exception) {
                ImagingListenerProxy.errorOccurred(JaiI18N.getString("PNGImageDecoder2"), exception, this, false);
            }
            switch (n13) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGImage.decodeSubFilter(byArray, n8, this.bytesPerPixel);
                    break;
                }
                case 2: {
                    PNGImage.decodeUpFilter(byArray, byArray2, n8);
                    break;
                }
                case 3: {
                    PNGImage.decodeAverageFilter(byArray, byArray2, n8, this.bytesPerPixel);
                    break;
                }
                case 4: {
                    PNGImage.decodePaethFilter(byArray, byArray2, n8, this.bytesPerPixel);
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("PNGImageDecoder16"));
                }
            }
            if (this.bitDepth < 16) {
                System.arraycopy(byArray, 0, byArray3, 0, n8);
            } else {
                int n14 = 0;
                int n15 = 0;
                while (n15 < n9) {
                    sArray[n15] = (short)(byArray[n14] << 8 | byArray[n14 + 1] & 0xFF);
                    n14 += 2;
                    ++n15;
                }
            }
            this.processPixels(this.postProcess, writableRaster2, writableRaster, n2, n4, n12, n6);
            byte[] byArray4 = byArray2;
            byArray2 = byArray;
            byArray = byArray4;
            ++n11;
            n12 += n5;
        }
    }

    private void decodeImage(boolean bl) {
        if (!bl) {
            this.decodePass(this.theTile, 0, 0, 1, 1, this.width, this.height);
        } else {
            this.decodePass(this.theTile, 0, 0, 8, 8, (this.width + 7) / 8, (this.height + 7) / 8);
            this.decodePass(this.theTile, 4, 0, 8, 8, (this.width + 3) / 8, (this.height + 7) / 8);
            this.decodePass(this.theTile, 0, 4, 4, 8, (this.width + 3) / 4, (this.height + 3) / 8);
            this.decodePass(this.theTile, 2, 0, 4, 4, (this.width + 1) / 4, (this.height + 3) / 4);
            this.decodePass(this.theTile, 0, 2, 2, 4, (this.width + 1) / 2, (this.height + 1) / 4);
            this.decodePass(this.theTile, 1, 0, 2, 2, this.width / 2, (this.height + 1) / 2);
            this.decodePass(this.theTile, 0, 1, 1, 2, this.width, this.height / 2);
        }
    }

    public Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("PNGImageDecoder17"));
        }
        return this.theTile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

