/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.Point;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

class GIFImage
extends SimpleRenderedImage {
    private static final int[] INTERLACE_INCREMENT = new int[]{8, 8, 4, 2, -1};
    private static final int[] INTERLACE_OFFSET = new int[]{0, 4, 2, 1, -1};
    private SeekableStream input;
    private boolean interlaceFlag;
    private byte[] block;
    private int blockLength;
    private int bitPos;
    private int nextByte;
    private int initCodeSize;
    private int clearCode;
    private int eofCode;
    private int bitsLeft;
    private int next32Bits;
    private boolean lastBlockFound;
    private int interlacePass;
    private WritableRaster theTile;

    private void skipBlocks() throws IOException {
        int n2;
        while ((n2 = this.input.readUnsignedByte()) != 0) {
            this.input.skipBytes(n2);
        }
    }

    GIFImage(SeekableStream seekableStream, byte[] byArray) throws IOException {
        int n2;
        int n3;
        int n4;
        boolean bl;
        byte[] byArray2;
        block12: {
            this.interlaceFlag = false;
            this.block = new byte[255];
            this.blockLength = 0;
            this.bitPos = 0;
            this.nextByte = 0;
            this.next32Bits = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.theTile = null;
            this.input = seekableStream;
            byArray2 = null;
            bl = false;
            n4 = 0;
            try {
                long l2 = seekableStream.getFilePointer();
                while (true) {
                    int n5;
                    if ((n3 = seekableStream.readUnsignedByte()) == 44) {
                        seekableStream.skipBytes(4);
                        this.width = seekableStream.readUnsignedShortLE();
                        this.height = seekableStream.readUnsignedShortLE();
                        n2 = seekableStream.readUnsignedByte();
                        n5 = (n2 & 0x80) != 0 ? 1 : 0;
                        this.interlaceFlag = (n2 & 0x40) != 0;
                        int n6 = 1 << (n2 & 7) + 1;
                        if (n5 != 0) {
                            byArray2 = new byte[3 * n6];
                            seekableStream.readFully(byArray2);
                        } else {
                            byArray2 = null;
                        }
                        break block12;
                    }
                    if (n3 != 33) break;
                    n2 = seekableStream.readUnsignedByte();
                    if (n2 == 249) {
                        seekableStream.read();
                        n5 = seekableStream.readUnsignedByte();
                        bl = (n5 & 1) != 0;
                        seekableStream.skipBytes(2);
                        n4 = seekableStream.readUnsignedByte();
                        seekableStream.read();
                        continue;
                    }
                    if (n2 == 1) {
                        seekableStream.skipBytes(13);
                        this.skipBlocks();
                        continue;
                    }
                    if (n2 == 254) {
                        this.skipBlocks();
                        continue;
                    }
                    if (n2 == 255) {
                        seekableStream.skipBytes(12);
                        this.skipBlocks();
                        continue;
                    }
                    n5 = 0;
                    do {
                        n5 = seekableStream.readUnsignedByte();
                        seekableStream.skipBytes(n5);
                    } while (n5 > 0);
                }
                throw new IOException(JaiI18N.getString("GIFImage0") + " " + n3 + "!");
            }
            catch (IOException iOException) {
                throw new IOException(JaiI18N.getString("GIFImage1"));
            }
        }
        this.tileGridYOffset = 0;
        this.tileGridXOffset = 0;
        this.minY = 0;
        this.minX = 0;
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        byte[] byArray3 = byArray2 != null ? byArray2 : byArray;
        int n7 = byArray3.length / 3;
        n3 = n7 == 2 ? 1 : (n7 == 4 ? 2 : (n7 == 8 || n7 == 16 ? 4 : 8));
        n2 = 1 << n3;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n7) {
            byArray4[n9] = byArray3[n8++];
            byArray5[n9] = byArray3[n8++];
            byArray6[n9] = byArray3[n8++];
            ++n9;
        }
        int[] nArray = new int[]{n3};
        this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
        this.colorModel = !bl ? (ImageCodec.isIndicesForGrayscale(byArray4, byArray5, byArray6) ? ImageCodec.createComponentColorModel(this.sampleModel) : new IndexColorModel(n3, byArray4.length, byArray4, byArray5, byArray6)) : new IndexColorModel(n3, byArray4.length, byArray4, byArray5, byArray6, n4);
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n2, int n3) throws IOException {
        if (this.bitsLeft <= 0) {
            return this.eofCode;
        }
        int n4 = this.next32Bits >> this.bitPos & n3;
        this.bitPos += n2;
        this.bitsLeft -= n2;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                this.blockLength = this.input.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    if (this.bitsLeft < 0) {
                        return this.eofCode;
                    }
                    return n4;
                }
                int n5 = this.blockLength;
                int n6 = 0;
                while (n5 > 0) {
                    int n7 = this.input.read(this.block, n6, n5);
                    n6 += n7;
                    n5 -= n7;
                }
                this.bitsLeft += this.blockLength << 3;
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n4;
    }

    private void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n2 = 1 << this.initCodeSize;
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = -1;
            byArray[n3] = (byte)n3;
            byArray2[n3] = (byte)n3;
            nArray2[n3] = 1;
            ++n3;
        }
        int n4 = n2;
        while (n4 < 4096) {
            nArray[n4] = -1;
            nArray2[n4] = 1;
            ++n4;
        }
    }

    private Point outputPixels(byte[] byArray, int n2, Point point, byte[] byArray2) {
        if (this.interlacePass < 0 || this.interlacePass > 3) {
            return point;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (point.x >= this.minX) {
                byArray2[point.x - this.minX] = byArray[n3];
            }
            ++point.x;
            if (point.x == this.width) {
                this.theTile.setDataElements(this.minX, point.y, this.width, 1, byArray2);
                point.x = 0;
                if (this.interlaceFlag) {
                    point.y += INTERLACE_INCREMENT[this.interlacePass];
                    if (point.y >= this.height) {
                        ++this.interlacePass;
                        if (this.interlacePass > 3) {
                            return point;
                        }
                        point.y = INTERLACE_OFFSET[this.interlacePass];
                    }
                } else {
                    ++point.y;
                }
            }
            ++n3;
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Raster getTile(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        byte[] byArray;
        int[] nArray;
        byte[] byArray2;
        byte[] byArray3;
        int[] nArray2;
        int n8;
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("GIFImage2"));
        }
        if (this.theTile != null) {
            return this.theTile;
        }
        this.theTile = Raster.createWritableRaster(this.sampleModel, this.sampleModel.createDataBuffer(), null);
        Point point = new Point(0, 0);
        byte[] byArray4 = new byte[this.width];
        try {
            try {
                this.initCodeSize = this.input.readUnsignedByte();
                int n9 = this.blockLength = this.input.readUnsignedByte();
                int n10 = 0;
                while (true) {
                    if (n9 <= 0) {
                        this.bitPos = 0;
                        this.nextByte = 0;
                        this.lastBlockFound = false;
                        this.bitsLeft = this.blockLength << 3;
                        this.initNext32Bits();
                        this.clearCode = 1 << this.initCodeSize;
                        this.eofCode = this.clearCode + 1;
                        n8 = 0;
                        nArray2 = new int[4096];
                        byArray3 = new byte[4096];
                        byArray2 = new byte[4096];
                        nArray = new int[4096];
                        byArray = new byte[4096];
                        this.initializeStringTable(nArray2, byArray3, byArray2, nArray);
                        n7 = (1 << this.initCodeSize) + 2;
                        n6 = this.initCodeSize + 1;
                        n5 = (1 << n6) - 1;
                        break;
                    }
                    n4 = this.input.read(this.block, n10, n9);
                    n9 -= n4;
                    n10 += n4;
                }
            }
            catch (IOException iOException) {
                String string = JaiI18N.getString("GIFImage3");
                ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                return this.theTile;
            }
        }
        catch (Throwable throwable) {
            return this.theTile;
        }
        while (true) {
            int n11;
            int n12;
            int n13;
            if ((n4 = this.getCode(n6, n5)) == this.clearCode) {
                this.initializeStringTable(nArray2, byArray3, byArray2, nArray);
                n7 = (1 << this.initCodeSize) + 2;
                n6 = this.initCodeSize + 1;
                n5 = (1 << n6) - 1;
                n4 = this.getCode(n6, n5);
                if (n4 == this.eofCode) {
                    WritableRaster writableRaster = this.theTile;
                    return this.theTile;
                }
            } else {
                if (n4 == this.eofCode) {
                    WritableRaster writableRaster = this.theTile;
                    return this.theTile;
                }
                n13 = n4 < n7 ? n4 : n8;
                n12 = n7++;
                nArray2[n12] = n11 = n8;
                byArray3[n12] = byArray2[n13];
                byArray2[n12] = byArray2[n11];
                nArray[n12] = nArray[n11] + 1;
                if (n7 == 1 << n6 && n7 < 4096) {
                    n5 = (1 << ++n6) - 1;
                }
            }
            n13 = n4;
            n12 = nArray[n13];
            n11 = n12 - 1;
            while (n11 >= 0) {
                byArray[n11] = byArray3[n13];
                n13 = nArray2[n13];
                --n11;
            }
            this.outputPixels(byArray, n12, point, byArray4);
            n8 = n4;
        }
    }
}

