/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.SeekableOutputStream;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream output;
    private int version;
    private boolean isCompressed;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;

    public BMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        this.output = outputStream;
        BMPEncodeParam bMPEncodeParam = imageEncodeParam == null ? new BMPEncodeParam() : (BMPEncodeParam)imageEncodeParam;
        this.version = bMPEncodeParam.getVersion();
        this.isCompressed = bMPEncodeParam.isCompressed();
        if (this.isCompressed && !(outputStream instanceof SeekableOutputStream)) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder6"));
        }
        this.isTopDown = bMPEncodeParam.isTopDown();
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n2;
        int n3;
        int n4 = renderedImage.getMinX();
        int n5 = renderedImage.getMinY();
        this.w = renderedImage.getWidth();
        this.h = renderedImage.getHeight();
        int n6 = 24;
        boolean bl = false;
        int n7 = 0;
        IndexColorModel indexColorModel = null;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n8 = sampleModel.getNumBands();
        ColorModel colorModel = renderedImage.getColorModel();
        if (n8 != 1 && n8 != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder1"));
        }
        int[] nArray = sampleModel.getSampleSize();
        if (nArray[0] > 8) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder2"));
        }
        int n9 = 1;
        while (n9 < nArray.length) {
            if (nArray[n9] != nArray[0]) {
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder3"));
            }
            ++n9;
        }
        int n10 = sampleModel.getTransferType();
        if (n10 != 0 && !CodecUtils.isPackedByteImage(renderedImage)) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder0"));
        }
        int n11 = this.w * n8;
        int n12 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n7 = indexColorModel.getMapSize();
            if (n7 <= 2) {
                n6 = 1;
                n11 = (int)Math.ceil((double)this.w / 8.0);
            } else if (n7 <= 16) {
                n6 = 4;
                n11 = (int)Math.ceil((double)this.w / 2.0);
            } else if (n7 <= 256) {
                n6 = 8;
            } else {
                n6 = 24;
                bl = false;
                n7 = 0;
                n11 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n7];
                byArray2 = new byte[n7];
                byArray3 = new byte[n7];
                byArray4 = new byte[n7];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n8 == 1) {
            bl = true;
            n7 = 256;
            n6 = nArray[0];
            n11 = (int)Math.ceil((double)(this.w * n6) / 8.0);
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            n3 = 0;
            while (n3 < 256) {
                byArray[n3] = (byte)n3;
                byArray2[n3] = (byte)n3;
                byArray3[n3] = (byte)n3;
                byArray4[n3] = -1;
                ++n3;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n6 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
            n11 = this.w * n6 + 7 >> 3;
        }
        n3 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = n7;
        int n20 = 0;
        int n21 = n11 % 4;
        if (n21 != 0) {
            n20 = 4 - n21;
        }
        switch (this.version) {
            case 0: {
                n13 = 26 + n7 * 3;
                n14 = 12;
                n15 = (n11 + n20) * this.h;
                n3 = n15 + n13;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
            case 1: {
                if (this.isCompressed && n6 == 8) {
                    n12 = 1;
                } else if (this.isCompressed && n6 == 4) {
                    n12 = 2;
                }
                n13 = 54 + n7 * 4;
                n15 = (n11 + n20) * this.h;
                n3 = n15 + n13;
                n14 = 40;
                break;
            }
            case 2: {
                n14 = 108;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
        }
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        if (colorModel instanceof DirectColorModel) {
            n22 = ((DirectColorModel)colorModel).getRedMask();
            n24 = ((DirectColorModel)colorModel).getGreenMask();
            n23 = ((DirectColorModel)colorModel).getBlueMask();
            n11 = this.w;
            n12 = 3;
            n3 += 12;
            n13 += 12;
        }
        this.writeFileHeader(n3, n13);
        this.writeInfoHeader(n14, n6);
        this.writeDWord(n12);
        this.writeDWord(n15);
        this.writeDWord(n16);
        this.writeDWord(n17);
        this.writeDWord(n18);
        this.writeDWord(n19);
        if (n12 == 3) {
            this.writeDWord(n22);
            this.writeDWord(n24);
            this.writeDWord(n23);
        }
        if (n12 == 3) {
            int n25 = 0;
            while (n25 < this.h) {
                Object object;
                int n26 = n5 + n25;
                if (!this.isTopDown) {
                    n26 = n5 + this.h - n25 - 1;
                }
                Rectangle rectangle = new Rectangle(n4, n26, this.w, 1);
                Raster raster = renderedImage.getData(rectangle);
                SampleModel sampleModel2 = raster.getSampleModel();
                int n27 = 0;
                int n28 = rectangle.x - raster.getSampleModelTranslateX();
                int n29 = rectangle.y - raster.getSampleModelTranslateY();
                if (sampleModel2 instanceof SinglePixelPackedSampleModel) {
                    object = (SinglePixelPackedSampleModel)sampleModel2;
                    n27 = ((SinglePixelPackedSampleModel)object).getOffset(n28, n29);
                }
                switch (n10) {
                    case 2: {
                        object = ((DataBufferShort)raster.getDataBuffer()).getData();
                        int n30 = 0;
                        while (n30 < ((Object)object).length) {
                            this.writeWord((int)object[n30]);
                            ++n30;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = ((DataBufferUShort)raster.getDataBuffer()).getData();
                        int n31 = 0;
                        while (n31 < sArray.length) {
                            this.writeWord(sArray[n31]);
                            ++n31;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray2 = ((DataBufferInt)raster.getDataBuffer()).getData();
                        int n32 = 0;
                        while (n32 < nArray2.length) {
                            this.writeDWord(nArray2[n32]);
                            ++n32;
                        }
                        break;
                    }
                }
                ++n25;
            }
            return;
        }
        if (bl) {
            switch (this.version) {
                case 0: {
                    n2 = 0;
                    while (n2 < n7) {
                        this.output.write(byArray3[n2]);
                        this.output.write(byArray2[n2]);
                        this.output.write(byArray[n2]);
                        ++n2;
                    }
                    break;
                }
                default: {
                    int n33 = 0;
                    while (n33 < n7) {
                        this.output.write(byArray3[n33]);
                        this.output.write(byArray2[n33]);
                        this.output.write(byArray[n33]);
                        this.output.write(byArray4[n33]);
                        ++n33;
                    }
                    break block10;
                }
            }
        }
        n2 = this.w * n8;
        int[] nArray3 = new int[8 * n2];
        byte[] byArray5 = new byte[n11];
        if (!this.isTopDown) {
            int n34 = n5 + this.h;
            int n35 = n34 - 1;
            while (n35 >= n5) {
                int n36 = Math.min(8, n35 - n5 + 1);
                Raster raster = renderedImage.getData(new Rectangle(n4, n35 - n36 + 1, this.w, n36));
                raster.getPixels(n4, n35 - n36 + 1, this.w, n36, nArray3);
                int n37 = 0;
                int n38 = n2 * n36 - 1;
                int n39 = 0;
                while (n39 < n36) {
                    n37 = n38 - (n39 + 1) * n2 + 1;
                    this.writePixels(n37, n2, n6, nArray3, byArray5, n20, n8, indexColorModel);
                    ++n39;
                }
                n35 -= 8;
            }
        } else {
            int n40 = n5 + this.h;
            int n41 = n5;
            while (n41 < n40) {
                int n42 = Math.min(8, n40 - n41);
                Raster raster = renderedImage.getData(new Rectangle(n4, n41, this.w, n42));
                raster.getPixels(n4, n41, this.w, n42, nArray3);
                int n43 = 0;
                int n44 = 0;
                while (n44 < n42) {
                    this.writePixels(n43, n2, n6, nArray3, byArray5, n20, n8, indexColorModel);
                    ++n44;
                }
                n41 += 8;
            }
        }
        if (this.isCompressed && (n6 == 4 || n6 == 8)) {
            this.output.write(0);
            this.output.write(1);
            this.incCompImageSize(2);
            n15 = this.compImageSize;
            n3 = this.compImageSize + n13;
            this.writeSize(n3, 2);
            this.writeSize(n15, 34);
        }
    }

    private void writePixels(int n2, int n3, int n4, int[] nArray, byte[] byArray, int n5, int n6, IndexColorModel indexColorModel) throws IOException {
        int n7 = 0;
        int n8 = 0;
        switch (n4) {
            case 1: {
                int n9 = 0;
                while (n9 < n3 / 8) {
                    byArray[n8++] = (byte)(nArray[n2++] << 7 | nArray[n2++] << 6 | nArray[n2++] << 5 | nArray[n2++] << 4 | nArray[n2++] << 3 | nArray[n2++] << 2 | nArray[n2++] << 1 | nArray[n2++]);
                    ++n9;
                }
                if (n3 % 8 > 0) {
                    n7 = 0;
                    int n10 = 0;
                    while (n10 < n3 % 8) {
                        n7 |= nArray[n2++] << 7 - n10;
                        ++n10;
                    }
                    byArray[n8++] = (byte)n7;
                }
                this.output.write(byArray, 0, (n3 + 7) / 8);
                break;
            }
            case 4: {
                if (this.isCompressed) {
                    byte[] byArray2 = new byte[n3];
                    int n11 = 0;
                    while (n11 < n3) {
                        byArray2[n11] = (byte)nArray[n2++];
                        ++n11;
                    }
                    this.encodeRLE4(byArray2, n3);
                    break;
                }
                int n12 = 0;
                while (n12 < n3 / 2) {
                    n7 = nArray[n2++] << 4 | nArray[n2++];
                    byArray[n8++] = (byte)n7;
                    ++n12;
                }
                if (n3 % 2 == 1) {
                    n7 = nArray[n2] << 4;
                    byArray[n8++] = (byte)n7;
                }
                this.output.write(byArray, 0, (n3 + 1) / 2);
                break;
            }
            case 8: {
                if (this.isCompressed) {
                    int n13 = 0;
                    while (n13 < n3) {
                        byArray[n13] = (byte)nArray[n2++];
                        ++n13;
                    }
                    this.encodeRLE8(byArray, n3);
                    break;
                }
                int n14 = 0;
                while (n14 < n3) {
                    byArray[n14] = (byte)nArray[n2++];
                    ++n14;
                }
                this.output.write(byArray, 0, n3);
                break;
            }
            case 24: {
                if (n6 == 3) {
                    int n15 = 0;
                    while (n15 < n3) {
                        byArray[n8++] = (byte)nArray[n2 + 2];
                        byArray[n8++] = (byte)nArray[n2 + 1];
                        byArray[n8++] = (byte)nArray[n2];
                        n2 += 3;
                        n15 += 3;
                    }
                    this.output.write(byArray, 0, n3);
                    break;
                }
                int n16 = indexColorModel.getMapSize();
                byte[] byArray3 = new byte[n16];
                byte[] byArray4 = new byte[n16];
                byte[] byArray5 = new byte[n16];
                indexColorModel.getReds(byArray3);
                indexColorModel.getGreens(byArray4);
                indexColorModel.getBlues(byArray5);
                int n17 = 0;
                while (n17 < n3) {
                    int n18 = nArray[n2];
                    byArray[n8++] = byArray5[n18];
                    byArray[n8++] = byArray4[n18];
                    byArray[n8++] = byArray5[n18];
                    ++n2;
                    ++n17;
                }
                this.output.write(byArray, 0, n3 * 3);
            }
        }
        if (!this.isCompressed || n4 != 8 && n4 != 4) {
            n8 = 0;
            while (n8 < n5) {
                this.output.write(0);
                ++n8;
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n2) throws IOException {
        int n3 = 1;
        int n4 = -1;
        int n5 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n5];
        byte[] byArray2 = new byte[256];
        while (n5 < n2 - 1) {
            int n6;
            if ((by2 = byArray[++n5]) == by) {
                if (n4 >= 3) {
                    this.output.write(0);
                    this.output.write(n4);
                    this.incCompImageSize(2);
                    n6 = 0;
                    while (n6 < n4) {
                        this.output.write(byArray2[n6]);
                        this.incCompImageSize(1);
                        ++n6;
                    }
                    if (!this.isEven(n4)) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n4 > -1) {
                    n6 = 0;
                    while (n6 < n4) {
                        this.output.write(1);
                        this.output.write(byArray2[n6]);
                        this.incCompImageSize(2);
                        ++n6;
                    }
                }
                n4 = -1;
                if (++n3 == 256) {
                    this.output.write(n3 - 1);
                    this.output.write(by);
                    this.incCompImageSize(2);
                    n3 = 1;
                }
            } else {
                if (n3 > 1) {
                    this.output.write(n3);
                    this.output.write(by);
                    this.incCompImageSize(2);
                } else if (n4 < 0) {
                    byArray2[++n4] = by;
                    byArray2[++n4] = by2;
                } else if (n4 < 254) {
                    byArray2[++n4] = by2;
                } else {
                    this.output.write(0);
                    this.output.write(n4 + 1);
                    this.incCompImageSize(2);
                    n6 = 0;
                    while (n6 <= n4) {
                        this.output.write(byArray2[n6]);
                        this.incCompImageSize(1);
                        ++n6;
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n4 = -1;
                }
                by = by2;
                n3 = 1;
            }
            if (n5 != n2 - 1) continue;
            if (n4 == -1) {
                this.output.write(n3);
                this.output.write(by);
                this.incCompImageSize(2);
                n3 = 1;
            } else if (n4 >= 2) {
                this.output.write(0);
                this.output.write(n4 + 1);
                this.incCompImageSize(2);
                n6 = 0;
                while (n6 <= n4) {
                    this.output.write(byArray2[n6]);
                    this.incCompImageSize(1);
                    ++n6;
                }
                if (!this.isEven(n4 + 1)) {
                    this.output.write(0);
                    this.incCompImageSize(1);
                }
            } else if (n4 > -1) {
                n6 = 0;
                while (n6 <= n4) {
                    this.output.write(1);
                    this.output.write(byArray2[n6]);
                    this.incCompImageSize(2);
                    ++n6;
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n2) throws IOException {
        int n3 = 2;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n5];
        by2 = byArray[++n5];
        while (n5 < n2 - 2) {
            int n8;
            by3 = byArray[++n5];
            by4 = byArray[++n5];
            if (by3 == by) {
                if (n4 >= 4) {
                    this.output.write(0);
                    this.output.write(n4 - 1);
                    this.incCompImageSize(2);
                    n8 = 0;
                    while (n8 < n4 - 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.output.write((byte)n6);
                        this.incCompImageSize(1);
                        n8 += 2;
                    }
                    if (!this.isEven(n4 - 1)) {
                        n7 = byArray2[n4 - 2] << 4 | 0;
                        this.output.write(n7);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n4 - 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n4 > -1) {
                    this.output.write(2);
                    n6 = byArray2[0] << 4 | byArray2[1];
                    this.output.write(n6);
                    this.incCompImageSize(2);
                }
                n4 = -1;
                if (by4 == by2) {
                    if ((n3 += 2) == 256) {
                        this.output.write(n3 - 1);
                        n6 = by << 4 | by2;
                        this.output.write(n6);
                        this.incCompImageSize(2);
                        n3 = 2;
                        if (n5 < n2 - 1) {
                            by = by2;
                            by2 = byArray[++n5];
                        } else {
                            this.output.write(1);
                            n8 = by2 << 4 | 0;
                            this.output.write(n8);
                            this.incCompImageSize(2);
                            n3 = -1;
                        }
                    }
                } else {
                    n6 = by << 4 | by2;
                    this.output.write(++n3);
                    this.output.write(n6);
                    this.incCompImageSize(2);
                    n3 = 2;
                    by = by4;
                    if (n5 < n2 - 1) {
                        by2 = byArray[++n5];
                    } else {
                        this.output.write(1);
                        n8 = by4 << 4 | 0;
                        this.output.write(n8);
                        this.incCompImageSize(2);
                        n3 = -1;
                    }
                }
            } else {
                if (n3 > 2) {
                    n6 = by << 4 | by2;
                    this.output.write(n3);
                    this.output.write(n6);
                    this.incCompImageSize(2);
                } else if (n4 < 0) {
                    byArray2[++n4] = by;
                    byArray2[++n4] = by2;
                    byArray2[++n4] = by3;
                    byArray2[++n4] = by4;
                } else if (n4 < 253) {
                    byArray2[++n4] = by3;
                    byArray2[++n4] = by4;
                } else {
                    this.output.write(0);
                    this.output.write(n4 + 1);
                    this.incCompImageSize(2);
                    n8 = 0;
                    while (n8 < n4) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.output.write((byte)n6);
                        this.incCompImageSize(1);
                        n8 += 2;
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n4 = -1;
                }
                by = by3;
                by2 = by4;
                n3 = 2;
            }
            if (n5 < n2 - 2) continue;
            if (n4 == -1 && n3 >= 2) {
                if (n5 == n2 - 2) {
                    if (byArray[++n5] == by) {
                        n6 = by << 4 | by2;
                        this.output.write(++n3);
                        this.output.write(n6);
                        this.incCompImageSize(2);
                    } else {
                        n6 = by << 4 | by2;
                        this.output.write(n3);
                        this.output.write(n6);
                        this.output.write(1);
                        n6 = byArray[n5] << 4 | 0;
                        this.output.write(n6);
                        n8 = byArray[n5] << 4 | 0;
                        this.incCompImageSize(4);
                    }
                } else {
                    this.output.write(n3);
                    n6 = by << 4 | by2;
                    this.output.write(n6);
                    this.incCompImageSize(2);
                }
            } else if (n4 > -1) {
                if (n5 == n2 - 2) {
                    byArray2[++n4] = byArray[++n5];
                }
                if (n4 >= 2) {
                    this.output.write(0);
                    this.output.write(n4 + 1);
                    this.incCompImageSize(2);
                    n8 = 0;
                    while (n8 < n4) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.output.write((byte)n6);
                        this.incCompImageSize(1);
                        n8 += 2;
                    }
                    if (!this.isEven(n4 + 1)) {
                        n7 = byArray2[n4] << 4 | 0;
                        this.output.write(n7);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n4 + 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n4) {
                        case 0: {
                            this.output.write(1);
                            n8 = byArray2[0] << 4 | 0;
                            this.output.write(n8);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.output.write(2);
                            n6 = byArray2[0] << 4 | byArray2[1];
                            this.output.write(n6);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n2) {
        this.compImageSize += n2;
    }

    private boolean isEven(int n2) {
        return n2 % 2 == 0;
    }

    private void writeFileHeader(int n2, int n3) throws IOException {
        this.output.write(66);
        this.output.write(77);
        this.writeDWord(n2);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.writeDWord(n3);
    }

    private void writeInfoHeader(int n2, int n3) throws IOException {
        this.writeDWord(n2);
        this.writeDWord(this.w);
        this.writeDWord(this.h);
        this.writeWord(1);
        this.writeWord(n3);
    }

    public void writeWord(int n2) throws IOException {
        this.output.write(n2 & 0xFF);
        this.output.write((n2 & 0xFF00) >> 8);
    }

    public void writeDWord(int n2) throws IOException {
        this.output.write(n2 & 0xFF);
        this.output.write((n2 & 0xFF00) >> 8);
        this.output.write((n2 & 0xFF0000) >> 16);
        this.output.write((n2 & 0xFF000000) >> 24);
    }

    private void writeSize(int n2, int n3) throws IOException {
        ((SeekableOutputStream)this.output).seek(n3);
        this.writeDWord(n2);
    }
}

