/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFField;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TIFFDirectory
implements Serializable {
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Hashtable fieldIndex = new Hashtable();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int n2) {
        return n2 == 18761 || n2 == 19789;
    }

    public TIFFDirectory(SeekableStream seekableStream, int n2) throws IOException {
        long l2 = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n3 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n3)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        this.isBigEndian = n3 == 19789;
        int n4 = this.readUnsignedShort(seekableStream);
        if (n4 != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory2"));
        }
        long l3 = this.readUnsignedInt(seekableStream);
        int n5 = 0;
        while (n5 < n2) {
            if (l3 == 0L) {
                throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory3"));
            }
            seekableStream.seek(l3);
            int n6 = this.readUnsignedShort(seekableStream);
            seekableStream.skip(12 * n6);
            l3 = this.readUnsignedInt(seekableStream);
            ++n5;
        }
        seekableStream.seek(l3);
        this.initialize(seekableStream);
        seekableStream.seek(l2);
    }

    public TIFFDirectory(SeekableStream seekableStream, long l2, int n2) throws IOException {
        long l3 = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n3 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n3)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        this.isBigEndian = n3 == 19789;
        seekableStream.seek(l2);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.readUnsignedShort(seekableStream);
            seekableStream.seek(l2 + (long)(12 * n5));
            l2 = this.readUnsignedInt(seekableStream);
            seekableStream.seek(l2);
            ++n4;
        }
        this.initialize(seekableStream);
        seekableStream.seek(l3);
    }

    private void initialize(SeekableStream seekableStream) throws IOException {
        this.IFDOffset = seekableStream.getFilePointer();
        this.numEntries = this.readUnsignedShort(seekableStream);
        this.fields = new TIFFField[this.numEntries];
        int n2 = 0;
        while (n2 < this.numEntries) {
            block27: {
                long l2;
                int n3;
                int n4;
                int n5;
                block26: {
                    n5 = this.readUnsignedShort(seekableStream);
                    n4 = this.readUnsignedShort(seekableStream);
                    n3 = (int)this.readUnsignedInt(seekableStream);
                    int n6 = 0;
                    l2 = seekableStream.getFilePointer() + 4L;
                    try {
                        if (n3 * sizeOfType[n4] <= 4) break block26;
                        n6 = (int)this.readUnsignedInt(seekableStream);
                        seekableStream.seek(n6);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(n5 + " " + JaiI18N.getString("TIFFDirectory4"));
                        seekableStream.seek(l2);
                        break block27;
                    }
                }
                this.fieldIndex.put(new Integer(n5), new Integer(n2));
                Object object = null;
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        Object[] objectArray;
                        Object object2;
                        byte[] byArray = new byte[n3];
                        seekableStream.readFully(byArray, 0, n3);
                        if (n4 == 2) {
                            int n7 = 0;
                            int n8 = 0;
                            object2 = new Vector();
                            while (n7 < n3) {
                                while (n7 < n3 && byArray[n7++] != 0) {
                                }
                                ((Vector)object2).add(new String(byArray, n8, n7 - n8));
                                n8 = n7;
                            }
                            n3 = ((Vector)object2).size();
                            objectArray = new String[n3];
                            int n9 = 0;
                            while (n9 < n3) {
                                objectArray[n9] = (short)((String)((Vector)object2).elementAt(n9));
                                ++n9;
                            }
                            object = objectArray;
                            break;
                        }
                        object = byArray;
                        break;
                    }
                    case 3: {
                        char[] cArray = new char[n3];
                        int n10 = 0;
                        while (n10 < n3) {
                            cArray[n10] = (char)this.readUnsignedShort(seekableStream);
                            ++n10;
                        }
                        object = cArray;
                        break;
                    }
                    case 4: {
                        long[] lArray = new long[n3];
                        int n10 = 0;
                        while (n10 < n3) {
                            lArray[n10] = this.readUnsignedInt(seekableStream);
                            ++n10;
                        }
                        object = lArray;
                        break;
                    }
                    case 5: {
                        Object object2 = new long[n3][2];
                        int n10 = 0;
                        while (n10 < n3) {
                            object2[n10][0] = this.readUnsignedInt(seekableStream);
                            object2[n10][1] = this.readUnsignedInt(seekableStream);
                            ++n10;
                        }
                        object = object2;
                        break;
                    }
                    case 8: {
                        Object[] objectArray = new short[n3];
                        int n10 = 0;
                        while (n10 < n3) {
                            objectArray[n10] = this.readShort(seekableStream);
                            ++n10;
                        }
                        object = objectArray;
                        break;
                    }
                    case 9: {
                        int[] nArray = new int[n3];
                        int n10 = 0;
                        while (n10 < n3) {
                            nArray[n10] = this.readInt(seekableStream);
                            ++n10;
                        }
                        object = nArray;
                        break;
                    }
                    case 10: {
                        int[][] nArray = new int[n3][2];
                        int n10 = 0;
                        while (n10 < n3) {
                            nArray[n10][0] = this.readInt(seekableStream);
                            nArray[n10][1] = this.readInt(seekableStream);
                            ++n10;
                        }
                        object = nArray;
                        break;
                    }
                    case 11: {
                        float[] fArray = new float[n3];
                        int n10 = 0;
                        while (n10 < n3) {
                            fArray[n10] = this.readFloat(seekableStream);
                            ++n10;
                        }
                        object = fArray;
                        break;
                    }
                    case 12: {
                        double[] dArray = new double[n3];
                        int n10 = 0;
                        while (n10 < n3) {
                            dArray[n10] = this.readDouble(seekableStream);
                            ++n10;
                        }
                        object = dArray;
                        break;
                    }
                    default: {
                        System.err.println(JaiI18N.getString("TIFFDirectory0"));
                    }
                }
                this.fields[n2] = new TIFFField(n5, n4, n3, object);
                seekableStream.seek(l2);
            }
            ++n2;
        }
        this.nextIFDOffset = this.readUnsignedInt(seekableStream);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n2));
        if (n3 == null) {
            return null;
        }
        return this.fields[n3];
    }

    public boolean isTagPresent(int n2) {
        return this.fieldIndex.containsKey(new Integer(n2));
    }

    public int[] getTags() {
        int[] nArray = new int[this.fieldIndex.size()];
        Enumeration enumeration = this.fieldIndex.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int n2, int n3) {
        Integer n4 = (Integer)this.fieldIndex.get(new Integer(n2));
        byte[] byArray = this.fields[n4].getAsBytes();
        return byArray[n3];
    }

    public byte getFieldAsByte(int n2) {
        return this.getFieldAsByte(n2, 0);
    }

    public long getFieldAsLong(int n2, int n3) {
        Integer n4 = (Integer)this.fieldIndex.get(new Integer(n2));
        return this.fields[n4].getAsLong(n3);
    }

    public long getFieldAsLong(int n2) {
        return this.getFieldAsLong(n2, 0);
    }

    public float getFieldAsFloat(int n2, int n3) {
        Integer n4 = (Integer)this.fieldIndex.get(new Integer(n2));
        return this.fields[n4].getAsFloat(n3);
    }

    public float getFieldAsFloat(int n2) {
        return this.getFieldAsFloat(n2, 0);
    }

    public double getFieldAsDouble(int n2, int n3) {
        Integer n4 = (Integer)this.fieldIndex.get(new Integer(n2));
        return this.fields[n4].getAsDouble(n3);
    }

    public double getFieldAsDouble(int n2) {
        return this.getFieldAsDouble(n2, 0);
    }

    private short readShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readShort();
        }
        return seekableStream.readShortLE();
    }

    private int readUnsignedShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private int readInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readInt();
        }
        return seekableStream.readIntLE();
    }

    private long readUnsignedInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    private long readLong(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readLong();
        }
        return seekableStream.readLongLE();
    }

    private float readFloat(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readFloat();
        }
        return seekableStream.readFloatLE();
    }

    private double readDouble(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readDouble();
        }
        return seekableStream.readDoubleLE();
    }

    private static int readUnsignedShort(SeekableStream seekableStream, boolean bl) throws IOException {
        if (bl) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(SeekableStream seekableStream, boolean bl) throws IOException {
        if (bl) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    public static int getNumDirectories(SeekableStream seekableStream) throws IOException {
        long l2 = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n2 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        boolean bl = n2 == 19789;
        int n3 = TIFFDirectory.readUnsignedShort(seekableStream, bl);
        if (n3 != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory2"));
        }
        seekableStream.seek(4L);
        long l3 = TIFFDirectory.readUnsignedInt(seekableStream, bl);
        int n4 = 0;
        while (l3 != 0L) {
            ++n4;
            try {
                seekableStream.seek(l3);
                int n5 = TIFFDirectory.readUnsignedShort(seekableStream, bl);
                seekableStream.skip(12 * n5);
                l3 = TIFFDirectory.readUnsignedInt(seekableStream, bl);
            }
            catch (EOFException eOFException) {
                --n4;
                break;
            }
        }
        seekableStream.seek(l2);
        return n4;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

