/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public final class MemoryCacheSeekableStream
extends SeekableStream {
    private InputStream src;
    private long pointer = 0L;
    private static final int SECTOR_SHIFT = 9;
    private static final int SECTOR_SIZE = 512;
    private static final int SECTOR_MASK = 511;
    private Vector data = new Vector();
    int sectors = 0;
    int length = 0;
    boolean foundEOS = false;

    public MemoryCacheSeekableStream(InputStream inputStream) {
        this.src = inputStream;
    }

    public final int available() throws IOException {
        return this.src.available();
    }

    private long readUntil(long l2) throws IOException {
        int n2;
        if (l2 < (long)this.length) {
            return l2;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int n3 = (int)(l2 >> 9);
        int n4 = n2 = this.length >> 9;
        while (n4 <= n3) {
            byte[] byArray = new byte[512];
            this.data.addElement(byArray);
            int n5 = 512;
            int n6 = 0;
            while (n5 > 0) {
                int n7 = this.src.read(byArray, n6, n5);
                if (n7 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                n6 += n7;
                n5 -= n7;
                this.length += n7;
            }
            ++n4;
        }
        return this.length;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException(JaiI18N.getString("MemoryCacheSeekableStream0"));
        }
        this.pointer = l2;
    }

    public int read() throws IOException {
        long l2 = this.pointer + 1L;
        long l3 = this.readUntil(l2);
        if (l3 >= l2) {
            byte[] byArray = (byte[])this.data.elementAt((int)(this.pointer >> 9));
            return byArray[(int)(this.pointer++ & 0x1FFL)] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        long l2 = this.readUntil(this.pointer + (long)n3);
        if (l2 <= this.pointer) {
            return -1;
        }
        byte[] byArray2 = (byte[])this.data.elementAt((int)(this.pointer >> 9));
        int n4 = Math.min(n3, 512 - (int)(this.pointer & 0x1FFL));
        System.arraycopy(byArray2, (int)(this.pointer & 0x1FFL), byArray, n2, n4);
        this.pointer += (long)n4;
        return n4;
    }
}

