/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;

public abstract class ImageDecoderImpl
implements ImageDecoder {
    protected SeekableStream input;
    protected ImageDecodeParam param;

    public ImageDecoderImpl(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        this.input = seekableStream;
        this.param = imageDecodeParam;
    }

    public ImageDecoderImpl(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        this.input = new ForwardSeekableStream(inputStream);
        this.param = imageDecodeParam;
    }

    public ImageDecodeParam getParam() {
        return this.param;
    }

    public void setParam(ImageDecodeParam imageDecodeParam) {
        this.param = imageDecodeParam;
    }

    public SeekableStream getInputStream() {
        return this.input;
    }

    public int getNumPages() throws IOException {
        return 1;
    }

    public Raster decodeAsRaster() throws IOException {
        return this.decodeAsRaster(0);
    }

    public Raster decodeAsRaster(int n2) throws IOException {
        RenderedImage renderedImage = this.decodeAsRenderedImage(n2);
        return renderedImage.getData();
    }

    public RenderedImage decodeAsRenderedImage() throws IOException {
        return this.decodeAsRenderedImage(0);
    }

    public abstract RenderedImage decodeAsRenderedImage(int var1) throws IOException;
}

