/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TempFileCleanupThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;

public final class FileCacheSeekableStream
extends SeekableStream {
    private static TempFileCleanupThread cleanupThread = null;
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 1024;
    private byte[] buf = new byte[this.bufLen];
    private long length = 0L;
    private long pointer = 0L;
    private boolean foundEOF = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public FileCacheSeekableStream(InputStream inputStream) throws IOException {
        this.stream = inputStream;
        this.cacheFile = File.createTempFile("jai-FCSS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
        if (cleanupThread != null) {
            cleanupThread.addFile(this.cacheFile);
        }
    }

    private long readUntil(long l2) throws IOException {
        if (l2 < this.length) {
            return l2;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l3 = l2 - this.length;
        this.cache.seek(this.length);
        while (l3 > 0L) {
            int n2 = this.stream.read(this.buf, 0, (int)Math.min(l3, (long)this.bufLen));
            if (n2 == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n2);
            this.cache.write(this.buf, 0, n2);
            l3 -= (long)n2;
            this.length += (long)n2;
        }
        return l2;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException(JaiI18N.getString("FileCacheSeekableStream0"));
        }
        this.pointer = l2;
    }

    public int read() throws IOException {
        long l2 = this.pointer + 1L;
        long l3 = this.readUntil(l2);
        if (l3 >= l2) {
            this.cache.seek(this.pointer++);
            return this.cache.read();
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        long l2 = this.readUntil(this.pointer + (long)n3);
        if ((n3 = (int)Math.min((long)n3, l2 - this.pointer)) > 0) {
            this.cache.seek(this.pointer);
            this.cache.readFully(byArray, n2, n3);
            this.pointer += (long)n3;
            return n3;
        }
        return -1;
    }

    public void close() throws IOException {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        if (cleanupThread != null) {
            cleanupThread.removeFile(this.cacheFile);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Method method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = FileCacheSeekableStream.class$("java.lang.Runtime")) : class$java$lang$Runtime).getDeclaredMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = FileCacheSeekableStream.class$("java.lang.Thread")) : class$java$lang$Thread);
            cleanupThread = new TempFileCleanupThread();
            method.invoke((Object)Runtime.getRuntime(), cleanupThread);
        }
        catch (Exception exception) {
            cleanupThread = null;
        }
    }
}

