/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.InfoResidue0;
import com.jcraft.jorbis.LookResidue0;

class Residue0
extends FuncResidue {
    static int[][][] partword = new int[2][][];

    Residue0() {
    }

    void pack(Object object, Buffer buffer) {
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        int n2 = 0;
        buffer.write(infoResidue0.begin, 24);
        buffer.write(infoResidue0.end, 24);
        buffer.write(infoResidue0.grouping - 1, 24);
        buffer.write(infoResidue0.partitions - 1, 6);
        buffer.write(infoResidue0.groupbook, 8);
        int n3 = 0;
        while (n3 < infoResidue0.partitions) {
            if (Residue0.ilog(infoResidue0.secondstages[n3]) > 3) {
                buffer.write(infoResidue0.secondstages[n3], 3);
                buffer.write(1, 1);
                buffer.write(infoResidue0.secondstages[n3] >>> 3, 5);
            } else {
                buffer.write(infoResidue0.secondstages[n3], 4);
            }
            n2 += Residue0.icount(infoResidue0.secondstages[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            buffer.write(infoResidue0.booklist[n4], 8);
            ++n4;
        }
    }

    Object unpack(Info info, Buffer buffer) {
        int n2;
        int n3 = 0;
        InfoResidue0 infoResidue0 = new InfoResidue0();
        infoResidue0.begin = buffer.read(24);
        infoResidue0.end = buffer.read(24);
        infoResidue0.grouping = buffer.read(24) + 1;
        infoResidue0.partitions = buffer.read(6) + 1;
        infoResidue0.groupbook = buffer.read(8);
        int n4 = 0;
        while (n4 < infoResidue0.partitions) {
            n2 = buffer.read(3);
            if (buffer.read(1) != 0) {
                n2 |= buffer.read(5) << 3;
            }
            infoResidue0.secondstages[n4] = n2;
            n3 += Residue0.icount(n2);
            ++n4;
        }
        n2 = 0;
        while (n2 < n3) {
            infoResidue0.booklist[n2] = buffer.read(8);
            ++n2;
        }
        if (infoResidue0.groupbook >= info.books) {
            this.free_info(infoResidue0);
            return null;
        }
        int n5 = 0;
        while (n5 < n3) {
            if (infoResidue0.booklist[n5] >= info.books) {
                this.free_info(infoResidue0);
                return null;
            }
            ++n5;
        }
        return infoResidue0;
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        int n2;
        int n3;
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        LookResidue0 lookResidue0 = new LookResidue0();
        int n4 = 0;
        int n5 = 0;
        lookResidue0.info = infoResidue0;
        lookResidue0.map = infoMode.mapping;
        lookResidue0.parts = infoResidue0.partitions;
        lookResidue0.fullbooks = dspState.fullbooks;
        lookResidue0.phrasebook = dspState.fullbooks[infoResidue0.groupbook];
        int n6 = lookResidue0.phrasebook.dim;
        lookResidue0.partbooks = new int[lookResidue0.parts][];
        int n7 = 0;
        while (n7 < lookResidue0.parts) {
            n3 = Residue0.ilog(infoResidue0.secondstages[n7]);
            if (n3 != 0) {
                if (n3 > n5) {
                    n5 = n3;
                }
                lookResidue0.partbooks[n7] = new int[n3];
                n2 = 0;
                while (n2 < n3) {
                    if ((infoResidue0.secondstages[n7] & 1 << n2) != 0) {
                        lookResidue0.partbooks[n7][n2] = infoResidue0.booklist[n4++];
                    }
                    ++n2;
                }
            }
            ++n7;
        }
        lookResidue0.partvals = (int)Math.rint(Math.pow(lookResidue0.parts, n6));
        lookResidue0.stages = n5;
        lookResidue0.decodemap = new int[lookResidue0.partvals][];
        n3 = 0;
        while (n3 < lookResidue0.partvals) {
            n2 = n3;
            int n8 = lookResidue0.partvals / lookResidue0.parts;
            lookResidue0.decodemap[n3] = new int[n6];
            int n9 = 0;
            while (n9 < n6) {
                int n10 = n2 / n8;
                n2 -= n10 * n8;
                n8 /= lookResidue0.parts;
                lookResidue0.decodemap[n3][n9] = n10;
                ++n9;
            }
            ++n3;
        }
        return lookResidue0;
    }

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    int forward(Block block, Object object, float[][] fArray, int n2) {
        System.err.println("Residue0.forward: not implemented");
        return 0;
    }

    static synchronized int _01inverse(Block block, Object object, float[][] fArray, int n2, int n3) {
        int n4;
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n5 = infoResidue0.grouping;
        int n6 = lookResidue0.phrasebook.dim;
        int n7 = infoResidue0.end - infoResidue0.begin;
        int n8 = n7 / n5;
        int n9 = (n8 + n6 - 1) / n6;
        if (partword.length < n2) {
            partword = new int[n2][][];
            n4 = 0;
            while (n4 < n2) {
                Residue0.partword[n4] = new int[n9][];
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n2) {
                if (partword[n4] == null || partword[n4].length < n9) {
                    Residue0.partword[n4] = new int[n9][];
                }
                ++n4;
            }
        }
        int n10 = 0;
        while (n10 < lookResidue0.stages) {
            int n11 = 0;
            int n12 = 0;
            while (n11 < n8) {
                int n13;
                if (n10 == 0) {
                    n4 = 0;
                    while (n4 < n2) {
                        n13 = lookResidue0.phrasebook.decode(block.opb);
                        if (n13 == -1) {
                            return 0;
                        }
                        Residue0.partword[n4][n12] = lookResidue0.decodemap[n13];
                        if (partword[n4][n12] == null) {
                            return 0;
                        }
                        ++n4;
                    }
                }
                int n14 = 0;
                while (n14 < n6 && n11 < n8) {
                    n4 = 0;
                    while (n4 < n2) {
                        CodeBook codeBook;
                        n13 = infoResidue0.begin + n11 * n5;
                        if ((infoResidue0.secondstages[partword[n4][n12][n14]] & 1 << n10) != 0 && (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[partword[n4][n12][n14]][n10]]) != null && (n3 == 0 ? codeBook.decodevs_add(fArray[n4], n13, block.opb, n5) == -1 : n3 == 1 && codeBook.decodev_add(fArray[n4], n13, block.opb, n5) == -1)) {
                            return 0;
                        }
                        ++n4;
                    }
                    ++n14;
                    ++n11;
                }
                ++n12;
            }
            ++n10;
        }
        return 0;
    }

    static int _2inverse(Block block, Object object, float[][] fArray, int n2) {
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n3 = infoResidue0.grouping;
        int n4 = lookResidue0.phrasebook.dim;
        int n5 = infoResidue0.end - infoResidue0.begin;
        int n6 = n5 / n3;
        int n7 = (n6 + n4 - 1) / n4;
        int[][] nArrayArray = new int[n7][];
        int n8 = 0;
        while (n8 < lookResidue0.stages) {
            int n9 = 0;
            int n10 = 0;
            while (n9 < n6) {
                int n11;
                if (n8 == 0) {
                    n11 = lookResidue0.phrasebook.decode(block.opb);
                    if (n11 == -1) {
                        return 0;
                    }
                    nArrayArray[n10] = lookResidue0.decodemap[n11];
                    if (nArrayArray[n10] == null) {
                        return 0;
                    }
                }
                int n12 = 0;
                while (n12 < n4 && n9 < n6) {
                    CodeBook codeBook;
                    n11 = infoResidue0.begin + n9 * n3;
                    if ((infoResidue0.secondstages[nArrayArray[n10][n12]] & 1 << n8) != 0 && (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[nArrayArray[n10][n12]][n8]]) != null && codeBook.decodevv_add(fArray, n11, n2, block.opb, n3) == -1) {
                        return 0;
                    }
                    ++n12;
                    ++n9;
                }
                ++n10;
            }
            ++n8;
        }
        return 0;
    }

    int inverse(Block block, Object object, float[][] fArray, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] != 0) {
                fArray[n3++] = fArray[n4];
            }
            ++n4;
        }
        if (n3 != 0) {
            return Residue0._01inverse(block, object, fArray, n3, 0);
        }
        return 0;
    }

    private static int ilog(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }

    private static int icount(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            n3 += n2 & 1;
            n2 >>>= 1;
        }
        return n3;
    }
}

