/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

class Mdct {
    private static final float cPI3_8 = 0.38268343f;
    private static final float cPI2_8 = 0.70710677f;
    private static final float cPI1_8 = 0.9238795f;
    int n;
    int log2n;
    float[] trig;
    int[] bitrev;
    float scale;
    float[] _x = new float[1024];
    float[] _w = new float[1024];

    Mdct() {
    }

    void init(int n2) {
        this.bitrev = new int[n2 / 4];
        this.trig = new float[n2 + n2 / 4];
        int n3 = n2 >>> 1;
        this.log2n = (int)Math.rint(Math.log(n2) / Math.log(2.0));
        this.n = n2;
        int n4 = 0;
        int n5 = 1;
        int n6 = n4 + n2 / 2;
        int n7 = n6 + 1;
        int n8 = n6 + n2 / 2;
        int n9 = n8 + 1;
        int n10 = 0;
        while (n10 < n2 / 4) {
            this.trig[n4 + n10 * 2] = (float)Math.cos(Math.PI / (double)n2 * (double)(4 * n10));
            this.trig[n5 + n10 * 2] = (float)(-Math.sin(Math.PI / (double)n2 * (double)(4 * n10)));
            this.trig[n6 + n10 * 2] = (float)Math.cos(Math.PI / (double)(2 * n2) * (double)(2 * n10 + 1));
            this.trig[n7 + n10 * 2] = (float)Math.sin(Math.PI / (double)(2 * n2) * (double)(2 * n10 + 1));
            ++n10;
        }
        int n11 = 0;
        while (n11 < n2 / 8) {
            this.trig[n8 + n11 * 2] = (float)Math.cos(Math.PI / (double)n2 * (double)(4 * n11 + 2));
            this.trig[n9 + n11 * 2] = (float)(-Math.sin(Math.PI / (double)n2 * (double)(4 * n11 + 2)));
            ++n11;
        }
        int n12 = (1 << this.log2n - 1) - 1;
        int n13 = 1 << this.log2n - 2;
        int n14 = 0;
        while (n14 < n2 / 8) {
            int n15 = 0;
            int n16 = 0;
            while (n13 >>> n16 != 0) {
                if ((n13 >>> n16 & n14) != 0) {
                    n15 |= 1 << n16;
                }
                ++n16;
            }
            this.bitrev[n14 * 2] = ~n15 & n12;
            this.bitrev[n14 * 2 + 1] = n15;
            ++n14;
        }
        this.scale = 4.0f / (float)n2;
    }

    void clear() {
    }

    void forward(float[] fArray, float[] fArray2) {
    }

    synchronized void backward(float[] fArray, float[] fArray2) {
        if (this._x.length < this.n / 2) {
            this._x = new float[this.n / 2];
        }
        if (this._w.length < this.n / 2) {
            this._w = new float[this.n / 2];
        }
        float[] fArray3 = this._x;
        float[] fArray4 = this._w;
        int n2 = this.n >>> 1;
        int n3 = this.n >>> 2;
        int n4 = this.n >>> 3;
        int n5 = 1;
        int n6 = 0;
        int n7 = n2;
        int n8 = 0;
        while (n8 < n4) {
            fArray3[n6++] = -fArray[n5 + 2] * this.trig[(n7 -= 2) + 1] - fArray[n5] * this.trig[n7];
            fArray3[n6++] = fArray[n5] * this.trig[n7 + 1] - fArray[n5 + 2] * this.trig[n7];
            n5 += 4;
            ++n8;
        }
        n5 = n2 - 4;
        n8 = 0;
        while (n8 < n4) {
            fArray3[n6++] = fArray[n5] * this.trig[(n7 -= 2) + 1] + fArray[n5 + 2] * this.trig[n7];
            fArray3[n6++] = fArray[n5] * this.trig[n7] - fArray[n5 + 2] * this.trig[n7 + 1];
            n5 -= 4;
            ++n8;
        }
        float[] fArray5 = this.mdct_kernel(fArray3, fArray4, this.n, n2, n3, n4);
        n6 = 0;
        n7 = n2;
        n8 = n3;
        int n9 = n8 - 1;
        int n10 = n3 + n2;
        int n11 = n10 - 1;
        int n12 = 0;
        while (n12 < n3) {
            float f2 = fArray5[n6] * this.trig[n7 + 1] - fArray5[n6 + 1] * this.trig[n7];
            float f3 = -(fArray5[n6] * this.trig[n7] + fArray5[n6 + 1] * this.trig[n7 + 1]);
            fArray2[n8] = -f2;
            fArray2[n9] = f2;
            fArray2[n10] = f3;
            fArray2[n11] = f3;
            ++n8;
            --n9;
            ++n10;
            --n11;
            n6 += 2;
            n7 += 2;
            ++n12;
        }
    }

    private float[] mdct_kernel(float[] fArray, float[] fArray2, int n2, int n3, int n4, int n5) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n4;
        int n11 = 0;
        int n12 = n4;
        int n13 = n3;
        int n14 = 0;
        while (n14 < n4) {
            float f6 = fArray[n10] - fArray[n11];
            fArray2[n12 + n14] = fArray[n10++] + fArray[n11++];
            float f7 = fArray[n10] - fArray[n11];
            fArray2[n14++] = f6 * this.trig[n13 -= 4] + f7 * this.trig[n13 + 1];
            fArray2[n14] = f7 * this.trig[n13] - f6 * this.trig[n13 + 1];
            fArray2[n12 + n14] = fArray[n10++] + fArray[n11++];
            ++n14;
        }
        int n15 = 0;
        while (n15 < this.log2n - 3) {
            int n16 = n2 >>> n15 + 2;
            n9 = 1 << n15 + 3;
            n8 = n3 - 2;
            n13 = 0;
            n7 = 0;
            while (n7 < n16 >>> 2) {
                n6 = n8;
                n12 = n6 - (n16 >> 1);
                f5 = this.trig[n13];
                f4 = this.trig[n13 + 1];
                n8 -= 2;
                ++n16;
                int n17 = 0;
                while (n17 < 2 << n15) {
                    f3 = fArray2[n6] - fArray2[n12];
                    fArray[n6] = fArray2[n6] + fArray2[n12];
                    f2 = fArray2[++n6] - fArray2[++n12];
                    fArray[n6] = fArray2[n6] + fArray2[n12];
                    fArray[n12] = f2 * f5 - f3 * f4;
                    fArray[n12 - 1] = f3 * f5 + f2 * f4;
                    n6 -= n16;
                    n12 -= n16;
                    ++n17;
                }
                --n16;
                n13 += n9;
                ++n7;
            }
            float[] fArray3 = fArray2;
            fArray2 = fArray;
            fArray = fArray3;
            ++n15;
        }
        n15 = n2;
        int n18 = 0;
        n9 = 0;
        n8 = n3 - 1;
        int n19 = 0;
        while (n19 < n5) {
            n7 = this.bitrev[n18++];
            n6 = this.bitrev[n18++];
            f5 = fArray2[n7] - fArray2[n6 + 1];
            f2 = fArray2[n7 - 1] + fArray2[n6];
            f4 = fArray2[n7] + fArray2[n6 + 1];
            f3 = fArray2[n7 - 1] - fArray2[n6];
            float f8 = f5 * this.trig[n15];
            float f9 = f2 * this.trig[n15++];
            float f10 = f5 * this.trig[n15];
            float f11 = f2 * this.trig[n15++];
            fArray[n9++] = (f4 + f10 + f9) * 0.5f;
            fArray[n8--] = (-f3 + f11 - f8) * 0.5f;
            fArray[n9++] = (f3 + f11 - f8) * 0.5f;
            fArray[n8--] = (f4 - f10 - f9) * 0.5f;
            ++n19;
        }
        return fArray;
    }
}

