/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.FuncMapping;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.FuncTime;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMapping0;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.LookMapping0;
import com.jcraft.jorbis.Mdct;

class Mapping0
extends FuncMapping {
    static int seq = 0;
    float[][] pcmbundle = null;
    int[] zerobundle = null;
    int[] nonzero = null;
    Object[] floormemo = null;

    Mapping0() {
    }

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        LookMapping0 lookMapping0 = new LookMapping0();
        InfoMapping0 infoMapping0 = lookMapping0.map = (InfoMapping0)object;
        lookMapping0.mode = infoMode;
        lookMapping0.time_look = new Object[infoMapping0.submaps];
        lookMapping0.floor_look = new Object[infoMapping0.submaps];
        lookMapping0.residue_look = new Object[infoMapping0.submaps];
        lookMapping0.time_func = new FuncTime[infoMapping0.submaps];
        lookMapping0.floor_func = new FuncFloor[infoMapping0.submaps];
        lookMapping0.residue_func = new FuncResidue[infoMapping0.submaps];
        int n2 = 0;
        while (n2 < infoMapping0.submaps) {
            int n3 = infoMapping0.timesubmap[n2];
            int n4 = infoMapping0.floorsubmap[n2];
            int n5 = infoMapping0.residuesubmap[n2];
            lookMapping0.time_func[n2] = FuncTime.time_P[info.time_type[n3]];
            lookMapping0.time_look[n2] = lookMapping0.time_func[n2].look(dspState, infoMode, info.time_param[n3]);
            lookMapping0.floor_func[n2] = FuncFloor.floor_P[info.floor_type[n4]];
            lookMapping0.floor_look[n2] = lookMapping0.floor_func[n2].look(dspState, infoMode, info.floor_param[n4]);
            lookMapping0.residue_func[n2] = FuncResidue.residue_P[info.residue_type[n5]];
            lookMapping0.residue_look[n2] = lookMapping0.residue_func[n2].look(dspState, infoMode, info.residue_param[n5]);
            ++n2;
        }
        if (info.psys == 0 || dspState.analysisp != 0) {
            // empty if block
        }
        lookMapping0.ch = info.channels;
        return lookMapping0;
    }

    void pack(Info info, Object object, Buffer buffer) {
        int n2;
        InfoMapping0 infoMapping0 = (InfoMapping0)object;
        if (infoMapping0.submaps > 1) {
            buffer.write(1, 1);
            buffer.write(infoMapping0.submaps - 1, 4);
        } else {
            buffer.write(0, 1);
        }
        if (infoMapping0.coupling_steps > 0) {
            buffer.write(1, 1);
            buffer.write(infoMapping0.coupling_steps - 1, 8);
            n2 = 0;
            while (n2 < infoMapping0.coupling_steps) {
                buffer.write(infoMapping0.coupling_mag[n2], Mapping0.ilog2(info.channels));
                buffer.write(infoMapping0.coupling_ang[n2], Mapping0.ilog2(info.channels));
                ++n2;
            }
        } else {
            buffer.write(0, 1);
        }
        buffer.write(0, 2);
        if (infoMapping0.submaps > 1) {
            n2 = 0;
            while (n2 < info.channels) {
                buffer.write(infoMapping0.chmuxlist[n2], 4);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < infoMapping0.submaps) {
            buffer.write(infoMapping0.timesubmap[n2], 8);
            buffer.write(infoMapping0.floorsubmap[n2], 8);
            buffer.write(infoMapping0.residuesubmap[n2], 8);
            ++n2;
        }
    }

    Object unpack(Info info, Buffer buffer) {
        int n2;
        InfoMapping0 infoMapping0 = new InfoMapping0();
        infoMapping0.submaps = buffer.read(1) != 0 ? buffer.read(4) + 1 : 1;
        if (buffer.read(1) != 0) {
            infoMapping0.coupling_steps = buffer.read(8) + 1;
            n2 = 0;
            while (n2 < infoMapping0.coupling_steps) {
                int n3 = infoMapping0.coupling_mag[n2] = buffer.read(Mapping0.ilog2(info.channels));
                int n4 = infoMapping0.coupling_ang[n2] = buffer.read(Mapping0.ilog2(info.channels));
                if (n3 < 0 || n4 < 0 || n3 == n4 || n3 >= info.channels || n4 >= info.channels) {
                    infoMapping0.free();
                    return null;
                }
                ++n2;
            }
        }
        if (buffer.read(2) > 0) {
            infoMapping0.free();
            return null;
        }
        if (infoMapping0.submaps > 1) {
            n2 = 0;
            while (n2 < info.channels) {
                infoMapping0.chmuxlist[n2] = buffer.read(4);
                if (infoMapping0.chmuxlist[n2] >= infoMapping0.submaps) {
                    infoMapping0.free();
                    return null;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < infoMapping0.submaps) {
            infoMapping0.timesubmap[n2] = buffer.read(8);
            if (infoMapping0.timesubmap[n2] >= info.times) {
                infoMapping0.free();
                return null;
            }
            infoMapping0.floorsubmap[n2] = buffer.read(8);
            if (infoMapping0.floorsubmap[n2] >= info.floors) {
                infoMapping0.free();
                return null;
            }
            infoMapping0.residuesubmap[n2] = buffer.read(8);
            if (infoMapping0.residuesubmap[n2] >= info.residues) {
                infoMapping0.free();
                return null;
            }
            ++n2;
        }
        return infoMapping0;
    }

    synchronized int inverse(Block block, Object object) {
        int n2;
        float[] fArray;
        int n3;
        int n4;
        DspState dspState = block.vd;
        Info info = dspState.vi;
        LookMapping0 lookMapping0 = (LookMapping0)object;
        InfoMapping0 infoMapping0 = lookMapping0.map;
        InfoMode infoMode = lookMapping0.mode;
        int n5 = block.pcmend = info.blocksizes[block.W];
        float[] fArray2 = dspState.window[block.W][block.lW][block.nW][infoMode.windowtype];
        if (this.pcmbundle == null || this.pcmbundle.length < info.channels) {
            this.pcmbundle = new float[info.channels][];
            this.nonzero = new int[info.channels];
            this.zerobundle = new int[info.channels];
            this.floormemo = new Object[info.channels];
        }
        int n6 = 0;
        while (n6 < info.channels) {
            float[] fArray3 = block.pcm[n6];
            n4 = infoMapping0.chmuxlist[n6];
            this.floormemo[n6] = lookMapping0.floor_func[n4].inverse1(block, lookMapping0.floor_look[n4], this.floormemo[n6]);
            this.nonzero[n6] = this.floormemo[n6] != null ? 1 : 0;
            n3 = 0;
            while (n3 < n5 / 2) {
                fArray3[n3] = 0.0f;
                ++n3;
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < infoMapping0.coupling_steps) {
            if (this.nonzero[infoMapping0.coupling_mag[n7]] != 0 || this.nonzero[infoMapping0.coupling_ang[n7]] != 0) {
                this.nonzero[infoMapping0.coupling_mag[n7]] = 1;
                this.nonzero[infoMapping0.coupling_ang[n7]] = 1;
            }
            ++n7;
        }
        n4 = 0;
        while (n4 < infoMapping0.submaps) {
            n3 = 0;
            int n8 = 0;
            while (n8 < info.channels) {
                if (infoMapping0.chmuxlist[n8] == n4) {
                    this.zerobundle[n3] = this.nonzero[n8] != 0 ? 1 : 0;
                    this.pcmbundle[n3++] = block.pcm[n8];
                }
                ++n8;
            }
            lookMapping0.residue_func[n4].inverse(block, lookMapping0.residue_look[n4], this.pcmbundle, this.zerobundle, n3);
            ++n4;
        }
        n3 = infoMapping0.coupling_steps - 1;
        while (n3 >= 0) {
            float[] fArray4 = block.pcm[infoMapping0.coupling_mag[n3]];
            fArray = block.pcm[infoMapping0.coupling_ang[n3]];
            n2 = 0;
            while (n2 < n5 / 2) {
                float f2 = fArray4[n2];
                float f3 = fArray[n2];
                if (f2 > 0.0f) {
                    if (f3 > 0.0f) {
                        fArray4[n2] = f2;
                        fArray[n2] = f2 - f3;
                    } else {
                        fArray[n2] = f2;
                        fArray4[n2] = f2 + f3;
                    }
                } else if (f3 > 0.0f) {
                    fArray4[n2] = f2;
                    fArray[n2] = f2 + f3;
                } else {
                    fArray[n2] = f2;
                    fArray4[n2] = f2 - f3;
                }
                ++n2;
            }
            --n3;
        }
        int n9 = 0;
        while (n9 < info.channels) {
            fArray = block.pcm[n9];
            n2 = infoMapping0.chmuxlist[n9];
            lookMapping0.floor_func[n2].inverse2(block, lookMapping0.floor_look[n2], this.floormemo[n9], fArray);
            ++n9;
        }
        int n10 = 0;
        while (n10 < info.channels) {
            float[] fArray5 = block.pcm[n10];
            ((Mdct)dspState.transform[block.W][0]).backward(fArray5, fArray5);
            ++n10;
        }
        int n11 = 0;
        while (n11 < info.channels) {
            int n12;
            float[] fArray6 = block.pcm[n11];
            if (this.nonzero[n11] != 0) {
                n12 = 0;
                while (n12 < n5) {
                    int n13 = n12;
                    fArray6[n13] = fArray6[n13] * fArray2[n12];
                    ++n12;
                }
            } else {
                n12 = 0;
                while (n12 < n5) {
                    fArray6[n12] = 0.0f;
                    ++n12;
                }
            }
            ++n11;
        }
        return 0;
    }

    private static int ilog2(int n2) {
        int n3 = 0;
        while (n2 > 1) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }
}

