/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.EchstateFloor0;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoFloor0;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.LookFloor0;
import com.jcraft.jorbis.Lsp;

class Floor0
extends FuncFloor {
    float[] lsp = null;

    Floor0() {
    }

    void pack(Object object, Buffer buffer) {
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        buffer.write(infoFloor0.order, 8);
        buffer.write(infoFloor0.rate, 16);
        buffer.write(infoFloor0.barkmap, 16);
        buffer.write(infoFloor0.ampbits, 6);
        buffer.write(infoFloor0.ampdB, 8);
        buffer.write(infoFloor0.numbooks - 1, 4);
        int n2 = 0;
        while (n2 < infoFloor0.numbooks) {
            buffer.write(infoFloor0.books[n2], 8);
            ++n2;
        }
    }

    Object unpack(Info info, Buffer buffer) {
        InfoFloor0 infoFloor0 = new InfoFloor0();
        infoFloor0.order = buffer.read(8);
        infoFloor0.rate = buffer.read(16);
        infoFloor0.barkmap = buffer.read(16);
        infoFloor0.ampbits = buffer.read(6);
        infoFloor0.ampdB = buffer.read(8);
        infoFloor0.numbooks = buffer.read(4) + 1;
        if (infoFloor0.order < 1 || infoFloor0.rate < 1 || infoFloor0.barkmap < 1 || infoFloor0.numbooks < 1) {
            return null;
        }
        int n2 = 0;
        while (n2 < infoFloor0.numbooks) {
            infoFloor0.books[n2] = buffer.read(8);
            if (infoFloor0.books[n2] < 0 || infoFloor0.books[n2] >= info.books) {
                return null;
            }
            ++n2;
        }
        return infoFloor0;
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        LookFloor0 lookFloor0 = new LookFloor0();
        lookFloor0.m = infoFloor0.order;
        lookFloor0.n = info.blocksizes[infoMode.blockflag] / 2;
        lookFloor0.ln = infoFloor0.barkmap;
        lookFloor0.vi = infoFloor0;
        lookFloor0.lpclook.init(lookFloor0.ln, lookFloor0.m);
        float f2 = (float)lookFloor0.ln / Floor0.toBARK((float)((double)infoFloor0.rate / 2.0));
        lookFloor0.linearmap = new int[lookFloor0.n];
        int n2 = 0;
        while (n2 < lookFloor0.n) {
            int n3 = (int)Math.floor(Floor0.toBARK((float)((double)infoFloor0.rate / 2.0 / (double)lookFloor0.n * (double)n2)) * f2);
            if (n3 >= lookFloor0.ln) {
                n3 = lookFloor0.ln;
            }
            lookFloor0.linearmap[n2] = n3;
            ++n2;
        }
        return lookFloor0;
    }

    static float toBARK(float f2) {
        return (float)(13.1 * Math.atan(7.4E-4 * (double)f2) + 2.24 * Math.atan((double)(f2 * f2) * 1.85E-8) + 1.0E-4 * (double)f2);
    }

    Object state(Object object) {
        EchstateFloor0 echstateFloor0 = new EchstateFloor0();
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        echstateFloor0.codewords = new int[infoFloor0.order];
        echstateFloor0.curve = new float[infoFloor0.barkmap];
        echstateFloor0.frameno = -1L;
        return echstateFloor0;
    }

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    void free_state(Object object) {
    }

    int forward(Block block, Object object, float[] fArray, float[] fArray2, Object object2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    int inverse(Block block, Object object, float[] fArray) {
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        int n2 = block.opb.read(infoFloor0.ampbits);
        if (n2 > 0) {
            int n3 = (1 << infoFloor0.ampbits) - 1;
            float f2 = (float)n2 / (float)n3 * (float)infoFloor0.ampdB;
            int n4 = block.opb.read(Floor0.ilog(infoFloor0.numbooks));
            if (n4 != -1 && n4 < infoFloor0.numbooks) {
                Floor0 floor0 = this;
                synchronized (floor0) {
                    int n5;
                    if (this.lsp == null || this.lsp.length < lookFloor0.m) {
                        this.lsp = new float[lookFloor0.m];
                    } else {
                        int n6 = 0;
                        while (n6 < lookFloor0.m) {
                            this.lsp[n6] = 0.0f;
                            ++n6;
                        }
                    }
                    CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n4]];
                    float f3 = 0.0f;
                    int n7 = 0;
                    while (n7 < lookFloor0.m) {
                        fArray[n7] = 0.0f;
                        ++n7;
                    }
                    int n8 = 0;
                    while (n8 < lookFloor0.m) {
                        if (codeBook.decodevs(this.lsp, n8, block.opb, 1, -1) == -1) {
                            int n9 = 0;
                            while (n9 < lookFloor0.n) {
                                fArray[n9] = 0.0f;
                                ++n9;
                            }
                            int n10 = 0;
                            return n10;
                        }
                        n8 += codeBook.dim;
                    }
                    int n11 = 0;
                    while (n11 < lookFloor0.m) {
                        n5 = 0;
                        while (n5 < codeBook.dim) {
                            int n12 = n11++;
                            this.lsp[n12] = this.lsp[n12] + f3;
                            ++n5;
                        }
                        f3 = this.lsp[n11 - 1];
                    }
                    Lsp.lsp_to_curve(fArray, lookFloor0.linearmap, lookFloor0.n, lookFloor0.ln, this.lsp, lookFloor0.m, f2, infoFloor0.ampdB);
                    n5 = 1;
                    return n5;
                }
            }
        }
        return 0;
    }

    Object inverse1(Block block, Object object, Object object2) {
        int n2;
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        float[] fArray = null;
        if (object2 instanceof float[]) {
            fArray = (float[])object2;
        }
        if ((n2 = block.opb.read(infoFloor0.ampbits)) > 0) {
            int n3 = (1 << infoFloor0.ampbits) - 1;
            float f2 = (float)n2 / (float)n3 * (float)infoFloor0.ampdB;
            int n4 = block.opb.read(Floor0.ilog(infoFloor0.numbooks));
            if (n4 != -1 && n4 < infoFloor0.numbooks) {
                int n5;
                CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n4]];
                float f3 = 0.0f;
                if (fArray == null || fArray.length < lookFloor0.m + 1) {
                    fArray = new float[lookFloor0.m + 1];
                } else {
                    n5 = 0;
                    while (n5 < fArray.length) {
                        fArray[n5] = 0.0f;
                        ++n5;
                    }
                }
                n5 = 0;
                while (n5 < lookFloor0.m) {
                    if (codeBook.decodev_set(fArray, n5, block.opb, codeBook.dim) == -1) {
                        return null;
                    }
                    n5 += codeBook.dim;
                }
                int n6 = 0;
                while (n6 < lookFloor0.m) {
                    int n7 = 0;
                    while (n7 < codeBook.dim) {
                        int n8 = n6++;
                        fArray[n8] = fArray[n8] + f3;
                        ++n7;
                    }
                    f3 = fArray[n6 - 1];
                }
                fArray[lookFloor0.m] = f2;
                return fArray;
            }
        }
        return null;
    }

    int inverse2(Block block, Object object, Object object2, float[] fArray) {
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        if (object2 != null) {
            float[] fArray2 = (float[])object2;
            float f2 = fArray2[lookFloor0.m];
            Lsp.lsp_to_curve(fArray, lookFloor0.linearmap, lookFloor0.n, lookFloor0.ln, fArray2, lookFloor0.m, f2, infoFloor0.ampdB);
            return 1;
        }
        int n2 = 0;
        while (n2 < lookFloor0.n) {
            fArray[n2] = 0.0f;
            ++n2;
        }
        return 0;
    }

    static float fromdB(float f2) {
        return (float)Math.exp((double)f2 * 0.11512925);
    }

    private static int ilog(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }

    static void lsp_to_lpc(float[] fArray, float[] fArray2, int n2) {
        int n3 = n2 / 2;
        float[] fArray3 = new float[n3];
        float[] fArray4 = new float[n3];
        float[] fArray5 = new float[n3 + 1];
        float[] fArray6 = new float[n3 + 1];
        float[] fArray7 = new float[n3];
        float[] fArray8 = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            fArray3[n4] = (float)(-2.0 * Math.cos(fArray[n4 * 2]));
            fArray4[n4] = (float)(-2.0 * Math.cos(fArray[n4 * 2 + 1]));
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            fArray5[n5] = 0.0f;
            fArray6[n5] = 1.0f;
            fArray7[n5] = 0.0f;
            fArray8[n5] = 1.0f;
            ++n5;
        }
        fArray6[n5] = 1.0f;
        fArray5[n5] = 1.0f;
        n4 = 1;
        while (n4 < n2 + 1) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            n5 = 0;
            while (n5 < n3) {
                float f4 = fArray3[n5] * fArray6[n5] + fArray5[n5];
                fArray5[n5] = fArray6[n5];
                fArray6[n5] = f3;
                f3 += f4;
                f4 = fArray4[n5] * fArray8[n5] + fArray7[n5];
                fArray7[n5] = fArray8[n5];
                fArray8[n5] = f2;
                f2 += f4;
                ++n5;
            }
            fArray2[n4 - 1] = (f3 + fArray6[n5] + f2 - fArray5[n5]) / 2.0f;
            fArray6[n5] = f3;
            fArray5[n5] = f2;
            ++n4;
        }
    }

    static void lpc_to_curve(float[] fArray, float[] fArray2, float f2, LookFloor0 lookFloor0, String string, int n2) {
        float[] fArray3 = new float[Math.max(lookFloor0.ln * 2, lookFloor0.m * 2 + 2)];
        if (f2 == 0.0f) {
            int n3 = 0;
            while (n3 < lookFloor0.n) {
                fArray[n3] = 0.0f;
                ++n3;
            }
            return;
        }
        lookFloor0.lpclook.lpc_to_curve(fArray3, fArray2, f2);
        int n4 = 0;
        while (n4 < lookFloor0.n) {
            fArray[n4] = fArray3[lookFloor0.linearmap[n4]];
            ++n4;
        }
    }
}

