/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.VorbisFile;

class ChainingExample {
    ChainingExample() {
    }

    public static void main(String[] stringArray) {
        VorbisFile vorbisFile = null;
        try {
            vorbisFile = new VorbisFile(System.in, null, -1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
        if (vorbisFile.seekable()) {
            System.out.println("Input bitstream contained " + vorbisFile.streams() + " logical bitstream section(s).");
            System.out.println("Total bitstream playing time: " + vorbisFile.time_total(-1) + " seconds\n");
        } else {
            System.out.println("Standard input was not seekable.");
            System.out.println("First logical bitstream information:\n");
        }
        int n2 = 0;
        while (n2 < vorbisFile.streams()) {
            Info info = vorbisFile.getInfo(n2);
            System.out.println("\tlogical bitstream section " + (n2 + 1) + " information:");
            System.out.println("\t\t" + info.rate + "Hz " + info.channels + " channels bitrate " + vorbisFile.bitrate(n2) / 1000 + "kbps serial number=" + vorbisFile.serialnumber(n2));
            System.out.print("\t\tcompressed length: " + vorbisFile.raw_total(n2) + " bytes ");
            System.out.println(" play time: " + vorbisFile.time_total(n2) + "s");
            Comment comment = vorbisFile.getComment(n2);
            System.out.println(comment);
            ++n2;
        }
    }
}

