/*
 * Decompiled with CFR 0.152.
 */
package araword.utils;

import araword.G;
import araword.classes.AWElement;
import araword.db.DBManagement;
import araword.db.DBResult;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;

public class TextUtils {
    public static void newDocument() {
        try {
            G.elementList.clear();
            G.textZone.setText("");
            G.textZone.setStyledDocument(new DefaultStyledDocument());
            AWElement elem = AWElement.createPictogramElement(0, "AraWord");
            G.elementList.add(0, elem);
            TextUtils.regenerateTextZone();
            G.elementList.get(0).getTextField().requestFocusInWindow();
            G.elementList.get(0).getTextField().setCaretPosition(0);
            G.activeDocumentFileName = "";
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static Object copy(Object orig) {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return obj;
    }

    public static void regenerateTextZone() {
        G.textZone.setText("");
        G.textZone.setStyledDocument(new DefaultStyledDocument());
        for (AWElement elem : G.elementList) {
            if (elem.getType() == 0) {
                G.textZone.insertComponent(elem);
                continue;
            }
            try {
                G.textZone.getStyledDocument().insertString(G.textZone.getStyledDocument().getLength(), elem.getSeparator(), null);
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
    }

    public static void regeneratePDFPrevZone(JTextPane prevZone, int page) {
        int numPage = 1;
        double ratio = 2.164;
        prevZone.setMargin(new Insets((int)(10.0 / ratio), (int)(10.0 / ratio), (int)(10.0 / ratio), (int)(10.0 / ratio)));
        prevZone.setText("");
        prevZone.setStyledDocument(new DefaultStyledDocument());
        int numPixelsHor = 270;
        int numPixelsVer = 370;
        double pictoRatio = 1.5;
        int numPixelsHorConsumed = 0;
        int numPixelsVerConsumed = G.imagesSize;
        int pxPerTab = 25;
        int pxPerSpace = 4;
        int picLine = 0;
        boolean justReadNewLine = false;
        int pxPerNewLine = 6;
        int numElements = G.elementList.size();
        int i = 0;
        while (i < numElements) {
            AWElement elem = G.elementList.get(i);
            if (elem.getType() == 0) {
                justReadNewLine = false;
                if ((numPixelsHorConsumed += G.imagesSize) > numPixelsHor || ++picLine > G.numPictosLinePDF) {
                    if (numPage == page) {
                        try {
                            prevZone.getStyledDocument().insertString(prevZone.getStyledDocument().getLength(), "\n", null);
                        }
                        catch (Exception exc) {
                            System.out.println(exc);
                        }
                    }
                    numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                    numPixelsHorConsumed = G.imagesSize;
                    picLine = 1;
                }
                if (numPixelsVerConsumed < numPixelsVer) {
                    AWElement newElem = null;
                    newElem = AWElement.createPDFPrevPictogramElement(i, elem.getTextField().getText(), elem.getNumPictogram(), elem.isVisibleImage(), elem.isVisibleBorder(), elem.isSearchImageOnBD(), elem.getWordSearchBD(), true);
                    if (numPage == page) {
                        prevZone.insertComponent(newElem);
                    }
                } else {
                    picLine = 0;
                    numPixelsHorConsumed = 0;
                    numPixelsVerConsumed = G.imagesSize;
                    ++numPage;
                    --i;
                }
            } else {
                try {
                    if (elem.getSeparator().equals("\n")) {
                        numPixelsVerConsumed = justReadNewLine ? (numPixelsVerConsumed += pxPerNewLine) : (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                        justReadNewLine = true;
                        numPixelsHorConsumed = 0;
                        picLine = 0;
                        if (numPage == page) {
                            prevZone.getStyledDocument().insertString(prevZone.getStyledDocument().getLength(), elem.getSeparator(), null);
                        }
                    } else if (elem.getSeparator().equals("\t")) {
                        numPixelsHorConsumed += pxPerTab;
                        if (numPage == page) {
                            prevZone.getStyledDocument().insertString(prevZone.getStyledDocument().getLength(), elem.getSeparator(), null);
                        }
                        if (numPixelsHorConsumed > numPixelsHor) {
                            numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                            numPixelsHorConsumed = pxPerTab;
                        }
                    } else if (elem.getSeparator().equals("  ")) {
                        numPixelsHorConsumed += pxPerSpace;
                        if (numPage == page) {
                            prevZone.getStyledDocument().insertString(prevZone.getStyledDocument().getLength(), elem.getSeparator(), null);
                        }
                        if (numPixelsHorConsumed > numPixelsHor) {
                            numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                            numPixelsHorConsumed = pxPerSpace;
                        }
                    }
                }
                catch (Exception exc) {
                    System.out.println(exc);
                }
            }
            ++i;
        }
    }

    public static void regenerateDocument() {
        int numElements = G.elementList.size();
        int i = 0;
        while (i < numElements) {
            AWElement elem = G.elementList.get(i);
            if (elem.getType() == 0) {
                G.elementList.remove(i);
                AWElement newElem = null;
                newElem = AWElement.createPictogramElement(i, elem.getTextField().getText(), elem.getNumPictogram(), elem.isVisibleImage(), elem.isVisibleBorder(), elem.isSearchImageOnBD(), elem.getWordSearchBD());
                G.elementList.add(i, newElem);
            }
            ++i;
        }
        TextUtils.regenerateTextZone();
    }

    public static String getText() {
        String text = "";
        int numElements = G.elementList.size();
        int i = 0;
        while (i < numElements) {
            AWElement elem = G.elementList.get(i);
            text = elem.getType() == 0 ? String.valueOf(text) + elem.getTextField().getText() : String.valueOf(text) + " ";
            ++i;
        }
        System.out.println(text);
        return text;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCompoundWord() {
        try {
            int tmpCaret = G.activeElement.getTextField().getCaretPosition();
            int lengthWord = G.maxLengthCompoundWords;
            while (lengthWord >= 2) {
                int offsetWord = 0;
                while (offsetWord < lengthWord) {
                    DBResult dbr;
                    String str = TextUtils.obtainWord(lengthWord, offsetWord);
                    if (str != null && (dbr = DBManagement.searchOnDB(str, 0)).getImage() != G.notFound) {
                        int maxPosition = G.activeElementPosition + 2 * offsetWord;
                        int minPosition = maxPosition - 2 * (lengthWord - 1);
                        int countCaret = 0;
                        boolean endCountCaret = false;
                        int cont = minPosition;
                        while (cont <= maxPosition) {
                            if (cont != G.activeElementPosition) {
                                if (!endCountCaret) {
                                    countCaret = G.elementList.get(minPosition).getType() == 0 ? (countCaret += G.elementList.get(minPosition).getTextField().getText().length()) : ++countCaret;
                                }
                            } else {
                                endCountCaret = true;
                                countCaret += tmpCaret;
                            }
                            G.elementList.remove(minPosition);
                            ++cont;
                        }
                        G.elementList.add(minPosition, AWElement.createPictogramElement(minPosition, str));
                        int count = minPosition + 1;
                        while (count < G.elementList.size()) {
                            AWElement tmp = G.elementList.get(count);
                            tmp.setPosition(tmp.getPosition() - (maxPosition - minPosition));
                            ++count;
                        }
                        G.elementList.get(minPosition).getTextField().setText(str);
                        G.elementList.get(minPosition).regeneratePictogram();
                        TextUtils.regenerateTextZone();
                        G.elementList.get(minPosition).getTextField().requestFocusInWindow();
                        G.elementList.get(minPosition).getTextField().setCaretPosition(countCaret);
                        G.elementList.get(minPosition).setCompound(true);
                        G.activeElement = G.elementList.get(minPosition);
                        G.activeComponent = G.elementList.get(minPosition).getTextField();
                        G.activeElementPosition = minPosition;
                        return true;
                    }
                    ++offsetWord;
                }
                --lengthWord;
            }
            G.activeElement.regeneratePictogram();
            G.activeElement.getTextField().requestFocusInWindow();
            G.activeElement.getTextField().setCaretPosition(tmpCaret);
            return false;
        }
        catch (Exception exc) {
            System.out.println(exc);
            return false;
        }
    }

    private static String obtainWord(int lengthWord, int offsetWord) {
        if (G.activeElementPosition + 2 * offsetWord > G.elementList.size() - 1) {
            return null;
        }
        if (G.activeElementPosition + 2 * offsetWord - 2 * (lengthWord - 1) < 0) {
            return null;
        }
        int cont = 0;
        while (cont < lengthWord) {
            if (G.elementList.get(G.activeElementPosition + 2 * offsetWord - 2 * cont).getType() != 0) {
                return null;
            }
            if (G.elementList.get(G.activeElementPosition + 2 * offsetWord - 2 * cont).isCompound()) {
                return null;
            }
            ++cont;
        }
        cont = 0;
        while (cont < lengthWord - 1) {
            if (G.elementList.get(G.activeElementPosition + 2 * offsetWord - 1 - 2 * cont).getType() == 1 && !G.elementList.get(G.activeElementPosition + 2 * offsetWord - 1 - 2 * cont).getSeparator().equals("  ")) {
                return null;
            }
            ++cont;
        }
        StringBuilder strAux = new StringBuilder(G.elementList.get(G.activeElementPosition + 2 * offsetWord).getTextField().getText());
        int cont2 = 1;
        while (cont2 < lengthWord) {
            strAux.insert(0, " ");
            strAux.insert(0, G.elementList.get(G.activeElementPosition + 2 * offsetWord - 2 * cont2).getTextField().getText());
            ++cont2;
        }
        return strAux.toString();
    }

    public static void splitWord() {
        try {
            if (!G.activeElement.isCompound()) {
                return;
            }
            int tmpCaret = G.activeElement.getTextField().getCaretPosition();
            String compoundWord = G.activeElement.getTextField().getText();
            StringTokenizer tokens = new StringTokenizer(compoundWord);
            G.elementList.remove(G.activeElementPosition);
            int numElements = 0;
            int numElementsUntilCaret = 0;
            boolean endCountCaret = false;
            while (tokens.hasMoreTokens()) {
                String str = tokens.nextToken();
                G.elementList.add(G.activeElementPosition + numElements, AWElement.createPictogramElement(G.activeElementPosition + numElements, str));
                ++numElements;
                if (tmpCaret - str.length() - 1 <= 0) {
                    endCountCaret = true;
                }
                if (!endCountCaret) {
                    ++numElementsUntilCaret;
                    tmpCaret = tmpCaret - str.length() - 1;
                }
                if (!tokens.hasMoreTokens()) continue;
                G.elementList.add(G.activeElementPosition + numElements, AWElement.createSeparatorElement(G.activeElementPosition + numElements, "  "));
                ++numElements;
                if (endCountCaret) continue;
                ++numElementsUntilCaret;
            }
            int count = G.activeElementPosition + numElements;
            while (count < G.elementList.size()) {
                AWElement tmp = G.elementList.get(count);
                tmp.setPosition(tmp.getPosition() + numElements - 1);
                ++count;
            }
            TextUtils.regenerateTextZone();
            G.elementList.get(G.activeElementPosition + numElementsUntilCaret).getTextField().requestFocusInWindow();
            G.elementList.get(G.activeElementPosition + numElementsUntilCaret).getTextField().setCaretPosition(tmpCaret);
            G.activeElement = G.elementList.get(G.activeElementPosition + numElementsUntilCaret);
            G.activeComponent = G.elementList.get(G.activeElementPosition + numElementsUntilCaret).getTextField();
            G.activeElementPosition += numElementsUntilCaret;
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void printModel() {
        for (AWElement elem2 : G.elementList) {
            if (elem2.getType() == 0) {
                System.out.println("Soy el elemento " + elem2.getPosition() + " y soy de tipo pictograma y mi campo de texto tiene esto: " + elem2.getTextField().getText() + " y mi valor de compuesto es: " + elem2.isCompound());
                continue;
            }
            if (elem2.getSeparator().equals("\n")) {
                System.out.println("Soy el elemento " + elem2.getPosition() + " y soy de tipo nueva l\u00ednea");
                continue;
            }
            if (elem2.getSeparator().equals("\t")) {
                System.out.println("Soy el elemento " + elem2.getPosition() + " y soy de tipo tabulador");
                continue;
            }
            if (elem2.getSeparator().equals("  ")) {
                System.out.println("Soy el elemento " + elem2.getPosition() + " y soy de tipo espacio");
                continue;
            }
            System.out.println("Soy el elemento " + elem2.getPosition() + "y conmigo ha pasado algo muy raro");
        }
        System.out.println("Selection state: " + G.selectionState);
    }

    public static void updateUndo() {
        G.undoList.add(0, TextUtils.ElementList2String(G.elementList));
        if (G.undoList.size() > G.maxUndoLevel) {
            G.undoList.remove(G.maxUndoLevel);
        }
    }

    public static ArrayList<AWElement> String2ElementList(String str) {
        String aux = "";
        ArrayList<AWElement> eL = new ArrayList<AWElement>();
        int tempPos = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') {
                if (!aux.equals("")) {
                    AWElement newElem = AWElement.createPictogramElement(tempPos, aux);
                    eL.add(tempPos, newElem);
                    ++tempPos;
                }
                AWElement newAuxElem = null;
                if (c == ' ') {
                    newAuxElem = AWElement.createSeparatorElement(tempPos, "  ");
                } else if (c == '\t') {
                    newAuxElem = AWElement.createSeparatorElement(tempPos, "\t");
                } else if (c == '\n') {
                    newAuxElem = AWElement.createSeparatorElement(tempPos, "\n");
                } else {
                    System.out.println("Something wrong parsing string, position " + tempPos);
                }
                eL.add(tempPos, newAuxElem);
                ++tempPos;
                aux = "";
            } else {
                aux = String.valueOf(aux) + c;
            }
            ++i;
        }
        if (!aux.equals("")) {
            AWElement newElem = AWElement.createPictogramElement(tempPos, aux);
            eL.add(tempPos, newElem);
        }
        return eL;
    }

    public static String ElementList2String(ArrayList<AWElement> eL) {
        String str = "";
        for (AWElement elem2 : eL) {
            if (elem2.getType() == 0) {
                str = String.valueOf(str) + elem2.getTextField().getText();
                continue;
            }
            if (elem2.getSeparator().equals("  ")) {
                str = String.valueOf(str) + " ";
                continue;
            }
            if (elem2.getSeparator().equals("\t")) {
                str = String.valueOf(str) + "\t";
                continue;
            }
            if (!elem2.getSeparator().equals("\n")) continue;
            str = String.valueOf(str) + "\n";
        }
        return str;
    }

    public static void concatPDFs(List<InputStream> streamOfPDFFiles, OutputStream outputStream, boolean paginate) {
        Document document = new Document();
        try {
            try {
                List<InputStream> pdfs = streamOfPDFFiles;
                ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
                int totalPages = 0;
                for (InputStream pdf : pdfs) {
                    PdfReader pdfReader = new PdfReader(pdf);
                    readers.add(pdfReader);
                    totalPages += pdfReader.getNumberOfPages();
                }
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
                document.open();
                BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
                PdfContentByte cb = writer.getDirectContent();
                int currentPageNumber = 0;
                int pageOfCurrentReaderPDF = 0;
                for (PdfReader pdfReader : readers) {
                    while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                        document.newPage();
                        ++currentPageNumber;
                        PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                        cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                        if (!paginate) continue;
                        cb.beginText();
                        cb.setFontAndSize(bf, 9.0f);
                        cb.showTextAligned(1, currentPageNumber + " / " + totalPages, 520.0f, 5.0f, 0.0f);
                        cb.endText();
                    }
                    pageOfCurrentReaderPDF = 0;
                }
                outputStream.flush();
                document.close();
                outputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (document.isOpen()) {
                    document.close();
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

