/*
 * Decompiled with CFR 0.152.
 */
package araword.utils;

import araword.G;
import araword.utils.TInterpreterMp3Sound;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TInterpreterGoogleTTS
implements Runnable {
    private String voiceName;
    private String text;

    public void setCurrentVoiceAndText(String text) {
        this.voiceName = this.translateLanguage();
        this.text = text;
    }

    private String translateLanguage() {
        String code = "ES_ES";
        if (G.defaultDocumentLanguage.equals("Castellano")) {
            code = "ES_ES";
        }
        if (G.defaultDocumentLanguage.equals("Ingles")) {
            code = "EN";
        }
        if (G.defaultDocumentLanguage.equals("Catalan")) {
            code = "ES";
        }
        if (G.defaultDocumentLanguage.equals("Euskera")) {
            code = "ES";
        }
        if (G.defaultDocumentLanguage.equals("Gallego")) {
            code = "ES";
        }
        if (G.defaultDocumentLanguage.equals("Aleman")) {
            code = "DE";
        }
        if (G.defaultDocumentLanguage.equals("Frances")) {
            code = "FR";
        }
        if (G.defaultDocumentLanguage.equals("Italiano")) {
            code = "IT";
        }
        if (G.defaultDocumentLanguage.equals("Portugues")) {
            code = "PT";
        }
        if (G.defaultDocumentLanguage.equals("Portugues Brasis")) {
            code = "PT_BR";
        }
        return code;
    }

    @Override
    public void run() {
        String texto = this.text.toLowerCase();
        ArrayList<String> TTSList = new ArrayList<String>();
        while (texto.length() > 100) {
            int index = 99;
            while (texto.charAt(index) != ' ' && texto.charAt(index) != '.' && texto.charAt(index) != ',' && texto.charAt(index) != ';' && texto.charAt(index) != ':') {
                --index;
            }
            String cacho = texto.substring(0, index);
            TTSList.add(cacho);
            texto = texto.substring(index, texto.length());
        }
        TTSList.add(texto);
        for (String TTSPiece : TTSList) {
            File outputFile = new File("sintesis_tmp.mp3");
            try {
                String text = URLEncoder.encode(TTSPiece, "utf-8");
                String strUrl = "http://translate.google.com/translate_tts?tl=" + this.voiceName + "&q=" + text;
                URL url = new URL(strUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:11.0) Gecko/20100101 Firefox/11.0");
                connection.connect();
                InputStream is = connection.getInputStream();
                FileOutputStream fos = new FileOutputStream(outputFile);
                byte[] buffer = new byte[1024];
                while (is.read(buffer) > -1) {
                    fos.write(buffer);
                }
                fos.close();
            }
            catch (Exception ex) {
                Logger.getLogger(TInterpreterGoogleTTS.class.getName()).log(Level.SEVERE, null, ex);
            }
            TInterpreterMp3Sound tims = new TInterpreterMp3Sound(outputFile.toString());
            outputFile.delete();
            tims.TPlay();
            while (!tims.TIsFinished()) {
            }
        }
    }

    public static void main(String[] args) {
        TInterpreterGoogleTTS tg = new TInterpreterGoogleTTS();
        tg.setCurrentVoiceAndText("Esto es una prueba");
        tg.run();
    }
}

