/*
 * Decompiled with CFR 0.152.
 */
package araword.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RelativePath {
    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            File r = f.getCanonicalFile();
            while (r != null) {
                l.add(r.getName());
                r = r.getParentFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List r, List f) {
        String s = "";
        int i = r.size() - 1;
        int j = f.size() - 1;
        while (i >= 0 && j >= 0 && r.get(i).equals(f.get(j))) {
            --i;
            --j;
        }
        while (i >= 0) {
            s = String.valueOf(s) + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = String.valueOf(s) + f.get(j) + File.separator;
            --j;
        }
        s = String.valueOf(s) + f.get(j);
        return s;
    }

    public static String getRelativePath(File home, File f) {
        List homelist = RelativePath.getPathList(home);
        List filelist = RelativePath.getPathList(f);
        String s = RelativePath.matchPathLists(homelist, filelist);
        return s;
    }
}

