/*
 * Decompiled with CFR 0.152.
 */
package araword.configuration;

import araword.G;
import araword.configuration.TResourceBundle;
import araword.utils.TFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;

public class TLanguage {
    private static String LANGUAGE_DIRECTORY = "lang";
    protected static String currentLanguage = G.applicationLanguage;
    protected static Map languagesMap = TLanguage.getLanguages();
    protected static TResourceBundle LANGUAGE_BUNDLE = null;

    public static void initLanguage(String language) throws IOException {
        languagesMap = TLanguage.getLanguages();
        if (languagesMap == null || languagesMap.isEmpty()) {
            throw new FileNotFoundException();
        }
        currentLanguage = language;
        if (currentLanguage == null || !languagesMap.containsKey(currentLanguage)) {
            Iterator languagesIterator = languagesMap.entrySet().iterator();
            Map.Entry languageEntry = languagesIterator.next();
            currentLanguage = (String)languageEntry.getKey();
        }
        FileInputStream i = new FileInputStream((File)languagesMap.get(currentLanguage));
        LANGUAGE_BUNDLE = new TResourceBundle(i);
    }

    public static boolean languageExists(String language) {
        Map languageMap = TLanguage.getLanguages();
        return languageMap.containsKey(language);
    }

    public static Map getLanguages() {
        Hashtable<String, File> languagesMap = new Hashtable<String, File>();
        File languageDirectory = new File(LANGUAGE_DIRECTORY);
        File[] fileList = languageDirectory.listFiles();
        int i = 0;
        while (i < fileList.length) {
            try {
                if (TFileUtils.getExtension(fileList[i]).equals("lang")) {
                    TResourceBundle currentLanguageBundle = new TResourceBundle(new FileInputStream(fileList[i]));
                    languagesMap.put(currentLanguageBundle.getString("LANG_NAME"), fileList[i]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        return languagesMap;
    }

    public static String getString(String key) {
        try {
            return LANGUAGE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('\u00a1') + key + '!';
        }
        catch (NullPointerException e) {
            return String.valueOf('\u00a1') + key + '!';
        }
    }

    public static String getString(String language, String key) {
        String keyValue = null;
        File languageDirectory = new File(LANGUAGE_DIRECTORY);
        File[] fileList = languageDirectory.listFiles();
        int i = 0;
        while (i < fileList.length) {
            try {
                TResourceBundle currentLanguageBundle;
                if (TFileUtils.getExtension(fileList[i]).equals("lang") && language.equals((currentLanguageBundle = new TResourceBundle(new FileInputStream(fileList[i]))).getString("LANG_NAME"))) {
                    keyValue = currentLanguageBundle.getString(key);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        return keyValue;
    }
}

