/*
 * Decompiled with CFR 0.152.
 */
package com.cloudgarden.speech.userinterface;

import com.cloudgarden.speech.userinterface.NodeRenderer;
import com.cloudgarden.speech.userinterface.SpeechNode;
import com.cloudgarden.speech.userinterface.VoiceNode;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class SynthesizerNode
extends SpeechNode {
    private SynthesizerModeDesc g;

    static {
        NodeRenderer.addImageIcon("synthesizer.gif");
    }

    public String getIconName() {
        return "synthesizer.gif";
    }

    public SynthesizerNode(String string) {
        super(string);
    }

    public void handleSelection() {
        if (this.g == null || this.getTree() == null) {
            return;
        }
        this.getTree().a(this.g);
    }

    public SynthesizerNode(SynthesizerModeDesc synthesizerModeDesc) {
        this.g = synthesizerModeDesc;
        this.if = String.valueOf(synthesizerModeDesc.getModeName()) + ", " + synthesizerModeDesc.getLocale().getDisplayName();
        Voice[] voiceArray = synthesizerModeDesc.getVoices();
        if (voiceArray == null) {
            this.addVoice(null);
        } else {
            int n = 0;
            while (n < voiceArray.length) {
                this.addVoice(voiceArray[n]);
                ++n;
            }
        }
    }

    public SynthesizerModeDesc getDesc() {
        return this.g;
    }

    public void selectVoice(Voice voice) {
        int n = 0;
        while (n < this.getChildCount()) {
            if (this.getChildAt(n) instanceof VoiceNode) {
                VoiceNode voiceNode = (VoiceNode)this.getChildAt(n);
                if (voiceNode.getVoice().equals(voice)) {
                    voiceNode.setSelected(true);
                } else {
                    voiceNode.setSelected(false);
                }
            }
            ++n;
        }
    }

    public void addVoice(Voice voice) {
        if (voice == null) {
            this.add(new VoiceNode("No Voices"));
        } else {
            this.add(new VoiceNode(voice, this.g));
        }
    }
}

