/*
 * Decompiled with CFR 0.152.
 */
package com.cloudgarden.speech;

import com.cloudgarden.speech.CGEngine;
import com.cloudgarden.speech.CGEngineProperties;
import com.cloudgarden.speech.CGSpeakableEvent;
import com.cloudgarden.speech.CGSpeakableListener;
import com.cloudgarden.speech.CGSynthesizerModeDesc;
import com.cloudgarden.speech.CGSynthesizerProperties;
import com.cloudgarden.speech.CGVoice;
import com.cloudgarden.speech.LangToLocale;
import com.cloudgarden.speech.XMLTag;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.speech.AudioException;
import javax.speech.EngineException;
import javax.speech.EngineList;
import javax.speech.EngineListener;
import javax.speech.EngineModeDesc;
import javax.speech.EngineProperties;
import javax.speech.EngineStateError;
import javax.speech.Word;
import javax.speech.recognition.RuleToken;
import javax.speech.synthesis.JSMLException;
import javax.speech.synthesis.Speakable;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerEvent;
import javax.speech.synthesis.SynthesizerListener;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.SynthesizerProperties;
import javax.speech.synthesis.SynthesizerQueueItem;
import javax.speech.synthesis.Voice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class CGSynthesizer
extends CGEngine
implements Synthesizer {
    private static boolean long = false;
    private long ak = 1L;
    private long ac = 3L;
    private long ax = 2L;
    private static int av;
    private static boolean am;
    private static Thread aw;
    private static boolean ao;
    private static boolean aq;
    private static boolean az;
    private static int ag;
    private Vector au = new Vector();
    private Thread al;
    private int ai = -1;
    private SynthesizerQueueItem aj;
    private static int af;
    private Vector at;
    private int an;
    private static EngineList ay;
    private static Hashtable ad;
    private SynthesizerModeDesc b;
    private String aA = "NONE";
    private boolean ar = false;
    private static CGSynthesizer ah;
    private Vector as;
    private String ap;
    private AudioFormat ae;

    static {
        am = true;
        ao = false;
        aq = false;
        az = false;
        ag = 0;
        af = 0;
        ad = new Hashtable();
        ah = null;
    }

    public static native long getRegDate();

    public static native String getVersionNumber();

    public static native int handleLicense(byte[] var0, int var1, byte[] var2, int var3);

    private native long msSpeak4(int var1, String var2, boolean var3, boolean var4, boolean var5, int var6);

    private native int create4();

    private native int nallocate4(int var1, long var2);

    private native void ndeallocate4(int var1);

    private native void npause4(int var1);

    private native void nresume4(int var1);

    private native void listen4(int var1);

    private native void quit4(int var1);

    private native void getVoices4(int var1);

    private native int setVoiceByID4(int var1, long var2);

    private native int setRate4(int var1, int var2);

    private native int setPitch4(int var1, int var2);

    private native void setVolume4(int var1, int var2);

    private native void setPriority4(int var1, int var2);

    private native int getRate4(int var1);

    private native int getPitch4(int var1);

    private native int getVolume4(int var1);

    private native long setOutputFile4(int var1, String var2, int var3, int var4);

    private native long closeOutputFile4(int var1);

    private native long setOutputStream4(int var1, int var2);

    private native long readFromStream4(int var1, byte[] var2, int var3);

    private native long getAudioFormat4(int var1);

    private native long setAudioFormat4(int var1, int var2, int var3, int var4);

    private native int audioDeviceValid4(int var1);

    private native int displayUI4(int var1, int var2);

    private native int uiAvailable4(int var1, int var2);

    private native int addWordToLexicon4(int var1, String var2, String var3, int var4);

    private native int addIPAWordToLexicon4(int var1, String var2, String var3, int var4);

    private native int removeWordFromLexicon4(int var1, String var2, int var3);

    private native int getWordFromLexicon4(int var1, String var2, int var3);

    public native int getSynthesizers4(int var1);

    private native long msSpeak5(int var1, String var2, boolean var3, boolean var4, boolean var5, int var6);

    private native int create5();

    private native int nallocate5(int var1, long var2);

    private native void ndeallocate5(int var1);

    private native void npause5(int var1);

    private native void nresume5(int var1);

    private native void listen5(int var1);

    private native void quit5(int var1);

    private native void getVoices5(int var1);

    private native void setVoiceByID5(int var1, long var2);

    private native void setRate5(int var1, int var2);

    private native void setVolume5(int var1, int var2);

    private native int getRate5(int var1);

    private native int getVolume5(int var1);

    private native long setOutputFile5(int var1, String var2, int var3, int var4);

    private native long closeOutputFile5(int var1);

    private native long setOutputStream5(int var1, int var2);

    private native long readFromStream5(int var1, byte[] var2, int var3);

    private native long getAudioFormat5(int var1);

    private native long setAudioFormat5(int var1, int var2, int var3, int var4);

    private native int audioDeviceValid5(int var1);

    private native int displayUI5(int var1, int var2);

    private native int uiAvailable5(int var1, int var2);

    private native int addWordToLexicon5(int var1, String var2, String var3, int var4);

    private native int getWordFromLexicon5(int var1, String var2, int var3);

    private native int removeWordFromLexicon5(int var1, String var2, int var3);

    public native int getSynthesizers5();

    private static native int enterMainEventLoop();

    private static native int quitMainEventLoop();

    public CGSynthesizer(EngineModeDesc engineModeDesc) {
        this.byte();
        this.ae = null;
        if (long) {
            System.out.println("Making new synth, desc=" + engineModeDesc);
        }
        this.case = !CGEngine.SUPPORT_SAPI4 ? 5 : 4;
        this.for = new CGSynthesizerProperties(this);
        this.int = 65537L;
        if (engineModeDesc == null) {
            engineModeDesc = new SynthesizerModeDesc();
        }
        this.b = (SynthesizerModeDesc)engineModeDesc;
        if (engineModeDesc instanceof CGSynthesizerModeDesc) {
            CGSynthesizerModeDesc cGSynthesizerModeDesc = (CGSynthesizerModeDesc)engineModeDesc;
            this.case = cGSynthesizerModeDesc.getSapiVersion();
        }
        if (this.new()) {
            CGSynthesizer.c();
        }
        this.ai = this.d();
        if (this.ai + 1 > af) {
            af = this.ai + 1;
        }
        if (long) {
            System.out.println("Made new SAPI" + this.case + " synth");
        }
    }

    public void finalize() {
        try {
            if (this.al != null) {
                this.al.interrupt();
            }
            this.al = null;
            this.byte(this.ai);
            if (this.equals(ah)) {
                CGSynthesizer.b();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("DLL already unloaded when deallocate method called");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void allocated() {
        ++ag;
        super.allocated();
    }

    protected void deallocated() {
        if (--ag == 0) {
            CGSynthesizer.b();
        }
        super.deallocated();
    }

    public static void shutdown() {
        CGSynthesizer.b();
    }

    private static synchronized void b() {
        if (long) {
            System.out.println("quitSapi4MainLoop entered");
        }
        if (ah == null || !ao) {
            return;
        }
        aq = true;
        CGSynthesizer.quitMainEventLoop();
        while (ao) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (long) {
            System.out.println("quitSapi4MainLoop finished");
        }
        aq = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void c() {
        if (long) {
            System.out.println("startSapi4MainLoop " + ao);
        }
        if (ao) {
            return;
        }
        ao = true;
        while (aq) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final Object object = new Object();
        az = false;
        aw = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                az = true;
                Object object2 = object;
                synchronized (object2) {
                    if (long) {
                        System.out.println("notify syncObj");
                    }
                    object.notifyAll();
                }
                int n = CGSynthesizer.enterMainEventLoop();
                ao = false;
                if (n != 0) {
                    am = false;
                }
                if (long) {
                    System.out.println("MAIN EVENT LOOP EXITED");
                }
            }
        };
        aw.start();
        if (!az) {
            Object object2 = object;
            synchronized (object2) {
                try {
                    if (long) {
                        System.out.println("waiting");
                    }
                    if (!az) {
                        object.wait(4000L);
                    }
                    if (long) {
                        System.out.println("wait over");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private long a(int n, String string, boolean bl, boolean bl2, boolean bl3, int n2) {
        if (this.new()) {
            return this.msSpeak4(n, string, bl, bl2, bl3, n2);
        }
        return this.msSpeak5(n, string, bl, bl2, bl3, n2);
    }

    private int d() {
        if (this.new()) {
            return this.create4();
        }
        return this.create5();
    }

    private int for(long l) {
        if (this.new()) {
            return this.nallocate4(this.ai, l);
        }
        return this.nallocate5(this.ai, l);
    }

    private void try(int n) {
        if (this.new()) {
            this.ndeallocate4(n);
        } else {
            this.ndeallocate5(n);
        }
    }

    private void int(int n) {
        if (this.new()) {
            this.npause4(n);
        } else {
            this.npause5(n);
        }
    }

    private void new(int n) {
        if (this.new()) {
            this.nresume4(n);
        } else {
            this.nresume5(n);
        }
    }

    private void char(int n) {
        if (this.new()) {
            this.listen4(n);
        } else {
            this.listen5(n);
        }
    }

    public boolean isAudioDeviceValid() {
        if (this.new()) {
            return this.audioDeviceValid4(this.ai) == 1;
        }
        return this.audioDeviceValid5(this.ai) == 1;
    }

    private void byte(int n) {
        try {
            if (this.new()) {
                this.quit4(n);
            } else {
                this.quit5(n);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("DLL already unloaded when deallocate method called");
        }
    }

    private void else(int n) {
        if (this.new()) {
            this.getVoices4(n);
        } else {
            this.getVoices5(n);
        }
    }

    private void a(int n, long l) {
        if (this.new()) {
            this.setVoiceByID4(n, l);
        } else {
            this.setVoiceByID5(n, l);
        }
    }

    public boolean setRate(float f) {
        if (this.new()) {
            int n = (int)f;
            return this.setRate4(this.ai, n) == 0;
        }
        int n = (int)((f - 160.0f) / 15.0f);
        if (n < -10) {
            n = -10;
        }
        if (n > 10) {
            n = 10;
        }
        this.setRate5(this.ai, n);
        return true;
    }

    public float getRate() {
        if (this.new()) {
            return this.getRate4(this.ai);
        }
        int n = this.getRate5(this.ai);
        n = 15 * n + 160;
        return n;
    }

    protected void setPriority(int n) {
        if (this.new()) {
            this.setPriority4(this.ai, n);
        }
    }

    public boolean setPitch(float f) {
        if (this.new()) {
            return this.setPitch4(this.ai, (int)f) == 0;
        }
        return false;
    }

    public float getPitch() {
        if (this.new()) {
            return this.getPitch4(this.ai);
        }
        return -1.0f;
    }

    public void setVolume(float f) {
        int n = (int)(100.0f * f);
        if (this.new()) {
            this.setVolume4(this.ai, n);
        } else {
            this.setVolume5(this.ai, n);
        }
    }

    public float getVolume() {
        int n = this.new() ? this.getVolume4(this.ai) : this.getVolume5(this.ai);
        return (float)n * 0.01f;
    }

    private long a(int n, String string, int n2, int n3) {
        if (this.new()) {
            return this.setOutputFile4(n, string, n2, n3);
        }
        return this.setOutputFile5(n, string, n2, n3);
    }

    private long case(int n) {
        if (this.new()) {
            return this.closeOutputFile4(n);
        }
        return this.closeOutputFile5(n);
    }

    private long if(int n, int n2) {
        if (this.new()) {
            return this.setOutputStream4(n, n2);
        }
        return this.setOutputStream5(n, n2);
    }

    private long a(int n, byte[] byArray, int n2) {
        if (this.new()) {
            long l = this.readFromStream4(n, byArray, n2);
            return l;
        }
        return this.readFromStream5(n, byArray, n2);
    }

    private int do(int n, int n2) {
        if (this.new()) {
            return this.displayUI4(n, n2);
        }
        return this.displayUI5(n, n2);
    }

    private int a(int n, int n2) {
        if (this.new()) {
            return this.uiAvailable4(n, n2);
        }
        return this.uiAvailable5(n, n2);
    }

    public synchronized Word[] getWords(String string) {
        if (!this.testEngineState(4L)) {
            return null;
        }
        this.as = new Vector();
        this.ap = string;
        if (string == null) {
            string = "";
        }
        if (this.new()) {
            this.getWordFromLexicon4(this.ai, string, 0);
        } else {
            this.getWordFromLexicon5(this.ai, string, 0);
        }
        Object[] objectArray = new Word[this.as.size()];
        this.as.copyInto(objectArray);
        return objectArray;
    }

    protected void addWordPron(String string, String string2, long l, long l2) {
        if (long) {
            System.out.println("Got word spelling, pron, pos= " + string + ", " + string2 + ", " + l + " cnt=" + l2);
        }
        this.as.addElement(new Word(string, string, new String[]{string2}, l));
    }

    private int a(int n, String string, String string2, int n2) {
        if (this.new()) {
            int n3 = this.addIPAWordToLexicon4(n, string, string2, n2);
            if (n3 == 0) {
                return 0;
            }
            return this.addWordToLexicon4(n, string, string2, n2);
        }
        return this.addWordToLexicon5(n, string, string2, n2);
    }

    private int a(int n, String string, int n2) {
        if (this.new()) {
            return this.removeWordFromLexicon4(n, string, n2);
        }
        return this.removeWordFromLexicon5(n, string, n2);
    }

    public int getID() {
        return this.ai;
    }

    public static int getSynthesizers() {
        if (ay != null) {
            return 0;
        }
        if (long) {
            System.out.println("getSynthesizers, engineList = " + ay);
        }
        ay = new EngineList();
        if (ah == null) {
            ah = new CGSynthesizer(null);
        }
        if (CGEngine.SUPPORT_SAPI4 && am) {
            CGSynthesizer.c();
            if (CGEngine.SUPPORT_SAPI4) {
                av = 4;
                ah.getSynthesizers4(ah.getID());
            }
        }
        av = 5;
        ah.getSynthesizers5();
        if (long) {
            System.out.println("num engines = " + ay.size());
        }
        return 0;
    }

    public void setOutputToStream(boolean bl) throws AudioException, EngineStateError, IOException {
        this.if();
        if (!bl) {
            if (this.if(this.ai, -1) == 0L) {
                return;
            }
            throw new IOException("Unable to set synthesizer output to default stream");
        }
        long l = this.if(this.ai, 1);
        if (l != 0L) {
            throw new IOException("Unable to set synthesizer output to stream ErrID=" + l);
        }
    }

    protected void synAudioFormat(long l, long l2, long l3) {
        try {
            this.ae = new AudioFormat((int)l2, (int)l3, (int)l, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public AudioFormat getAudioFormat() {
        if (this.a()) {
            if (this.ae != null) {
                return this.ae;
            }
            this.getAudioFormat5(this.ai);
        } else {
            this.getAudioFormat4(this.ai);
        }
        return this.ae;
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        if (this.a()) {
            this.setAudioFormat5(this.ai, (int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels());
        } else {
            this.setAudioFormat4(this.ai, (int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels());
        }
        this.ae = audioFormat;
    }

    public boolean canSetAudioFormat() {
        return !this.new();
    }

    public long readFromStream(byte[] byArray, int n) {
        return this.a(this.ai, byArray, n);
    }

    public int addWordToLexicon(String string, String string2, int n) {
        return this.a(this.ai, string, string2, n);
    }

    public int removeWordFromLexicon(String string, int n) {
        return this.a(this.ai, string, n);
    }

    public int displayUI(int n) {
        return this.do(this.ai, n);
    }

    public boolean uiAvailable(int n) {
        return this.a(this.ai, n) == 1;
    }

    public String getToken(String string) {
        XMLTag xMLTag = new XMLTag();
        xMLTag.if(string);
        return String.valueOf(xMLTag.if()) + new RuleToken(string).getText();
    }

    public void closeOutput() throws EngineStateError, IOException {
        this.if();
        if (this.case(this.ai) == 0L) {
            return;
        }
        throw new IOException("Unable to close synthesizer output for file " + this.aA);
    }

    public void setOutputFile(String string, int n, int n2) throws AudioException, EngineStateError, IOException {
        this.if();
        if (string == null) {
            string = "NONE";
            n2 = -1;
            this.aA = string;
            if (this.a(this.ai, "NONE", n, -1) == 0L) {
                return;
            }
            throw new IOException("Unable to send synthesizer output to file " + string);
        }
        if (!(!string.toLowerCase().endsWith(".wav") && !string.toLowerCase().endsWith(".wave") || n2 != 8 && n2 != 16 || n != 8 && n != 11 && n != 22 && n != 16 && n != 44)) {
            this.aA = string;
            if (this.a(this.ai, string, n, n2) == 0L) {
                return;
            }
            throw new IOException("Unable to send synthesizer output to file " + string);
        }
        throw new AudioException("The file name must end in .wav or .wave, bits must equal 8 or 16 and frequency must equal 8, 11, 16, 22 or 44");
    }

    public Voice setVoice(Voice voice) {
        if (long) {
            System.out.println("setVoice " + voice);
        }
        if (this.new()) {
            try {
                this.waitEngineState(65536L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (voice == null) {
            return null;
        }
        CGVoice cGVoice = null;
        Voice[] voiceArray = this.b.getVoices();
        int n = 0;
        while (n < voiceArray.length) {
            if (voiceArray[n].match(voice)) {
                cGVoice = (CGVoice)voiceArray[n];
            }
            ++n;
        }
        if (cGVoice == null) {
            cGVoice = (CGVoice)voiceArray[0];
            System.err.println("Unable to find voice " + voice + " \n... using " + cGVoice);
        }
        if (cGVoice.getSapiVersion() != this.case) {
            try {
                this.waitEngineState(65536L);
                if (long) {
                    System.out.println("Switching from SAPI" + this.case + " to SAPI" + cGVoice.getSapiVersion());
                }
                this.deallocate();
                this.waitEngineState(1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.al.interrupt();
            this.al = null;
            this.case = cGVoice.getSapiVersion();
            try {
                this.allocate();
                this.waitEngineState(4L);
                this.resume();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.a(this.ai, cGVoice.getId());
        return cGVoice;
    }

    public static EngineList getEngineList() {
        if (ay != null) {
            return (EngineList)ay.clone();
        }
        CGSynthesizer.getSynthesizers();
        return (EngineList)ay.clone();
    }

    public Synthesizer createEngine(CGSynthesizerModeDesc cGSynthesizerModeDesc) {
        CGSynthesizer cGSynthesizer;
        if (long) {
            System.out.println("createEngine, desc=" + cGSynthesizerModeDesc);
        }
        if (cGSynthesizerModeDesc.getRunning() == Boolean.TRUE && ad.containsKey(cGSynthesizerModeDesc)) {
            cGSynthesizer = (CGSynthesizer)ad.get(cGSynthesizerModeDesc);
        } else {
            cGSynthesizer = new CGSynthesizer(cGSynthesizerModeDesc);
            if (cGSynthesizerModeDesc.getRunning() == Boolean.TRUE) {
                ad.put(cGSynthesizerModeDesc, cGSynthesizer);
            }
        }
        return cGSynthesizer;
    }

    protected synchronized void addSynthVoice(long l, String string, String string2, String string3, String string4, String string5) {
        try {
            Locale locale = null;
            locale = LangToLocale.getLocaleFromId(string5);
            if (long) {
                System.out.println("addSynthVoice " + l + ", " + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ", " + locale);
            }
            if (string4 == null) {
                string4 = "Unknown";
            }
            if (string2 == null) {
                string2 = "Unknown";
            }
            if (string == null) {
                string = "Unknown";
            }
            if (string3 == null) {
                string3 = "Unknown";
            }
            String string6 = String.valueOf(string4) + " SAPI" + av;
            CGSynthesizerModeDesc cGSynthesizerModeDesc = new CGSynthesizerModeDesc(this, string4, string6, locale, null, null, av);
            ay.orderByMatch(cGSynthesizerModeDesc);
            if (ay.size() > 0 && ((CGSynthesizerModeDesc)ay.elementAt(0)).match(cGSynthesizerModeDesc)) {
                cGSynthesizerModeDesc = (CGSynthesizerModeDesc)ay.elementAt(0);
            } else {
                ay.addElement(cGSynthesizerModeDesc);
            }
            Boolean bl = Boolean.FALSE;
            if (ad.containsKey(cGSynthesizerModeDesc)) {
                bl = Boolean.TRUE;
            }
            CGVoice cGVoice = new CGVoice(l, av);
            cGVoice.setName(String.valueOf(string2) + ", SAPI" + av + ", " + string4);
            cGVoice.setStyle(string2);
            if (string3.equals("Male")) {
                cGVoice.setGender(2);
            } else if (string3.equals("Female")) {
                cGVoice.setGender(1);
            } else {
                cGVoice.setGender(1);
            }
            if (string.equals("Senior")) {
                cGVoice.setAge(16);
            } else if (string.equals("Adult")) {
                cGVoice.setAge(8);
            } else if (string.equals("Teen")) {
                cGVoice.setAge(2);
            } else if (string.equals("Child")) {
                cGVoice.setAge(4);
            } else {
                cGVoice.setAge(32);
            }
            cGSynthesizerModeDesc.addVoice(cGVoice);
            cGSynthesizerModeDesc.setRunning(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected void addVoice(String string, String string2, String string3, String string4) {
        Voice voice = new Voice();
        voice.setName(string2);
        voice.setStyle(string4);
        if (string3.equals("Male")) {
            voice.setGender(2);
        } else {
            voice.setGender(1);
        }
        if (string.equals("Adult")) {
            voice.setAge(8);
        } else {
            voice.setAge(32);
        }
        this.b.addVoice(voice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamEnded(long l) {
        block11: {
            try {
                if (long) {
                    System.out.println("stream ended , ignoreNext=" + this.an + " currentItem=" + this.aj);
                }
                if (this.aj == null) {
                    return;
                }
                if (this.a() && !this.ar) {
                    return;
                }
                this.ar = false;
                Object object = this.aj.getSource();
                if (object == null) {
                    return;
                }
                if (this.an == 0) {
                    Vector vector = this.au;
                    synchronized (vector) {
                        if (this.au.size() > 0) {
                            this.au.removeElementAt(0);
                            this.do(false);
                        }
                        break block11;
                    }
                }
                --this.an;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void streamStarted(long l) {
        if (this.aj == null) {
            return;
        }
        if (this.a() && this.ar) {
            return;
        }
        this.ar = true;
    }

    protected void phonemeReached(long l) {
        if (this.aj == null) {
            return;
        }
        Object object = this.aj.getSource();
        if (object == null) {
            return;
        }
        if (long) {
            System.out.println("phonemeReached " + l);
        }
        CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 2002, -1, (int)l);
        this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
    }

    protected void visemeReached(long l) {
        if (this.aj == null) {
            return;
        }
        Object object = this.aj.getSource();
        if (object == null) {
            return;
        }
        if (long) {
            System.out.println("viseme " + l);
        }
        CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 2001, (int)l, -1);
        this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
    }

    protected void mouthShape(long l, long l2, long l3, long l4) {
        if (this.aj == null) {
            return;
        }
        try {
            Object object = this.aj.getSource();
            if (object == null) {
                return;
            }
            int n = (int)(l2 & 0xFFL);
            int n2 = (int)((l2 >>= 8) & 0xFFL);
            int n3 = (int)((l2 >>= 8) & 0xFFL);
            if (n3 == 0) {
                n3 = 128;
            }
            int n4 = (int)((l2 >>= 8) & 0xFFL);
            int n5 = (int)(l3 & 0xFFL);
            int n6 = (int)((l3 >>= 8) & 0xFFL);
            int n7 = (int)((l3 >>= 8) & 0xFFL);
            int n8 = (int)((l3 >>= 8) & 0xFFL);
            if (long) {
                System.out.println("sentType =" + l + " mouthHeight " + n + " mouthWidth " + n2 + " mouthUpturn " + n3 + " jawOpen " + n4 + " phoneme " + l4);
            }
            CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 2000, (int)l, n, n2, n3, n4, n5, n6, n7, n8, (int)l4);
            this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
            cGSpeakableEvent = new CGSpeakableEvent(object, 2002, (int)l, n, n2, n3, n4, n5, n6, n7, n8, (int)l4);
            this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String int(String string) {
        int n = string.indexOf("\\");
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() > 0 && n >= 0) {
            stringBuffer.append(string.substring(0, n));
            n = string.indexOf("\\", n + 1);
            string = string.substring(n + 1);
            n = string.indexOf("\\");
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    protected void wordReached(long l, long l2, long l3) {
        try {
            boolean bl;
            if (this.aj == null) {
                return;
            }
            Object object = this.aj.getSource();
            if (object == null) {
                return;
            }
            String string = this.aj.getText();
            String string2 = this.b.getModeName().toLowerCase();
            boolean bl2 = bl = string2.indexOf("telia") >= 0 || string2.indexOf("infovox") >= 0;
            if (CGEngineProperties.useFixForInfovox330() && bl) {
                if ((l2 = 2L * l2 - 1L) < 0L) {
                    l2 = 0L;
                }
                if (l2 >= (long)string.length()) {
                    l2 = string.length() - 1;
                }
                if (string.substring((int)l2, (int)l2 + 1).equals(" ")) {
                    ++l2;
                }
            }
            if (l3 == -1L) {
                l3 = string.indexOf(" ", (int)l2);
                if (l3 == -1L) {
                    l3 = string.length();
                }
                l3 -= l2;
            }
            if (l2 + l3 > (long)string.length() || l2 > (long)string.length()) {
                return;
            }
            CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 607, string, (int)l2, (int)(l2 + l3));
            this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void markerReached(long l, String string) {
        if (this.aj == null) {
            return;
        }
        Object object = this.aj.getSource();
        if (object == null) {
            return;
        }
        CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 608, string, 622);
        this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
    }

    protected void markerReached(long l, long l2, long l3) {
        if (l2 == this.ax) {
            this.an = 1;
            this.streamEnded(0L);
            return;
        }
        String string = XMLTag.if((int)l2);
        if (this.aj == null) {
            return;
        }
        Object object = this.aj.getSource();
        if (object == null) {
            return;
        }
        CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 608, string, 622);
        this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
    }

    private void if(final CGSpeakableEvent cGSpeakableEvent, final SpeakableListener speakableListener) {
        CGEngine.a(new Runnable(){

            public void run() {
                CGSynthesizer.this.a(cGSpeakableEvent, speakableListener);
            }
        });
    }

    private void a(CGSpeakableEvent cGSpeakableEvent, SpeakableListener speakableListener) {
        try {
            if (this.at != null || speakableListener != null) {
                if (this.at != null) {
                    int n = 0;
                    while (n < this.at.size()) {
                        SpeakableListener speakableListener2 = (SpeakableListener)this.at.elementAt(n);
                        this.a(speakableListener2, cGSpeakableEvent);
                        ++n;
                    }
                }
                if (speakableListener != null) {
                    this.a(speakableListener, cGSpeakableEvent);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void a(SpeakableListener speakableListener, CGSpeakableEvent cGSpeakableEvent) {
        if (speakableListener == null) {
            return;
        }
        switch (cGSpeakableEvent.getId()) {
            case 2001: {
                if (!(speakableListener instanceof CGSpeakableListener)) break;
                ((CGSpeakableListener)speakableListener).viseme(cGSpeakableEvent);
                break;
            }
            case 2002: {
                if (!(speakableListener instanceof CGSpeakableListener)) break;
                ((CGSpeakableListener)speakableListener).phoneme(cGSpeakableEvent);
                break;
            }
            case 2000: {
                if (!(speakableListener instanceof CGSpeakableListener)) break;
                ((CGSpeakableListener)speakableListener).mouthShape(cGSpeakableEvent);
                break;
            }
            case 607: {
                speakableListener.wordStarted(cGSpeakableEvent);
                break;
            }
            case 608: {
                speakableListener.markerReached(cGSpeakableEvent);
                break;
            }
            case 602: {
                speakableListener.speakableStarted(cGSpeakableEvent);
                break;
            }
            case 603: {
                speakableListener.speakableEnded(cGSpeakableEvent);
            }
        }
    }

    public boolean legalState(long l) {
        if ((l & 1L & 0x20000L) != 0L || (l & 0x10000L & 0x20000L) != 0L) {
            return false;
        }
        return super.legalState(l);
    }

    protected void notifyEngineListener(EngineListener engineListener, int n) {
        if (engineListener == null) {
            return;
        }
        super.notifyEngineListener(engineListener, n);
        if (!(engineListener instanceof SynthesizerListener)) {
            return;
        }
        switch (n) {
            case 700: {
                ((SynthesizerListener)engineListener).queueEmptied(new SynthesizerEvent(this, n, false, 0L, 0L));
                break;
            }
            case 701: {
                ((SynthesizerListener)engineListener).queueUpdated(new SynthesizerEvent(this, n, false, 0L, 0L));
            }
        }
    }

    public void pause() throws EngineStateError {
        this.int(this.ai);
        super.pause();
    }

    public void resume() throws AudioException, EngineStateError {
        this.new(this.ai);
        super.resume();
    }

    protected void listenCallback(long l) {
        if (l == 1L) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (long) {
                        System.out.println("listenCallback " + Thread.currentThread());
                    }
                    Voice[] voiceArray = CGSynthesizer.this.b.getVoices();
                    CGVoice cGVoice = null;
                    if (voiceArray != null) {
                        int n = 0;
                        while (n < voiceArray.length && cGVoice == null) {
                            if (((CGVoice)voiceArray[n]).getSapiVersion() == CGSynthesizer.this.case) {
                                cGVoice = (CGVoice)voiceArray[n];
                            }
                            ++n;
                        }
                    }
                    try {
                        if (cGVoice != null) {
                            ((CGSynthesizerProperties)CGSynthesizer.this.for).setVoice(cGVoice);
                        }
                    }
                    catch (Exception exception) {
                        CGSynthesizer.this.else = (RuntimeException)exception;
                    }
                    CGSynthesizer.this.allocated();
                }
            };
            runnable.run();
        } else {
            System.out.println("NOT Listening");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startListening(long l) {
        if (long) {
            System.out.println("startListening " + this);
        }
        if (this.al == null) {
            this.al = new Thread(){

                public void run() {
                    if (long) {
                        System.out.println("startListening " + Thread.currentThread());
                    }
                    if (CGSynthesizer.this.a()) {
                        CGSynthesizer.this.char(CGSynthesizer.this.ai);
                        CGSynthesizer.this.deallocated();
                    } else {
                        CGSynthesizer.this.listenCallback(1L);
                    }
                }
            };
            this.al.start();
        }
        try {
            this.waitEngineState(4L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.a()) {
            Vector vector = this.au;
            synchronized (vector) {
                this.au.addElement(new SynthesizerQueueItem(" ", " ", true, null));
            }
            this.do(true);
            try {
                this.waitEngineState(65536L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void allocate() throws EngineException, EngineStateError {
        super.allocate();
        if (this.testEngineState(4L)) {
            return;
        }
        if (this.new()) {
            CGSynthesizer.c();
        }
        this.int = 65538L;
        this.for(-1L);
        this.an = 0;
        this.startListening(0L);
    }

    public void deallocate() throws EngineException, EngineStateError {
        try {
            try {
                super.deallocate();
                if (this.testEngineState(131072L)) {
                    throw new EngineStateError("Queue is not empty");
                }
            }
            catch (EngineException engineException) {
                throw engineException;
            }
            catch (EngineStateError engineStateError) {
                throw engineStateError;
            }
        }
        catch (Throwable throwable) {
            if (this.new()) {
                this.byte(this.ai);
                this.deallocated();
            } else {
                new Thread(){

                    public void run() {
                        CGSynthesizer.this.byte(CGSynthesizer.this.ai);
                    }
                }.start();
            }
            throw throwable;
        }
        if (this.new()) {
            this.byte(this.ai);
            this.deallocated();
        } else {
            new /* invalid duplicate definition of identical inner class */.start();
        }
    }

    public void addSpeakableListener(SpeakableListener speakableListener) {
        if (this.at == null) {
            this.at = new Vector();
        }
        this.at.addElement(speakableListener);
    }

    public void removeSpeakableListener(SpeakableListener speakableListener) {
        if (this.at == null) {
            return;
        }
        this.at.removeElement(speakableListener);
    }

    protected void printFromNative(long l, String string) {
        System.out.println("From Native code " + l + " " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do(boolean bl) {
        long l;
        SynthesizerQueueItem synthesizerQueueItem;
        Vector vector = this.au;
        synchronized (vector) {
            if (this.au.size() == 0) {
                Object object;
                if (bl) {
                    String string = " ";
                    if (this.new()) {
                        string = String.valueOf(string) + "\\Mrk=" + this.ak + "\\";
                    }
                    this.a(this.ai, string, true, true, false, 1);
                }
                this.int &= 0xFFFFFFFFFFFDFFFFL;
                this.int |= 0x10000L;
                if (this.aj != null && (object = this.aj.getSource()) != null) {
                    CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 603);
                    this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
                }
                this.a(700);
                this.aj = null;
                return;
            }
            this.int &= 0xFFFFFFFFFFFEFFFFL;
            this.int |= 0x20000L;
            synthesizerQueueItem = (SynthesizerQueueItem)this.au.elementAt(0);
        }
        String string = synthesizerQueueItem.getText();
        if (this.new()) {
            string = String.valueOf(string) + " \\Mrk=" + this.ak + "\\";
        }
        boolean bl2 = synthesizerQueueItem.isPlainText();
        bl2 = false;
        if (long) {
            System.out.println("speakNextItem " + string + ":");
        }
        this.aj = synthesizerQueueItem;
        Object object = this.aj.getSource();
        if (object != null) {
            CGSpeakableEvent cGSpeakableEvent = new CGSpeakableEvent(object, 602);
            this.if(cGSpeakableEvent, this.aj.getSpeakableListener());
        }
        if ((l = this.a(this.ai, string, !bl2, bl, false, string.length())) == 0L) {
            this.aj = null;
            this.streamEnded(0L);
        }
        this.a(701);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SynthesizerQueueItem synthesizerQueueItem) {
        this.int &= 0xFFFFFFFFFFFEFFFFL;
        this.int |= 0x20000L;
        Vector vector = this.au;
        synchronized (vector) {
            this.au.addElement(synthesizerQueueItem);
            if (this.au.size() == 1) {
                this.do(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() throws EngineStateError {
        this.if();
        if (long) {
            System.out.println("cancelAll");
        }
        SynthesizerQueueItem synthesizerQueueItem = this.new() ? new SynthesizerQueueItem(" \\Mrk=" + this.ax + "\\ ", " \\Mrk=" + this.ax + "\\ ", false, null) : new SynthesizerQueueItem(" ", " ", true, null);
        Vector vector = this.au;
        synchronized (vector) {
            if (this.au.size() != 0) {
                this.au.setElementAt(synthesizerQueueItem, 0);
                ++this.an;
            } else {
                return;
            }
            int n = this.au.size();
            int n2 = 1;
            while (n2 < n) {
                this.au.removeElementAt(1);
                ++n2;
            }
        }
        this.do(true);
        try {
            this.waitEngineState(65536L);
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws EngineStateError {
        if (this.testEngineState(65536L) || this.testEngineState(1L)) {
            return;
        }
        this.if();
        if (long) {
            System.out.println("cancel");
        }
        SynthesizerQueueItem synthesizerQueueItem = this.new() ? new SynthesizerQueueItem(" \\Mrk=" + this.ax + "\\ ", " \\Mrk=" + this.ax + "\\ ", false, null) : new SynthesizerQueueItem(" ", " ", true, null);
        Vector vector = this.au;
        synchronized (vector) {
            if (this.au.size() != 0) {
                this.au.setElementAt(synthesizerQueueItem, 0);
                ++this.an;
            } else {
                return;
            }
        }
        this.do(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Object object) throws IllegalArgumentException, EngineStateError {
        this.if();
        if (object instanceof SynthesizerQueueItem) {
            Vector vector = this.au;
            synchronized (vector) {
                int n = this.au.indexOf(object);
                if (n == 0) {
                    this.cancel();
                } else {
                    if (n == -1) {
                        throw new IllegalArgumentException("The SynthesizerQueueItem was not part of the queue");
                    }
                    this.au.removeElementAt(n);
                }
            }
        } else {
            throw new IllegalArgumentException("The implementation of this method needs a SynthesizerQueueItem as an argument");
        }
    }

    public Enumeration enumerateQueue() throws EngineStateError {
        this.if();
        return this.au.elements();
    }

    public EngineProperties getEngineProperties() {
        return this.getSynthesizerProperties();
    }

    public EngineModeDesc getEngineModeDesc() {
        return this.b;
    }

    public SynthesizerProperties getSynthesizerProperties() {
        return (SynthesizerProperties)this.for;
    }

    public String phoneme(String string) throws EngineStateError {
        this.if();
        return null;
    }

    public void speakPlainText(String string, SpeakableListener speakableListener) throws EngineStateError {
        try {
            this.if.startSending();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.if();
        if (string == null) {
            return;
        }
        string = CGEngine.a(string);
        this.a(new SynthesizerQueueItem(string, string, true, speakableListener));
    }

    public void speak(Speakable speakable, SpeakableListener speakableListener) throws JSMLException, EngineStateError {
        try {
            this.if.startSending();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.if();
        String string = speakable.getJSMLText();
        if (string == null) {
            return;
        }
        XMLTag xMLTag = new XMLTag();
        xMLTag.new(string);
        string = xMLTag.do(this.do());
        if (long) {
            System.out.println("Speaking: SAPI" + this.do() + " text=\n" + string);
        }
        this.a(new SynthesizerQueueItem(speakable, string, false, speakableListener));
    }

    public void speak(URL uRL, SpeakableListener speakableListener) throws JSMLException, IOException, MalformedURLException, EngineStateError {
        int n;
        try {
            this.if.startSending();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.if();
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        char[] cArray = new char[1000];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read(cArray, 0, 1000)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        XMLTag xMLTag = new XMLTag();
        xMLTag.new(stringBuffer.toString());
        String string = xMLTag.do(this.do());
        if (long) {
            System.out.println("Speaking: SAPI" + this.do() + " text=\n" + string);
        }
        this.a(new SynthesizerQueueItem(uRL, string, false, speakableListener));
    }

    public void speak(String string, SpeakableListener speakableListener) throws JSMLException, EngineStateError {
        try {
            this.if.startSending();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            return;
        }
        this.if();
        XMLTag xMLTag = new XMLTag();
        xMLTag.new(string);
        string = xMLTag.do(this.do());
        if (long) {
            System.out.println("Speaking: SAPI" + this.do() + " text=\n" + string);
        }
        this.a(new SynthesizerQueueItem(string, string, false, speakableListener));
    }
}

