/*
 * Decompiled with CFR 0.152.
 */
package jess.awt;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public class TextReader
extends Reader
implements Serializable {
    private StringBuffer m_buf = new StringBuffer(256);
    private int m_ptr = 0;
    private boolean m_dontWait = false;
    private boolean m_open = true;

    public TextReader(boolean bl) {
        this.m_dontWait = bl;
    }

    public synchronized int read() throws IOException {
        if (!this.m_open) {
            throw new IOException("Closed");
        }
        while (this.m_ptr >= this.m_buf.length()) {
            if (this.m_dontWait) {
                return -1;
            }
            if (!this.m_open) {
                return -1;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                if (this.m_open) continue;
                return -1;
            }
        }
        char c = this.m_buf.charAt(this.m_ptr++);
        if (this.m_ptr >= this.m_buf.length()) {
            this.clear();
        }
        return c;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                return i > n ? i - n : -1;
            }
            cArray[i] = (char)n3;
        }
        return n2;
    }

    public void close() {
        this.m_open = false;
    }

    public int available() {
        return this.m_buf.length() - this.m_ptr;
    }

    public synchronized void appendText(String string) {
        this.m_buf.append(string);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.m_buf.setLength(0);
        this.m_ptr = 0;
    }
}

