/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Value;
import jess.ValueVector;

public class Variable
extends Value
implements Serializable {
    public Variable(String string, int n) throws JessException {
        super(string, n);
        if (string.indexOf("?") != -1 || string.indexOf("$") != -1) {
            throw new JessException("Variable.Variable", "Variable name cannot contain '?' or '$'", string);
        }
    }

    public Value resolveValue(Context context) throws JessException {
        if (context == null) {
            throw new JessException("Variable.resolveValue", "Null context for", this.variableValue(context));
        }
        return context.getVariable(this.variableValue(context));
    }

    public final Object javaObjectValue(Context context) throws JessException {
        return this.resolveValue(context).javaObjectValue(context);
    }

    public final Fact factValue(Context context) throws JessException {
        return this.resolveValue(context).factValue(context);
    }

    public final ValueVector listValue(Context context) throws JessException {
        return this.resolveValue(context).listValue(context);
    }

    public final int intValue(Context context) throws JessException {
        return this.resolveValue(context).intValue(context);
    }

    public final double floatValue(Context context) throws JessException {
        return this.resolveValue(context).floatValue(context);
    }

    public final double numericValue(Context context) throws JessException {
        return this.resolveValue(context).numericValue(context);
    }

    public final String symbolValue(Context context) throws JessException {
        return this.resolveValue(context).symbolValue(context);
    }

    public final String variableValue(Context context) {
        try {
            return super.stringValue(context);
        }
        catch (JessException jessException) {
            return null;
        }
    }

    public final String stringValue(Context context) throws JessException {
        return this.resolveValue(context).stringValue(context);
    }
}

