/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jess.Accelerator;
import jess.Accumulate;
import jess.BindingValue;
import jess.ConditionalElementX;
import jess.Defglobal;
import jess.Defrule;
import jess.Deftemplate;
import jess.Funcall;
import jess.FuncallValue;
import jess.HasLHS;
import jess.JessException;
import jess.LogicalNode;
import jess.Node;
import jess.Node1;
import jess.Node1LTR;
import jess.Node1MTELN;
import jess.Node1MTEQ;
import jess.Node1MTMF;
import jess.Node1MTNEQ;
import jess.Node1NONE;
import jess.Node1RTL;
import jess.Node1TECT;
import jess.Node1TEQ;
import jess.Node1TEV1;
import jess.Node1TNEQ;
import jess.Node1TNEV1;
import jess.Node2;
import jess.Node2Accumulate;
import jess.NodeJoin;
import jess.NodeNot2;
import jess.NodeNot2Single;
import jess.NodeRoot;
import jess.NodeSink;
import jess.Pattern;
import jess.RU;
import jess.Rete;
import jess.RuleCompilerException;
import jess.Test1;
import jess.Value;
import jess.ValueVector;
import jess.Variable;
import jess.Visitable;

class ReteCompiler
implements Serializable {
    private int m_hashkey = 13;
    private static Accelerator m_accelerator;
    private static boolean m_acceleratorChecked;
    private Node m_root = new NodeRoot();
    private Map m_doneVars = new HashMap();

    public int getHashKey() {
        return this.m_hashkey;
    }

    public void setHashKey(int n) {
        this.m_hashkey = n;
    }

    public final Node getRoot() {
        return this.m_root;
    }

    static synchronized Accelerator getAccelerator() {
        return m_accelerator;
    }

    static synchronized void loadAccelerator(Rete rete) throws JessException {
        if (!m_acceleratorChecked) {
            m_acceleratorChecked = true;
            String string = RU.getProperty("SPEEDUP");
            if (string != null) {
                try {
                    m_accelerator = (Accelerator)rete.findClass(string).newInstance();
                }
                catch (Exception exception) {
                    throw new JessException("ReteCompiler.loadAccelerator", "Can't load Accelerator class " + string, exception.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addRule(HasLHS hasLHS, Rete rete) throws JessException {
        ReteCompiler.loadAccelerator(rete);
        hasLHS.freeze(rete);
        Map map = hasLHS.getBindings();
        ConditionalElementX conditionalElementX = hasLHS.getLHSComponents();
        HashSet hashSet = new HashSet();
        Node[] nodeArray = new Node[this.fullPatternCount(conditionalElementX)];
        int n = this.compileConditionalElements(conditionalElementX, hasLHS, hashSet, map, nodeArray, 0, rete, false);
        nodeArray[n - 1].mergeSuccessor(hasLHS, hasLHS);
        try {
            rete.updateNodes(hashSet);
        }
        finally {
            hasLHS.setOld();
        }
    }

    private int fullPatternCount(ConditionalElementX conditionalElementX) {
        int n = 0;
        for (int i = 0; i < conditionalElementX.getGroupSize(); ++i) {
            ConditionalElementX conditionalElementX2 = conditionalElementX.getConditionalElementX(i);
            if (conditionalElementX2 instanceof Pattern) {
                ++n;
                continue;
            }
            n += this.fullPatternCount(conditionalElementX2);
        }
        return n;
    }

    private int compileConditionalElements(ConditionalElementX conditionalElementX, HasLHS hasLHS, Set set, Map map, Node[] nodeArray, int n, Rete rete, boolean bl) throws JessException {
        int n2 = n;
        for (int i = 0; i < conditionalElementX.getGroupSize(); ++i) {
            Node node;
            Serializable serializable;
            Visitable visitable;
            ConditionalElementX conditionalElementX2 = conditionalElementX.getConditionalElementX(i);
            if (conditionalElementX2 instanceof Pattern) {
                visitable = (Pattern)conditionalElementX2;
                this.buildPatternNetwork(hasLHS, (Pattern)visitable, set, map, nodeArray, n2);
                if (n2 == 0) {
                    serializable = new Node1RTL();
                    if (conditionalElementX2.getLogical()) {
                        nodeArray[0] = nodeArray[0].addSuccessor((Node)serializable, hasLHS);
                        ((Defrule)hasLHS).setLogicalInformation((LogicalNode)((Object)serializable));
                    } else {
                        nodeArray[0] = nodeArray[0].mergeSuccessor((Node)serializable, hasLHS);
                    }
                } else {
                    serializable = this.createJoinNode((Pattern)visitable, bl);
                    nodeArray[n2 - 1] = nodeArray[n2] = (node = this.thirdPass(hasLHS, (Pattern)visitable, nodeArray[n2 - 1], nodeArray[n2], map, (NodeJoin)serializable, rete));
                    if (conditionalElementX2.getLogical()) {
                        ((Defrule)hasLHS).setLogicalInformation((Node2)node);
                    }
                }
                ++n2;
                continue;
            }
            if (conditionalElementX2.getName().equals("not")) {
                boolean bl2 = this.noNotsAboveOrBelow(conditionalElementX, conditionalElementX2);
                serializable = nodeArray[n2 - 1];
                int n3 = n2 - 1;
                int n4 = 1;
                ConditionalElementX conditionalElementX3 = conditionalElementX2.getConditionalElementX(0);
                while (conditionalElementX3.getName().equals("not")) {
                    ++n4;
                    conditionalElementX3 = conditionalElementX3.getConditionalElementX(0);
                }
                int n5 = this.compileConditionalElements(conditionalElementX3, hasLHS, set, map, nodeArray, n2, rete, bl2);
                Node node2 = nodeArray[n5 - 1];
                int n6 = this.hashValueFor(hasLHS);
                if (!bl2) {
                    for (int j = 0; j < n4; ++j) {
                        NodeJoin nodeJoin = (NodeJoin)node2;
                        Node1LTR node1LTR = new Node1LTR();
                        NodeNot2 nodeNot2 = new NodeNot2(n6, n2);
                        nodeJoin.addSuccessor(node1LTR, hasLHS);
                        node1LTR.addSuccessor(nodeNot2, hasLHS);
                        ((Node)serializable).addSuccessor(nodeNot2, hasLHS);
                        nodeArray[n2 - 1] = nodeArray[n2] = nodeNot2;
                        node2 = nodeNot2;
                    }
                }
                n2 = n3 + 1;
                nodeArray[n2 - 1] = nodeArray[n2] = node2;
                if (conditionalElementX2.getLogical()) {
                    ((Defrule)hasLHS).setLogicalInformation((Node2)node2);
                }
                ++n2;
                continue;
            }
            if (conditionalElementX2 instanceof Accumulate) {
                visitable = (Accumulate)conditionalElementX2;
                serializable = (Pattern)((Accumulate)visitable).getConditionalElementX(0);
                this.buildPatternNetwork(hasLHS, (Pattern)serializable, set, map, nodeArray, n2);
                nodeArray[n2 - 1] = nodeArray[n2] = (node = this.thirdPass(hasLHS, (Pattern)serializable, nodeArray[n2 - 1], nodeArray[n2], map, new Node2Accumulate((Accumulate)visitable, this.m_hashkey), rete));
                ++n2;
                continue;
            }
            n2 = this.compileConditionalElements(conditionalElementX2, hasLHS, set, map, nodeArray, n2, rete, false);
        }
        return n2;
    }

    private void buildPatternNetwork(HasLHS hasLHS, Pattern pattern, Set set, Map map, Node[] nodeArray, int n) throws JessException {
        nodeArray[n] = this.firstPass(hasLHS, pattern, set, map);
        nodeArray[n] = this.secondPass(hasLHS, pattern, nodeArray[n]);
    }

    private boolean noNotsAboveOrBelow(ConditionalElementX conditionalElementX, ConditionalElementX conditionalElementX2) {
        return !conditionalElementX.getName().equals("not") && !conditionalElementX2.getConditionalElementX(0).getName().equals("test") && conditionalElementX2.getConditionalElementX(0) instanceof Pattern;
    }

    private int hashValueFor(HasLHS hasLHS) {
        int n = hasLHS.getNodeIndexHash();
        if (n == 0) {
            n = this.m_hashkey;
        }
        return n;
    }

    private Value eval(Map map, Value value) throws JessException {
        if (value.type() != 64) {
            return value;
        }
        Funcall funcall = value.funcallValue(null);
        Funcall funcall2 = (Funcall)funcall.clone();
        for (int i = 0; i < funcall2.size(); ++i) {
            Value value2 = funcall2.get(i);
            if (value2 instanceof Variable) {
                String string = value2.variableValue(null);
                BindingValue bindingValue = (BindingValue)map.get(string);
                if (bindingValue == null) continue;
                funcall2.set(bindingValue, i);
                continue;
            }
            if (value2.type() != 64) continue;
            funcall2.set(this.eval(map, value2), i);
        }
        return new FuncallValue(funcall2);
    }

    private boolean checkForMultiPattern(Value value, Pattern pattern) throws JessException {
        Funcall funcall = value.funcallValue(null);
        for (int i = 1; i < funcall.size(); ++i) {
            Value value2 = ((ValueVector)funcall).get(i);
            if (value2.type() == 4096 && ((BindingValue)value2).getCE() != pattern) {
                return true;
            }
            if (value2.type() != 64 || !this.checkForMultiPattern(value2, pattern)) continue;
            return true;
        }
        return false;
    }

    private Node firstPass(NodeSink nodeSink, Pattern pattern, Set set, Map map) throws JessException {
        int n;
        int n2;
        Deftemplate deftemplate = pattern.getDeftemplate();
        boolean bl = pattern.getName().equals("test");
        Node node = this.m_root.mergeSuccessor(bl ? new Node1NONE() : new Node1TECT(pattern.getName()), nodeSink);
        set.add(node);
        for (n2 = 0; !bl && n2 < pattern.getNSlots(); ++n2) {
            if (deftemplate.getSlotType(n2) != 32768) continue;
            if (pattern.getNMultifieldsInSlot(n2) == 0) {
                n = pattern.getSlotLength(n2);
                if (n == -1) continue;
                node = node.mergeSuccessor(new Node1MTELN(n2, n), nodeSink);
                continue;
            }
            node = node.mergeSuccessor(new Node1MTMF(n2, pattern.getMultifieldFlags(n2)), nodeSink);
        }
        for (n2 = 0; !bl && n2 < pattern.getNSlots(); ++n2) {
            if (pattern.getNTests(n2) == 0) continue;
            for (n = 0; n < pattern.getNTests(n2); ++n) {
                Object object;
                Test1 test1 = pattern.getTest(n2, n);
                Value value = test1.m_slotValue;
                if (value instanceof Variable && !Defglobal.isADefglobalName((String)(object = value.variableValue(null)))) continue;
                object = this.eval(map, value);
                if (value.type() == 64 && this.checkForMultiPattern((Value)object, pattern)) continue;
                node = this.addSimpleTest(node, nodeSink, n2, test1, (Value)object);
            }
        }
        return node;
    }

    private Node secondPass(NodeSink nodeSink, Pattern pattern, Node node) throws JessException {
        if (pattern.getName().equals("test")) {
            return node;
        }
        this.m_doneVars.clear();
        for (int i = 0; i < pattern.getNSlots(); ++i) {
            if (pattern.getNTests(i) == 0) continue;
            for (int j = 0; j < pattern.getNTests(i); ++j) {
                String string;
                Test1 test1 = pattern.getTest(i, j);
                if (!(test1.m_slotValue instanceof Variable) || this.m_doneVars.get(string = test1.m_slotValue.variableValue(null)) != null) continue;
                for (int k = i; k < pattern.getNSlots(); ++k) {
                    if (pattern.getNTests(k) == 0) continue;
                    for (int i2 = 0; i2 < pattern.getNTests(k); ++i2) {
                        Test1 test12 = pattern.getTest(k, i2);
                        if (test12 == test1 || !(test12.m_slotValue instanceof Variable) || !test12.m_slotValue.equals(test1.m_slotValue)) continue;
                        node = this.addMultipleReferenceTest(node, i, test1, k, test12, nodeSink);
                    }
                }
                this.m_doneVars.put(string, string);
            }
        }
        return node;
    }

    private Node thirdPass(HasLHS hasLHS, Pattern pattern, Node node, Node node2, Map map, NodeJoin nodeJoin, Rete rete) throws JessException {
        String string;
        BindingValue bindingValue;
        this.m_doneVars.clear();
        boolean bl = pattern.getName().equals("test");
        if (pattern.getBoundName() != null && (bindingValue = (BindingValue)map.get(string = pattern.getBoundName())).getCE() != pattern) {
            nodeJoin.addTest(0, bindingValue.getFactNumber(), bindingValue.getSlotIndex(), bindingValue.getSubIndex(), -1, -1);
        }
        for (int i = 0; i < pattern.getNSlots(); ++i) {
            if (pattern.getNTests(i) == 0) continue;
            for (int j = 0; j < pattern.getNTests(i); ++j) {
                Object object;
                Test1 test1 = pattern.getTest(i, j);
                if (test1.m_slotValue instanceof Variable) {
                    object = pattern.getTest((int)i, (int)j).m_slotValue.variableValue(null);
                    if (this.m_doneVars.get(object) != null || Defglobal.isADefglobalName((String)object)) continue;
                    BindingValue bindingValue2 = (BindingValue)map.get(object);
                    if (bindingValue2 == null) {
                        throw new RuleCompilerException("ReteCompiler.addRule", "Corrupted VarTable: var " + (String)object + " not in table");
                    }
                    if (bindingValue2.getCE() == pattern) continue;
                    nodeJoin.addTest(test1.m_test, bindingValue2.getFactNumber(), bindingValue2.getSlotIndex(), bindingValue2.getSubIndex(), i, test1.m_subIdx);
                    if (test1.m_test != 0) continue;
                    this.m_doneVars.put(object, object);
                    continue;
                }
                if (test1.m_slotValue.type() != 64) continue;
                if (pattern.getDeftemplate().getBackwardChaining()) {
                    throw new JessException("ReteCompiler.addRule", "Can't use funcalls in backchained patterns", pattern.getName());
                }
                object = this.eval(map, test1.m_slotValue);
                if (!bl && !this.checkForMultiPattern((Value)object, pattern)) continue;
                if (test1.m_test == 0) {
                    nodeJoin.addTest(0, test1.m_subIdx, (Value)object, rete);
                    continue;
                }
                nodeJoin.addTest(1, test1.m_subIdx, (Value)object, rete);
            }
        }
        nodeJoin = this.addJoinNode(nodeJoin, node, node2, hasLHS);
        nodeJoin.complete();
        if (pattern.getDeftemplate().getBackwardChaining() && !pattern.getExplicit() && !pattern.getNegated()) {
            ((Node2)nodeJoin).setBackchainInfo(pattern, hasLHS);
        }
        return nodeJoin;
    }

    private NodeJoin createJoinNode(Pattern pattern, boolean bl) {
        boolean bl2 = pattern.getName().equals("test");
        if (bl2) {
            return new NodeJoin();
        }
        if (bl) {
            return new NodeNot2Single(this.m_hashkey);
        }
        return new Node2(this.m_hashkey);
    }

    private NodeJoin addJoinNode(NodeJoin nodeJoin, Node node, Node node2, NodeSink nodeSink) throws JessException {
        NodeJoin nodeJoin2;
        NodeJoin nodeJoin3 = (NodeJoin)node.resolve(nodeJoin);
        if (nodeJoin3 != nodeJoin && nodeJoin3 == (nodeJoin2 = (NodeJoin)node2.resolve(nodeJoin))) {
            nodeSink.addNode(nodeJoin3);
            return nodeJoin3;
        }
        node.addSuccessor(nodeJoin, nodeSink);
        node2.addSuccessor(nodeJoin, nodeSink);
        return nodeJoin;
    }

    private Node addSimpleTest(Node node, NodeSink nodeSink, int n, Test1 test1, Value value) throws JessException {
        Node1 node1;
        block0 : switch (test1.m_test) {
            case 0: {
                switch (test1.m_subIdx) {
                    case -1: {
                        node1 = new Node1TEQ(n, value);
                        break block0;
                    }
                }
                node1 = new Node1MTEQ(n, test1.m_subIdx, value);
                break;
            }
            default: {
                switch (test1.m_subIdx) {
                    case -1: {
                        node1 = new Node1TNEQ(n, value);
                        break block0;
                    }
                }
                node1 = new Node1MTNEQ(n, test1.m_subIdx, value);
            }
        }
        return node.mergeSuccessor(node1, nodeSink);
    }

    private Node addMultipleReferenceTest(Node node, int n, Test1 test1, int n2, Test1 test12, NodeSink nodeSink) throws JessException {
        if (test1.m_test == 0) {
            if (test12.m_test == 0) {
                return node.mergeSuccessor(new Node1TEV1(n, test1.m_subIdx, n2, test12.m_subIdx), nodeSink);
            }
            return node.mergeSuccessor(new Node1TNEV1(n, test1.m_subIdx, n2, test12.m_subIdx), nodeSink);
        }
        if (test12.m_test == 0) {
            return node.mergeSuccessor(new Node1TNEV1(n, test1.m_subIdx, n2, test12.m_subIdx), nodeSink);
        }
        return node;
    }

    void setRoot(Node node) {
        this.m_root = node;
    }
}

