/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.Iterator;
import jess.Context;
import jess.Defquery;
import jess.Funcall;
import jess.JessException;
import jess.Token;
import jess.Value;

public class QueryResult {
    private Iterator m_iterator;
    private Defquery m_query;
    private Context m_context;
    private Context m_globalContext;

    QueryResult(Iterator iterator, Defquery defquery, Context context) {
        this.m_iterator = iterator;
        this.m_query = defquery;
        this.m_globalContext = context;
    }

    public boolean next() {
        boolean bl = this.m_iterator.hasNext();
        if (bl) {
            Token token = (Token)this.m_iterator.next();
            this.m_context = this.m_globalContext.push();
            this.m_query.ready(token, this.m_context);
        }
        return bl;
    }

    public void close() {
        this.m_iterator = null;
    }

    public String getString(String string) throws JessException {
        this.checkValidCursor();
        Value value = this.m_context.getVariable(string);
        return value.stringValue(this.m_context);
    }

    private void checkValidCursor() throws JessException {
        if (this.m_iterator == null) {
            throw new JessException("QueryResult.get", "QueryResult is closed", "");
        }
        if (this.m_context == null) {
            throw new JessException("QueryResult.get", "The cursor is before the first row; you must call next() before accessing query result", "");
        }
    }

    public String getSymbol(String string) throws JessException {
        this.checkValidCursor();
        return this.m_context.getVariable(string).symbolValue(this.m_context);
    }

    public boolean getBoolean(String string) throws JessException {
        this.checkValidCursor();
        Value value = this.m_context.getVariable(string);
        return !Funcall.FALSE.equals(value);
    }

    public byte getByte(String string) throws JessException {
        this.checkValidCursor();
        return (byte)this.m_context.getVariable(string).intValue(this.m_context);
    }

    public short getShort(String string) throws JessException {
        this.checkValidCursor();
        return (short)this.m_context.getVariable(string).intValue(this.m_context);
    }

    public int getInt(String string) throws JessException {
        this.checkValidCursor();
        return this.m_context.getVariable(string).intValue(this.m_context);
    }

    public long getLong(String string) throws JessException {
        this.checkValidCursor();
        return this.m_context.getVariable(string).longValue(this.m_context);
    }

    public float getFloat(String string) throws JessException {
        this.checkValidCursor();
        return (float)this.m_context.getVariable(string).floatValue(this.m_context);
    }

    public double getDouble(String string) throws JessException {
        this.checkValidCursor();
        return this.m_context.getVariable(string).floatValue(this.m_context);
    }

    public Object getObject(String string) throws JessException {
        this.checkValidCursor();
        return this.m_context.getVariable(string).javaObjectValue(this.m_context);
    }

    public Value get(String string) throws JessException {
        return this.m_context.getVariable(string);
    }
}

