/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.Map;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.LogicalNode;
import jess.MatchInfoSource;
import jess.Node;
import jess.Node1;
import jess.NodeLogicalDependencyHandler;
import jess.Token;

class Node1RTL
extends Node1
implements LogicalNode {
    private NodeLogicalDependencyHandler m_logicalDepends;
    private int m_tokenSize;

    Node1RTL() {
    }

    void callNodeRight(int n, Token token, Context context) throws JessException {
        if (this.m_logicalDepends != null) {
            this.m_logicalDepends.tokenMatched(n, token, context);
        }
        this.passAlong(n, token, context);
    }

    void passAlong(int n, Token token, Context context) throws JessException {
        this.m_tokenSize = token.size();
        Node[] nodeArray = this.m_succ;
        for (int i = 0; i < this.m_nSucc; ++i) {
            Node node = nodeArray[i];
            node.callNodeLeft(n, token, context);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Node1RTL;
    }

    public String toString() {
        return "[Left input adapter]";
    }

    public void dependsOn(Fact fact, Token token) {
        this.ensureHandlerAllocated();
        this.m_logicalDepends.dependsOn(fact, token);
    }

    public int getTokenSize() {
        return this.m_tokenSize;
    }

    public Map getLogicalDependencies() {
        return this.m_logicalDepends.getMap();
    }

    public void setMatchInfoSource(MatchInfoSource matchInfoSource) {
        this.ensureHandlerAllocated();
        this.m_logicalDepends.setMatchInfoSource(matchInfoSource);
    }

    private void ensureHandlerAllocated() {
        if (this.m_logicalDepends == null) {
            this.m_logicalDepends = new NodeLogicalDependencyHandler(this.getTokenSize());
        }
    }

    public int getNodeType() {
        return 6;
    }
}

