/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Node1;
import jess.Rete;
import jess.Token;
import jess.Value;
import jess.ValueVector;

class Node1MTMF
extends Node1 {
    private int m_idx;
    private int m_slotSize;
    private int m_nMultifields;
    private boolean[] m_multiIndexes;

    Node1MTMF(int n, boolean[] blArray) {
        this.m_idx = n;
        this.m_slotSize = blArray.length;
        this.m_multiIndexes = blArray;
        for (int i = 0; i < this.m_slotSize; ++i) {
            if (!this.m_multiIndexes[i]) continue;
            ++this.m_nMultifields;
        }
    }

    void callNodeRight(int n, Token token, Context context) throws JessException {
        if (this.processClearCommand(n, token, context)) {
            return;
        }
        ValueVector valueVector = token.fact(0).get(this.m_idx).listValue(null);
        int n2 = valueVector.size();
        int n3 = n2 - this.m_slotSize + this.m_nMultifields;
        if (n3 < 0) {
            return;
        }
        this.partition(n, token, n3, this.m_nMultifields, context);
    }

    void partition(int n, Token token, int n2, int n3, Context context) throws JessException {
        int[] nArray = new int[n3];
        do {
            if (this.testForSum(nArray, n2, n3)) {
                this.process(n, token, nArray, context);
            }
            this.addOne(nArray, n2, n3);
        } while (nArray[n3 - 1] <= n2);
    }

    void addOne(int[] nArray, int n, int n2) {
        nArray[0] = nArray[0] + 1;
        for (int i = 0; i < n2 - 1; ++i) {
            if (nArray[i] <= n) continue;
            nArray[i] = 0;
            int n3 = i + 1;
            nArray[n3] = nArray[n3] + 1;
        }
    }

    boolean testForSum(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray[i];
        }
        return n3 == n;
    }

    private void process(int n, Token token, int[] nArray, Context context) throws JessException {
        Fact fact = this.createModifiedFact(token.fact(0), token.fact(0).get(this.m_idx).listValue(null), nArray);
        token = Rete.getFactory().newToken(fact, n);
        this.passAlong(n, token, context);
    }

    private Fact createModifiedFact(Fact fact, ValueVector valueVector, int[] nArray) throws JessException {
        Fact fact2 = (Fact)fact.clone();
        fact2.setIcon(fact.getIcon());
        ValueVector valueVector2 = new ValueVector();
        valueVector2.setLength(this.m_slotSize);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_slotSize; ++i) {
            if (!this.m_multiIndexes[i]) {
                valueVector2.set(valueVector.get(n++), i);
                continue;
            }
            ValueVector valueVector3 = new ValueVector();
            int n3 = nArray[n2++];
            valueVector3.setLength(n3);
            for (int j = 0; j < n3; ++j) {
                valueVector3.set(valueVector.get(n++), j);
            }
            valueVector2.set(new Value(valueVector3, 512), i);
        }
        fact2.set(new Value(valueVector2, 512), this.m_idx);
        return fact2;
    }

    void newProcess(int n, Token token, int[] nArray, Context context) throws JessException {
        Context context2 = context.push();
        Fact fact = this.newCreateModifiedFact(token.fact(0), token.fact(0).get(this.m_idx).listValue(null), nArray, context2);
        token = Rete.getFactory().newToken(fact, n);
        this.passAlong(n, token, context2);
    }

    Fact newCreateModifiedFact(Fact fact, ValueVector valueVector, int[] nArray, Context context) throws JessException {
        Fact fact2 = (Fact)fact.clone();
        fact2.setIcon(fact.getIcon());
        ValueVector valueVector2 = new ValueVector();
        valueVector2.setLength(this.m_slotSize);
        int n = fact.getFactId();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.m_slotSize; ++i) {
            Serializable serializable;
            if (!this.m_multiIndexes[i]) {
                serializable = valueVector.get(n2++);
                valueVector2.set((Value)serializable, i);
                context.setVariable(n + "_" + this.m_idx + "_" + i, (Value)serializable);
                continue;
            }
            serializable = new ValueVector();
            int n4 = nArray[n3++];
            ((ValueVector)serializable).setLength(n4);
            for (int j = 0; j < n4; ++j) {
                ((ValueVector)serializable).set(valueVector.get(n2++), j);
            }
            Value value = new Value((ValueVector)serializable, 512);
            valueVector2.set(value, i);
            context.setVariable(n + "_" + this.m_idx + "_" + i, value);
        }
        fact2.set(new Value(valueVector2, 512), this.m_idx);
        return fact2;
    }

    public String toString() {
        return "[Split the multislot at index " + this.m_idx + " into " + this.m_slotSize + " pieces]";
    }

    public boolean equals(Object object) {
        if (object instanceof Node1MTMF) {
            Node1MTMF node1MTMF = (Node1MTMF)object;
            if (this.m_idx != node1MTMF.m_idx || this.m_slotSize != node1MTMF.m_slotSize || this.m_nMultifields != node1MTMF.m_nMultifields) {
                return false;
            }
            for (int i = 0; i < this.m_slotSize; ++i) {
                if (this.m_multiIndexes[i] == node1MTMF.m_multiIndexes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

