/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Modular;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

abstract class ModuleOperator
implements Serializable {
    ModuleOperator() {
    }

    String getModule(ValueVector valueVector, Context context) throws JessException {
        return valueVector.size() == 1 ? context.getEngine().getCurrentModule() : valueVector.get(1).stringValue(context);
    }

    Filter chooseFilter(String string, Rete rete) throws JessException {
        if (string.equals("*")) {
            return new NullFilter();
        }
        rete.verifyModule(string);
        return new NameFilter(string);
    }

    Value displayAll(Iterator iterator, ValueVector valueVector, Context context, String string, Displayer displayer) throws JessException {
        String string2 = this.getModule(valueVector, context);
        Rete rete = context.getEngine();
        Filter filter = this.chooseFilter(string2, rete);
        PrintWriter printWriter = rete.getOutStream();
        int n = 0;
        while (iterator.hasNext()) {
            Modular modular = (Modular)iterator.next();
            if (!filter.accept(modular)) continue;
            displayer.display(modular, printWriter);
            ++n;
        }
        printWriter.print("For a total of ");
        printWriter.print(n);
        printWriter.print(" ");
        printWriter.print(string);
        if (string2.equals("*")) {
            printWriter.println(" in all modules.");
        } else {
            printWriter.println(" in module " + string2 + ".");
        }
        printWriter.flush();
        return Funcall.NIL;
    }

    class NameFilter
    implements Filter {
        private String m_name;

        NameFilter(String string) {
            this.m_name = string;
        }

        public boolean accept(Modular modular) {
            return this.m_name.equals(modular.getModule());
        }
    }

    class NullFilter
    implements Filter {
        NullFilter() {
        }

        public boolean accept(Modular modular) {
            return true;
        }
    }

    static interface Displayer {
        public void display(Modular var1, PrintWriter var2);
    }

    static interface Filter {
        public boolean accept(Modular var1);
    }
}

