/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jess.Context;
import jess.Fact;
import jess.Multimap;
import jess.Token;

class LogicalSupport
implements Serializable {
    private Multimap m_supportForFacts;
    private List m_toRetract;

    LogicalSupport(List list) {
        this.m_toRetract = list;
    }

    private boolean logicalSupportInUse() {
        return this.m_supportForFacts != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogicalSupportFor(Token token, Fact fact, boolean bl) {
        if (!this.logicalSupportInUse()) {
            this.m_supportForFacts = new Multimap();
        }
        Multimap multimap = this.m_supportForFacts;
        synchronized (multimap) {
            Object object = this.m_supportForFacts.get(fact);
            if (object == null && bl) {
                return;
            }
            this.m_supportForFacts.put(fact, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnconditionalSupportFor(Fact fact) {
        if (!this.logicalSupportInUse()) {
            return;
        }
        Multimap multimap = this.m_supportForFacts;
        synchronized (multimap) {
            this.m_supportForFacts.remove(fact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLogicalSupportFrom(Token token, Fact fact) {
        if (!this.logicalSupportInUse()) {
            return;
        }
        Object object = this.m_supportForFacts.get(fact);
        if (object == null) {
            return;
        }
        Multimap multimap = this.m_supportForFacts;
        synchronized (multimap) {
            if (this.m_supportForFacts.remove(fact, token) && this.m_supportForFacts.get(fact) == null) {
                this.m_toRetract.add(fact);
            }
        }
    }

    void removeAllLogicalSupportFor(Fact fact) {
        if (this.logicalSupportInUse()) {
            this.m_supportForFacts.remove(fact);
        }
    }

    void factAsserted(Context context, Fact fact, boolean bl) {
        if (context.getLogicalSupportNode() != null) {
            Token token = context.getToken();
            context.getLogicalSupportNode().dependsOn(fact, context.getToken());
            this.addLogicalSupportFor(token, fact, bl);
        } else if (this.logicalSupportInUse()) {
            this.addUnconditionalSupportFor(fact);
        }
    }

    List getSupportingTokens(Fact fact) {
        if (this.logicalSupportInUse()) {
            Object object = this.m_supportForFacts.get(fact);
            return (List)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getSupportedFacts(Fact fact) {
        ArrayList arrayList = new ArrayList();
        if (this.logicalSupportInUse()) {
            Multimap multimap = this.m_supportForFacts;
            synchronized (multimap) {
                Iterator iterator = this.m_supportForFacts.entrySet().iterator();
                block3: while (iterator.hasNext()) {
                    Serializable serializable;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Object v = entry.getValue();
                    if (v == null) continue;
                    if (v instanceof Token) {
                        for (serializable = (Token)v; serializable != null; serializable = ((Token)serializable).getParent()) {
                            if (((Token)serializable).topFact().getFactId() != fact.getFactId()) continue;
                            arrayList.add(entry.getKey());
                            continue block3;
                        }
                        continue;
                    }
                    serializable = (ArrayList)entry.getValue();
                    block5: for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                        Token token;
                        for (Token token2 = token = (Token)((ArrayList)serializable).get(i); token2 != null; token2 = token2.getParent()) {
                            if (token2.topFact().getFactId() != fact.getFactId()) continue;
                            arrayList.add(entry.getKey());
                            continue block5;
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    public void clear() {
        if (this.logicalSupportInUse()) {
            this.m_supportForFacts.clear();
        }
    }
}

