/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.LongValue;
import jess.Value;

public final class JessToken
implements Serializable {
    public static final int NONE_TOK = 0;
    public static final int MULTIVARIABLE_TOK = 1;
    public static final int VARIABLE_TOK = 2;
    public static final int STRING_TOK = 3;
    public static final int SYMBOL_TOK = 4;
    public static final int INTEGER_TOK = 5;
    public static final int FLOAT_TOK = 6;
    public static final int COMMENT_TOK = 7;
    public static final int REGEXP_TOK = 8;
    public static final int LONG_TOK = 9;
    public static final int MULTILINE_COMMENT_TOK = 11;
    public String m_sval;
    public double m_nval;
    public long m_lval;
    public int m_lineno;
    public int m_ttype;
    public int m_start;
    public int m_end;

    public JessToken(int n, int n2) {
        this.m_start = n;
        this.m_end = n2;
    }

    public JessToken(int n, int n2, int n3, String string) {
        this(n, n2);
        this.m_ttype = n3;
        this.m_sval = string;
    }

    public Value valueOf(Context context) throws JessException {
        switch (this.m_ttype) {
            case 9: {
                return new LongValue(this.m_lval);
            }
            case 6: {
                return new Value(this.m_nval, 32);
            }
            case 5: {
                return new Value(this.m_nval, 4);
            }
            case 3: {
                return new Value(this.m_sval, 2);
            }
            case 1: 
            case 2: {
                if (context != null) {
                    return context.getVariable(this.m_sval);
                }
                return new Value("?" + this.m_sval, 1);
            }
            case 4: {
                return new Value(this.m_sval, 1);
            }
            case 0: {
                if (!"EOF".equals(this.m_sval)) break;
                return Funcall.EOF;
            }
        }
        return new Value("" + (char)this.m_ttype, 2);
    }

    public String toString() {
        if (this.m_ttype == 2) {
            return "?" + this.m_sval;
        }
        if (this.m_ttype == 1) {
            return "$?" + this.m_sval;
        }
        if (this.m_ttype == 3) {
            return "\"" + this.m_sval + "\"";
        }
        if (this.m_sval != null) {
            return this.m_sval;
        }
        if (this.m_ttype == 6) {
            return "" + this.m_nval;
        }
        if (this.m_ttype == 5) {
            return "" + (int)this.m_nval;
        }
        return "" + (char)this.m_ttype;
    }

    public boolean isComment() {
        return this.m_ttype == 7 || this.m_ttype == 11;
    }

    public boolean isEOF() {
        return this.m_ttype == 0 && "EOF".equals(this.m_sval);
    }

    public boolean isVariable() {
        return this.m_ttype == 2 || this.m_ttype == 1;
    }

    public boolean isLexeme() {
        return this.m_ttype == 4 || this.m_ttype == 3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JessToken)) {
            return false;
        }
        JessToken jessToken = (JessToken)object;
        return jessToken.m_ttype == this.m_ttype && jessToken.m_start == this.m_start && jessToken.m_end == this.m_end && jessToken.m_nval == this.m_nval && (jessToken.m_sval == this.m_sval || jessToken.m_sval != null && jessToken.m_sval.equals(this.m_sval));
    }

    public int hashCode() {
        return (int)((double)(this.m_ttype + this.m_start + this.m_end) + this.m_nval) + (this.m_sval == null ? 0 : this.m_sval.hashCode());
    }
}

