/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JPanel;
import jess.HasLHS;
import jess.JessEvent;
import jess.JessListener;
import jess.Node;
import jess.Node1RTL;
import jess.NodeJoin;
import jess.NodeViewer;
import jess.Rete;
import jess.VEdge;
import jess.VNode;

class Graph
extends JPanel
implements MouseListener,
MouseMotionListener,
JessListener {
    private int m_nVNodes;
    private VNode[] m_VNodes;
    private int m_nVEdges;
    private VEdge[] m_VEdges;
    private VNode m_pick;
    private Node m_show;
    private transient Rete m_engine;
    static final Color m_selectColor = Color.pink;
    static final int NODE_WIDTH = 10;
    static final int HW = 5;
    static final int NODE_HEIGHT = 10;
    static final int HH = 5;
    private long m_lastMD;
    private int[] m_nextSlot = new int[100];
    private Color[] m_edgeColors = new Color[]{Color.green, Color.blue};
    private HasLHS m_haslhs;

    public int getnVEdges() {
        return this.m_nVEdges;
    }

    public int getnVNodes() {
        return this.m_nVNodes;
    }

    Graph(Rete rete, HasLHS hasLHS) {
        this.m_engine = rete;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setSize(500, 500);
        this.m_haslhs = hasLHS;
        this.init();
    }

    int findVNode(Node node, int n) {
        for (int i = 0; i < this.m_nVNodes; ++i) {
            if (this.m_VNodes[i].m_node != node) continue;
            return i;
        }
        return this.addVNode(node, n);
    }

    private Color getNodeColor(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return Color.RED;
            }
            case 2: {
                return Color.GREEN;
            }
            case 3: {
                return Color.YELLOW;
            }
            case 4: {
                return Color.BLUE;
            }
            case 5: {
                return Color.CYAN;
            }
            case 6: {
                return Color.ORANGE;
            }
        }
        return Color.BLACK;
    }

    private Color getEdgeColor(Node node) {
        int n;
        int n2 = n = node instanceof NodeJoin ? 0 : 1;
        if (node instanceof Node1RTL) {
            n = 0;
        }
        if (n < 0 || n > this.m_edgeColors.length) {
            return Color.black;
        }
        return this.m_edgeColors[n];
    }

    int addVNode(Node node, int n) {
        int n2 = n;
        int n3 = this.m_nextSlot[n2] + 1;
        this.m_nextSlot[n2] = n3;
        VNode vNode = new VNode(n3 * 15, n * 15, this.getNodeColor(node), node);
        if (this.m_nVNodes == this.m_VNodes.length) {
            VNode[] vNodeArray = new VNode[this.m_nVNodes * 2];
            System.arraycopy(this.m_VNodes, 0, vNodeArray, 0, this.m_nVNodes);
            this.m_VNodes = vNodeArray;
        }
        this.m_VNodes[this.m_nVNodes] = vNode;
        return this.m_nVNodes++;
    }

    void addVEdge(Node node, Node node2, int n, Color color) {
        VEdge vEdge = new VEdge(this.findVNode(node, n), this.findVNode(node2, n + 1), color);
        for (int i = 0; i < this.m_nVEdges; ++i) {
            if (!vEdge.equals(this.m_VEdges[i])) continue;
            return;
        }
        if (this.m_nVEdges == this.m_VEdges.length) {
            VEdge[] vEdgeArray = new VEdge[this.m_nVEdges * 2];
            System.arraycopy(this.m_VEdges, 0, vEdgeArray, 0, this.m_nVEdges);
            this.m_VEdges = vEdgeArray;
        }
        this.m_VEdges[this.m_nVEdges++] = vEdge;
    }

    public void paintVNode(Graphics graphics, VNode vNode) {
        int n = vNode.m_x;
        int n2 = vNode.m_y;
        graphics.setColor(vNode == this.m_pick ? m_selectColor : vNode.m_c);
        int n3 = 10;
        int n4 = 10;
        graphics.fillRect(n - n3 / 2, n2 - n4 / 2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n - n3 / 2, n2 - n4 / 2, n3 - 1, n4 - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        Object object;
        int n2;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        for (n2 = 0; n2 < this.m_nVEdges; ++n2) {
            object = this.m_VEdges[n2];
            n = this.m_VNodes[((VEdge)object).m_from].m_x;
            int n3 = this.m_VNodes[((VEdge)object).m_from].m_y;
            int n4 = this.m_VNodes[((VEdge)object).m_to].m_x;
            int n5 = this.m_VNodes[((VEdge)object).m_to].m_y;
            graphics.setColor(((VEdge)object).m_c);
            graphics.drawLine(n, n3, n4, n5);
        }
        for (n2 = 0; n2 < this.m_nVNodes; ++n2) {
            this.paintVNode(graphics, this.m_VNodes[n2]);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.m_show != null) {
            graphics.setColor(Color.black);
            object = this.m_show.toString();
            n = fontMetrics.getHeight();
            graphics.drawString((String)object, 10, dimension.height - n + fontMetrics.getAscent());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = Integer.MAX_VALUE;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        for (int i = 0; i < this.m_nVNodes; ++i) {
            VNode vNode = this.m_VNodes[i];
            int n4 = (vNode.m_x - n2) * (vNode.m_x - n2) + (vNode.m_y - n3) * (vNode.m_y - n3);
            if (n4 >= n) continue;
            this.m_pick = vNode;
            n = n4;
        }
        if (n > 200) {
            this.m_pick = null;
        } else {
            this.m_pick.m_x = n2;
            this.m_pick.m_y = n3;
        }
        this.repaint();
        mouseEvent.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            long l = System.currentTimeMillis() - this.m_lastMD;
            if (l < 500L) {
                new NodeViewer(this.m_pick.m_node, this.m_engine);
                this.m_lastMD = 0L;
            } else if (this.m_pick != null) {
                this.m_pick.m_x = mouseEvent.getX();
                this.m_pick.m_y = mouseEvent.getY();
                this.m_lastMD = System.currentTimeMillis();
            }
        }
        finally {
            this.m_pick = null;
            this.repaint();
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_pick != null) {
            this.m_pick.m_x = mouseEvent.getX();
            this.m_pick.m_y = mouseEvent.getY();
            this.repaint();
        }
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = Integer.MAX_VALUE;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Node node = null;
        for (int i = 0; i < this.m_nVNodes; ++i) {
            VNode vNode = this.m_VNodes[i];
            int n4 = (vNode.m_x - n2) * (vNode.m_x - n2) + (vNode.m_y - n3) * (vNode.m_y - n3);
            if (n4 >= n) continue;
            node = vNode.m_node;
            n = n4;
        }
        this.m_show = n > 200 ? null : node;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void buildNetwork(Node node, int n) {
        Iterator iterator = node.successors();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (this.m_haslhs != null && !this.ruleContains(node2)) continue;
            this.addVEdge(node, node2, n, this.getEdgeColor(node));
            this.buildNetwork(node2, n + 1);
        }
    }

    private boolean ruleContains(Node node) {
        Iterator iterator = this.m_haslhs.getNodes();
        while (iterator.hasNext()) {
            if (iterator.next() != node) continue;
            return true;
        }
        return false;
    }

    public void init() {
        this.m_VNodes = new VNode[10];
        this.m_VEdges = new VEdge[10];
        this.m_nVEdges = 0;
        this.m_nVNodes = 0;
        this.m_pick = null;
        this.m_show = null;
        for (int i = 0; i < this.m_nextSlot.length; ++i) {
            this.m_nextSlot[i] = 0;
        }
        this.buildNetwork(this.m_engine.getCompiler().getRoot(), 1);
        this.repaint();
    }

    public void eventHappened(JessEvent jessEvent) {
        if ((jessEvent.getType() & 1) != 0 || jessEvent.getType() == 2048) {
            if (this.m_haslhs != null) {
                this.m_haslhs = this.m_engine.findDefrule(this.m_haslhs.getName());
            }
            this.init();
        }
    }
}

