/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Advice;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

final class FunctionHolder
implements Serializable {
    private static Userfunction UNDEFINED = new UndefinedFunction();
    private Userfunction m_uf;

    FunctionHolder(Userfunction userfunction) {
        this.setFunction(userfunction);
    }

    final void setFunction(Userfunction userfunction) {
        this.m_uf = userfunction == null ? UNDEFINED : userfunction;
    }

    final Userfunction getFunction() {
        return this.m_uf;
    }

    final Value call(Funcall funcall, Context context) throws JessException {
        Userfunction userfunction = this.m_uf;
        if (context.getInAdvice()) {
            userfunction = this.stripAdvice();
        }
        return userfunction.call(funcall, context);
    }

    Userfunction stripAdvice() {
        Userfunction userfunction = this.m_uf;
        while (userfunction instanceof Advice) {
            userfunction = ((Advice)userfunction).getFunction();
        }
        return userfunction;
    }

    private static class UndefinedFunction
    implements Userfunction,
    Serializable {
        private UndefinedFunction() {
        }

        public String getName() {
            return "undefined";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            throw new JessException(valueVector.get(0).stringValue(context), "undefined function", valueVector.get(0).stringValue(context));
        }
    }
}

