/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.HashMap;
import jess.Context;
import jess.Duplicate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.IntrinsicPackageImpl;
import jess.JessException;
import jess.Modify;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class FactFunctions
extends IntrinsicPackageImpl {
    FactFunctions() {
    }

    public void add(HashMap hashMap) {
        this.addFunction(new Assert(), hashMap);
        this.addFunction(new Retract(), hashMap);
        this.addFunction(new Update(), hashMap);
        this.addFunction(new RetractString(), hashMap);
        this.addFunction(new Duplicate(), hashMap);
        this.addFunction(new Modify(), hashMap);
        this.addFunction(new AssertString(), hashMap);
        this.addFunction(new Add(), hashMap);
    }

    class RetractString
    implements Userfunction,
    Serializable {
        RetractString() {
        }

        public String getName() {
            return "retract-string";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            for (int i = 1; i < valueVector.size(); ++i) {
                context.getEngine().retractString(valueVector.get(i).stringValue(context));
            }
            return Funcall.TRUE;
        }
    }

    class AssertString
    implements Userfunction,
    Serializable {
        AssertString() {
        }

        public String getName() {
            return "assert-string";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            String string = valueVector.get(1).stringValue(context);
            Fact fact = context.getEngine().assertString(string, context);
            if (fact != null) {
                return new FactIDValue(fact);
            }
            return Funcall.FALSE;
        }
    }

    class Retract
    implements Userfunction,
    Serializable {
        Retract() {
        }

        public String getName() {
            return "retract";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            Value value = valueVector.get(1);
            if (value.type() == 1 && value.stringValue(context).equals("*")) {
                context.getEngine().removeAllFacts();
            } else {
                Rete rete = context.getEngine();
                for (int i = 1; i < valueVector.size(); ++i) {
                    Value value2 = valueVector.get(i).resolveValue(context);
                    Fact fact = value2.type() == 4 ? rete.findFactByID(value2.intValue(context)) : (Fact)value2.javaObjectValue(context);
                    if (fact == null) {
                        return Funcall.FALSE;
                    }
                    rete.retract(fact);
                }
            }
            return Funcall.TRUE;
        }
    }

    class Update
    implements Userfunction,
    Serializable {
        Update() {
        }

        public String getName() {
            return "update";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            Value value = null;
            Rete rete = context.getEngine();
            for (int i = 1; i < valueVector.size(); ++i) {
                Object object = valueVector.get(i).javaObjectValue(context);
                value = rete.updateObject(object);
            }
            if (value != null) {
                return value;
            }
            return Funcall.FALSE;
        }
    }

    class Assert
    implements Userfunction,
    Serializable {
        Assert() {
        }

        public String getName() {
            return "assert";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            Fact fact = null;
            Rete rete = context.getEngine();
            for (int i = 1; i < valueVector.size(); ++i) {
                Fact fact2 = valueVector.get(i).factValue(context).expand(context);
                fact = rete.assertFact(fact2, context);
            }
            if (fact != null) {
                return new FactIDValue(fact);
            }
            return Funcall.FALSE;
        }
    }

    class Add
    implements Userfunction,
    Serializable {
        Add() {
        }

        public String getName() {
            return "add";
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            Rete rete = context.getEngine();
            Object object = valueVector.get(1).javaObjectValue(context);
            return rete.add(object);
        }
    }
}

