/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import jess.ClassTemplateMaker;
import jess.Fact;
import jess.HashCodeComputer;
import jess.JessException;
import jess.MockBean;
import jess.Rete;
import jess.Value;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DefinstanceListTest
extends TestCase {
    private MockBean[] m_beans;
    private Rete m_engine;
    static /* synthetic */ Class class$jess$DefinstanceListTest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    protected void setUp() throws Exception {
        this.m_beans = new MockBean[]{new MockBean(), new MockBean(), new MockBean()};
        this.m_engine = new Rete();
        this.m_engine.defclass("bean", "jess.MockBean", null);
    }

    protected void tearDown() throws Exception {
        this.m_beans = null;
        this.m_engine = null;
    }

    public static TestSuite suite() {
        return new TestSuite(class$jess$DefinstanceListTest == null ? (class$jess$DefinstanceListTest = DefinstanceListTest.class$("jess.DefinstanceListTest")) : class$jess$DefinstanceListTest);
    }

    public DefinstanceListTest(String string) {
        super(string);
    }

    public void testUpdate() throws Exception {
        MockBean mockBean = this.m_beans[0];
        mockBean.setFoo("abc");
        Value value = this.m_engine.definstance("bean", this.m_beans[0], false);
        Fact fact = value.factValue(this.m_engine.getGlobalContext());
        DefinstanceListTest.assertEquals((String)"abc", (String)fact.getSlotValue("foo").stringValue(null));
        mockBean.setFoo("xyz");
        DefinstanceListTest.assertEquals((String)"Before update", (String)"abc", (String)fact.getSlotValue("foo").stringValue(null));
        this.m_engine.updateObject(mockBean);
        DefinstanceListTest.assertEquals((String)"After update", (String)"xyz", (String)fact.getSlotValue("foo").stringValue(null));
    }

    public void testDestructiveList() throws Exception {
        int n;
        for (n = 0; n < this.m_beans.length; ++n) {
            this.m_engine.definstance("bean", this.m_beans[n], true);
        }
        n = this.m_beans.length;
        Iterator iterator = this.m_engine.listDefinstances();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            DefinstanceListTest.assertEquals((int)n, (int)this.countDefinstances(this.m_engine));
            this.m_engine.undefinstance(e);
            --n;
        }
        DefinstanceListTest.assertEquals((int)0, (int)this.countDefinstances(this.m_engine));
    }

    public void testDefinstanceBasics() throws Exception {
        int n;
        for (n = 0; n < this.m_beans.length; ++n) {
            this.m_engine.definstance("bean", this.m_beans[n], true);
        }
        for (n = 0; n < this.m_beans.length; ++n) {
            DefinstanceListTest.assertEquals((String)"check listeners", (int)1, (int)this.m_beans[n].numChangeListeners());
        }
        DefinstanceListTest.assertEquals((String)"list definstances", (int)3, (int)this.countDefinstances(this.m_engine));
        this.m_engine.reset();
        for (n = 0; n < this.m_beans.length; ++n) {
            DefinstanceListTest.assertEquals((String)"after reset", (int)1, (int)this.m_beans[n].numChangeListeners());
        }
        DefinstanceListTest.assertEquals((String)"list definstances after reset", (int)3, (int)this.countDefinstances(this.m_engine));
        this.m_engine.undefinstance(this.m_beans[0]);
        for (n = 1; n < this.m_beans.length; ++n) {
            DefinstanceListTest.assertEquals((String)"after undefinstance", (int)1, (int)this.m_beans[n].numChangeListeners());
        }
        DefinstanceListTest.assertEquals((String)"after undefinstance", (int)0, (int)this.m_beans[0].numChangeListeners());
        DefinstanceListTest.assertEquals((String)"list definstances after undefinstance", (int)2, (int)this.countDefinstances(this.m_engine));
        this.m_engine.clear();
        for (n = 0; n < this.m_beans.length; ++n) {
            DefinstanceListTest.assertEquals((String)"after clear", (int)0, (int)this.m_beans[n].numChangeListeners());
        }
        DefinstanceListTest.assertEquals((String)"list definstances after clear", (int)0, (int)this.countDefinstances(this.m_engine));
    }

    public void testErrorNoPropertyChangeSupport() throws Exception {
        Rete rete = new Rete();
        rete.defclass("foo", "java.awt.Point", null);
        try {
            rete.definstance("foo", new Point(0, 0), true);
            DefinstanceListTest.fail((String)"Missed expected exception");
        }
        catch (JessException jessException) {
            DefinstanceListTest.assertEquals((int)0, (int)this.countDefinstances(rete));
        }
    }

    private int countDefinstances(Rete rete) {
        int n = 0;
        Iterator iterator = rete.listDefinstances();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public void testGetSlotType() throws Exception {
        DefinstanceListTest.assertEquals((String)"INTEGER", (String)ClassTemplateMaker.getSlotType(Integer.TYPE));
        DefinstanceListTest.assertEquals((String)"INTEGER", (String)ClassTemplateMaker.getSlotType(Byte.TYPE));
        DefinstanceListTest.assertEquals((String)"INTEGER", (String)ClassTemplateMaker.getSlotType(Short.TYPE));
        DefinstanceListTest.assertEquals((String)"FLOAT", (String)ClassTemplateMaker.getSlotType(Float.TYPE));
        DefinstanceListTest.assertEquals((String)"FLOAT", (String)ClassTemplateMaker.getSlotType(Double.TYPE));
        DefinstanceListTest.assertEquals((String)"LONG", (String)ClassTemplateMaker.getSlotType(Long.TYPE));
        DefinstanceListTest.assertEquals((String)"STRING", (String)ClassTemplateMaker.getSlotType(class$java$lang$String == null ? (class$java$lang$String = DefinstanceListTest.class$("java.lang.String")) : class$java$lang$String));
        DefinstanceListTest.assertEquals((String)"SYMBOL", (String)ClassTemplateMaker.getSlotType(Boolean.TYPE));
        DefinstanceListTest.assertEquals((String)"ANY", (String)ClassTemplateMaker.getSlotType(class$java$lang$Object == null ? (class$java$lang$Object = DefinstanceListTest.class$("java.lang.Object")) : class$java$lang$Object));
    }

    public void testContainsObject() throws Exception {
        Rete rete = new Rete();
        Integer n = new Integer(3);
        rete.defclass("Integer", "java.lang.Integer", null);
        rete.definstance("Integer", n, false);
        DefinstanceListTest.assertTrue((boolean)rete.containsObject(n));
        DefinstanceListTest.assertFalse((boolean)rete.containsObject(new Integer(4)));
    }

    public void testPropertyChangeNullPropertyName() throws Exception {
        Rete rete = new Rete();
        rete.eval("(deftemplate foo (declare (from-class java.awt.Point) (slot-specific TRUE)))");
        Point point = new Point(0, 0);
        HashCodeComputer.setNonValueClass(rete, "java.awt.Point");
        rete.definstance("foo", point, false);
        rete.eval("(defrule foo (foo (x 0.0)) => )");
        DefinstanceListTest.assertEquals((int)1, (int)rete.run());
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(point, null, null, null);
        rete.getDefinstanceList().propertyChange(propertyChangeEvent);
        DefinstanceListTest.assertEquals((int)0, (int)rete.run());
        point.y = 1;
        rete.getDefinstanceList().propertyChange(propertyChangeEvent);
        DefinstanceListTest.assertEquals((int)0, (int)rete.run());
        point.x = 1;
        rete.getDefinstanceList().propertyChange(propertyChangeEvent);
        DefinstanceListTest.assertEquals((int)0, (int)rete.run());
        point.x = 0;
        rete.getDefinstanceList().propertyChange(propertyChangeEvent);
        DefinstanceListTest.assertEquals((int)1, (int)rete.run());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

