/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jess.ClassTemplateMaker;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Filter;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.ReteCompiler;
import jess.SerializableD;
import jess.Value;

class DefinstanceList
implements Serializable,
PropertyChangeListener {
    private HashMap m_javaClasses = new HashMap(101);
    private Map m_definstances = new IdentityHashMap(101);
    private Map m_jessClasses = new IdentityHashMap(101);
    private transient Rete m_engine;
    public static final String JAVA_OBJECT = "$JAVA-OBJECT$ ";
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    DefinstanceList(Rete rete) {
        this.setEngine(rete);
    }

    void setEngine(Rete rete) {
        this.m_engine = rete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            Iterator iterator = this.m_definstances.keySet().iterator();
            while (iterator.hasNext()) {
                this.removePropertyChangeListener(iterator.next());
            }
            this.m_javaClasses.clear();
            this.m_definstances.clear();
            this.m_jessClasses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() throws JessException {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            Iterator iterator = this.m_definstances.keySet().iterator();
            while (iterator.hasNext()) {
                this.reassertShadowFact(iterator.next(), this.m_engine.getGlobalContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value defclass(String string, String string2, String string3, boolean bl) throws JessException {
        try {
            ReteCompiler reteCompiler = this.m_engine.getCompiler();
            synchronized (reteCompiler) {
                ClassTemplateMaker classTemplateMaker = new ClassTemplateMaker(this.m_engine, string2);
                this.mapDefclassName(this.m_engine.resolveName(string), classTemplateMaker.getClassName());
                Deftemplate deftemplate = classTemplateMaker.createDeftemplate(string, string3, bl);
                this.m_engine.addDeftemplate(deftemplate);
                return new Value(classTemplateMaker.getClassName(), 1);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JessException("defclass", "Class not found:", classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value definstance(String string, Object object, boolean bl, Context context) throws JessException {
        try {
            ReteCompiler reteCompiler = this.m_engine.getCompiler();
            synchronized (reteCompiler) {
                Object object2;
                String string2 = this.jessNameToJavaName(string, this.m_engine);
                if (string2 == null) {
                    throw new JessException("definstance", "Unknown object class", string);
                }
                if (this.m_definstances.get(object) != null) {
                    return new FactIDValue(null);
                }
                if (!context.getEngine().findClass(string2).isAssignableFrom(object.getClass())) {
                    throw new JessException("definstance", "Object is not instance of", string2);
                }
                if (bl) {
                    Class clazz = context.getEngine().findClass("java.beans.PropertyChangeListener");
                    object2 = object.getClass().getMethod("addPropertyChangeListener", clazz);
                    ((Method)object2).invoke(object, this);
                }
                int n = bl ? 1 : 2;
                this.m_jessClasses.put(object, string);
                object2 = this.createNewShadowFact(object, context, n);
                object2 = this.m_engine.assertFact((Fact)object2, context);
                return new FactIDValue((Fact)object2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JessException("DefinstanceList.definstance", "Cannot add PropertyChangeListener", invocationTargetException.getTargetException());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JessException("DefinstanceList.definstance", "Obj doesn't accept PropertyChangeListeners", noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JessException("DefinstanceList.definstance", "Class not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JessException("DefinstanceList.definstance", "Class or method is not accessible", illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undefinstanceNoRetract(Object object) throws JessException {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            this.removePropertyChangeListener(object);
            this.m_definstances.remove(object);
            this.m_jessClasses.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Fact undefinstance(Object object) throws JessException {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            Fact fact = (Fact)this.m_definstances.get(object);
            this.undefinstanceNoRetract(object);
            if (fact != null) {
                fact = this.m_engine.retractNoUndefinstance(fact);
            }
            return fact;
        }
    }

    private void removePropertyChangeListener(Object object) {
        try {
            Method method = object.getClass().getMethod("removePropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefinstanceList.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
            method.invoke(object, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set listDefinstances() {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            return new HashSet(this.m_definstances.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set listDefinstances(Filter filter) {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.m_definstances.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!filter.accept(k)) continue;
                hashSet.add(k);
            }
            return hashSet;
        }
    }

    boolean containsObject(Object object) {
        return this.m_definstances.containsKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator listDefclasses() {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            return new ArrayList(this.m_javaClasses.keySet()).iterator();
        }
    }

    String jessNameToJavaName(String string, Rete rete) {
        String string2 = (String)this.m_javaClasses.get(string);
        if (string2 == null) {
            string2 = (String)this.m_javaClasses.get(rete.resolveName(string));
        }
        if (string2 == null && string.indexOf("::") == -1) {
            string2 = (String)this.m_javaClasses.get("MAIN::" + string);
        }
        return string2;
    }

    private void mapDefclassName(String string, String string2) {
        this.m_javaClasses.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Fact getShadowFactForObject(Object object) throws JessException {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            Fact fact = (Fact)this.m_definstances.get(object);
            if (fact == null) {
                throw new JessException("DefinstanceList.getShadowFactForObject", "Object not a definstance: ", object.toString());
            }
            return fact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fact updateMultipleSlots(Object object, Context context) throws JessException {
        Fact fact = this.getShadowFactForObject(object);
        Rete rete = context.getEngine();
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            this.m_definstances.put(object, fact);
            Deftemplate deftemplate = fact.getDeftemplate();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Value> arrayList2 = new ArrayList<Value>();
            try {
                for (int i = 0; i < deftemplate.getNSlots(); ++i) {
                    String string = deftemplate.getSlotName(i);
                    if (string.equals("OBJECT")) continue;
                    Value value = this.getSlotValueFromObject(deftemplate, i, rete, object).resolveValue(context);
                    Value value2 = fact.getSlotValue(string);
                    if (value2 != null && value2.equals(value)) continue;
                    arrayList.add(string);
                    arrayList2.add(value);
                }
                rete.modifyRegularFact(fact, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new Value[arrayList2.size()]), rete, context);
            }
            finally {
                rete.commitActivations();
            }
        }
        return fact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fact updateSingleSlot(Object object, String string, Object object2, Context context) throws JessException {
        Fact fact = this.getShadowFactForObject(object);
        Rete rete = context.getEngine();
        try {
            ReteCompiler reteCompiler = rete.getCompiler();
            synchronized (reteCompiler) {
                Deftemplate deftemplate = fact.getDeftemplate();
                int n = deftemplate.getSlotIndex(string);
                if (n == -1) {
                    throw new JessException("DeftemplateList.updateSingleSlot", "No such slot " + string + " in template", deftemplate.getName());
                }
                Value value = object2 == null ? this.getSlotValueFromObject(deftemplate, n, rete, object) : this.objectPropertyToSlotValue(deftemplate, n, rete, object2);
                try {
                    if (!fact.getSlotValue(string).equals(value)) {
                        rete.modifyRegularFact(fact, new String[]{string}, new Value[]{value}, rete, context);
                    }
                }
                finally {
                    rete.commitActivations();
                }
                return fact;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JessException("DefinstanceList.updateShadowFact", "Invalid argument", illegalArgumentException);
        }
    }

    private Value objectPropertyToSlotValue(Deftemplate deftemplate, int n, Rete rete, Object object) throws JessException {
        SerializableD serializableD = (SerializableD)deftemplate.getSlotDefault(n).javaObjectValue(rete.getGlobalContext());
        Class clazz = serializableD.getPropertyType(rete);
        return RU.objectToValue(clazz, object);
    }

    private void reassertShadowFact(Object object, Context context) throws JessException {
        Fact fact = this.getShadowFactForObject(object);
        this.setAllSlotValuesFromObject(context, fact, object);
        this.m_engine.assertFact(fact, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fact createNewShadowFact(Object object, Context context, int n) throws JessException {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            Fact fact = new Fact((String)this.m_jessClasses.get(object), this.m_engine);
            fact.setShadowMode(n);
            this.setAllSlotValuesFromObject(context, fact, object);
            return fact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllSlotValuesFromObject(Context context, Fact fact, Object object) throws JessException {
        ReteCompiler reteCompiler = this.m_engine.getCompiler();
        synchronized (reteCompiler) {
            Rete rete = context.getEngine();
            fact.setSlotValue("OBJECT", new Value(object));
            this.m_definstances.put(object, fact);
            Deftemplate deftemplate = fact.getDeftemplate();
            for (int i = 0; i < deftemplate.getNSlots(); ++i) {
                String string = deftemplate.getSlotName(i);
                if (string.equals("OBJECT")) continue;
                Value value = this.getSlotValueFromObject(deftemplate, i, rete, object);
                fact.setSlotValue(string, value);
            }
        }
    }

    private Value getSlotValueFromObject(Deftemplate deftemplate, int n, Rete rete, Object object) throws JessException {
        try {
            SerializableD serializableD = (SerializableD)deftemplate.getSlotDefault(n).javaObjectValue(rete.getGlobalContext());
            Object object2 = serializableD.getPropertyValue(rete, object);
            return RU.objectToValue(serializableD.getPropertyType(rete), object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JessException("DefinstanceList.updateMultipleSlots", "Called method threw an exception", invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JessException("DefinstanceList.updateMultipleSlots", "Method is not accessible", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JessException("DefinstanceList.updateMultipleSlots", "Invalid argument", illegalArgumentException);
        }
    }

    Value updateObject(Object object) throws JessException {
        Fact fact = this.updateMultipleSlots(object, this.m_engine.getGlobalContext());
        return new FactIDValue(fact);
    }

    Value updateObject(Object object, String string) throws JessException {
        Fact fact = this.updateSingleSlot(object, string, null, this.m_engine.getGlobalContext());
        return new FactIDValue(fact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block8: {
            Object object = propertyChangeEvent.getSource();
            try {
                ReteCompiler reteCompiler = this.m_engine.getCompiler();
                synchronized (reteCompiler) {
                    if (this.m_definstances.get(object) == null) {
                        return;
                    }
                    String string = propertyChangeEvent.getPropertyName();
                    Object object2 = propertyChangeEvent.getNewValue();
                    Context context = this.m_engine.getGlobalContext();
                    if (string == null) {
                        this.updateMultipleSlots(object, context);
                    } else {
                        this.updateSingleSlot(object, string, object2, context);
                    }
                }
            }
            catch (JessException jessException) {
                System.out.println("Async Error: " + jessException);
                jessException.printStackTrace();
                if (jessException.getCause() == null) break block8;
                jessException.getCause().printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

