/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.rc;

import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.rc.DSRendererControls;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class VMRControls
extends DSRendererControls {
    private int b;
    private int c;
    private int d = 4;
    public int type;
    private long a;
    private boolean a;
    private byte[] a;
    private float[] a = new float[16];
    private byte[] b;
    public static final int MixerPref9_BiLinearFiltering = 16;
    public static final int MixerPref9_PointFiltering = 32;
    public static final int MixerPref9_AnisotropicFiltering = 64;
    public static final int MixerPref9_PyramidalQuadFiltering = 128;
    public static final int MixerPref9_GaussianQuadFiltering = 256;
    public static final int MixerPref9_RenderTargetRGB = 4096;
    public static final int MixerPref9_RenderTargetYUV = 8192;
    public static final int MixerPref9_DynamicSwitchToBOB = 0x100000;
    public static final int MixerPref9_DynamicDecimateBy2 = 0x200000;
    public static final int[] MixerPref9 = new int[]{16, 32, 64, 128, 256, 4096, 8192, 0x100000, 0x200000};

    VMRControls(DSFiltergraph dSFiltergraph) {
        super(dSFiltergraph);
        this.a = dSFiltergraph.getID();
        this.type = 32;
        long l2 = this.setupVMRControls(this.a, this.a);
        if (l2 < 0L) {
            throw new DSJException("VMRControls: initialization failed", -400);
        }
        try {
            this.d = Integer.valueOf(DSEnvironment.getXMLPreference("VMR_Inputs"));
        }
        catch (Exception exception) {
            this.d = 4;
        }
        IMG = this.d = this.d < 4 ? 4 : this.d;
    }

    public boolean addFileSource(String string, int n2, int n3) {
        if (n2 > this.d) {
            return false;
        }
        boolean bl = this.addVMRFileSource(this.a, string, n2, n3);
        if (!bl) {
            return false;
        }
        if (n2 == 0) {
            this.a.graphChanged();
        }
        return true;
    }

    public boolean addFilterSource(DSFilterInfo dSFilterInfo, int n2, int n3) {
        if (n2 > this.d) {
            return false;
        }
        return this.addVMRFilterSource(this.a, dSFilterInfo, n2, 0);
    }

    public boolean addGraphSource(DSFiltergraph dSFiltergraph, int n2, int n3) {
        if (n2 > this.d) {
            return false;
        }
        return this.addVMRGraphSource(this.a, dSFiltergraph.getID(), n2, 0);
    }

    public boolean removeSource(int n2, int n3) {
        if (n2 > this.d) {
            return false;
        }
        return this.addVMRFilterSource(this.a, DSFilterInfo.doNotRender(), n2, 0);
    }

    public void showVMRPropertyPage() {
        this.controlRenderer(this.a, -1, (int[])this.a);
    }

    public int getNumberOfInputs() {
        return this.d;
    }

    public void setAlpha(int n2, float f2) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = (int)(f2 * 100.0f);
        this.controlRenderer(this.a, 1, (int[])this.a);
    }

    public void setZOrder(int n2, int n3) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = n3;
        this.controlRenderer(this.a, 2, (int[])this.a);
    }

    public void setOutputRect(int n2, int n3, int n4, int n5, int n6) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = n3;
        this.a[2] = n4;
        this.a[3] = n5;
        this.a[4] = n6;
        this.controlRenderer(this.a, 4, (int[])this.a);
    }

    public float[] getVProcAmpRanges(int n2) {
        float[] fArray = new float[4];
        System.arraycopy(this.a, n2 << 2, fArray, 0, 4);
        return fArray;
    }

    public void setContrast(int n2, float f2) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        if (f2 < this.a[0] || f2 > this.a[1]) {
            throw new DSJException("VMRControls: value out of range", -401);
        }
        this.a[0] = n2;
        this.a[1] = false;
        this.a[2] = (int)(1000.0f * f2);
        this.controlRenderer(this.a, 8, (int[])this.a);
    }

    public float getContrast(int n2) {
        if (n2 > this.d) {
            return -1.0f;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = -4;
        this.controlRenderer(this.a, 8, (int[])this.a);
        return (float)this.a[2] / 1000.0f;
    }

    public void setBrightness(int n2, float f2) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        if (f2 < this.a[4] || f2 > this.a[5]) {
            throw new DSJException("VMRControls: value out of range", -401);
        }
        this.a[0] = n2;
        this.a[1] = true;
        this.a[2] = (int)(1000.0f * f2);
        this.controlRenderer(this.a, 8, (int[])this.a);
    }

    public float getBrightness(int n2) {
        if (n2 > this.d) {
            return -1.0f;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = -1;
        this.controlRenderer(this.a, 8, (int[])this.a);
        return (float)this.a[2] / 1000.0f;
    }

    public void setHue(int n2, float f2) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        if (f2 < this.a[8] || f2 > this.a[9]) {
            throw new DSJException("VMRControls: value out of range", -401);
        }
        this.a[0] = n2;
        this.a[1] = 2;
        this.a[2] = (int)(1000.0f * f2);
        this.controlRenderer(this.a, 8, (int[])this.a);
    }

    public float getHue(int n2) {
        if (n2 > this.d) {
            return -1.0f;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = -2;
        this.controlRenderer(this.a, 8, (int[])this.a);
        return (float)this.a[2] / 1000.0f;
    }

    public void setSaturation(int n2, float f2) {
        if (n2 > this.d) {
            return;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        if (f2 < this.a[12] || f2 > this.a[13]) {
            throw new DSJException("VMRControls: value out of range", -401);
        }
        this.a[0] = n2;
        this.a[1] = 3;
        this.a[2] = (int)(1000.0f * f2);
        this.controlRenderer(this.a, 8, (int[])this.a);
    }

    public float getSaturation(int n2) {
        if (n2 > this.d) {
            return -1.0f;
        }
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a[0] = n2;
        this.a[1] = -3;
        this.controlRenderer(this.a, 8, (int[])this.a);
        return (float)this.a[2] / 1000.0f;
    }

    public byte[] grabBitmap() {
        int n2;
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.a == null) {
            try {
                this.a = new byte[(int)(this.a.getMediaDimension().getWidth() * this.a.getMediaDimension().getHeight() * 4.0)];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n2 = this.grabBMP(this.a, this.a, 0, this.a.length)) < 0 && n2 != -1) {
            n2 = -n2;
            int n3 = n2 >> 28;
            int n4 = n2 >> 14 & 0xFFF;
            int n5 = n2 & 0xFFF;
            if (n4 > 4000 || n5 > 4000 && this.a.getActive()) {
                throw new DSJException("Error while grabbing frame: ", -n2);
            }
            this.a = new byte[n4 * n5 * n3];
            return this.grabBitmap();
        }
        if (n2 == -1) {
            throw new DSJException("Error while grabbing frame: ", n2);
        }
        return this.a;
    }

    public void setMixingPrefs(int n2) {
        this.a[0] = n2 &= 0xFFFFFFF0;
        this.a[1] = -1;
        int n3 = this.controlRenderer(this.a, 32, (int[])this.a);
        if (n3 < 0) {
            throw new DSJException("setMixingPrefs failed: " + DSJException.hresultToHexString(n3), n3);
        }
    }

    public int getMixingPrefs() {
        int n2 = this.controlRenderer(this.a, 64, (int[])this.a);
        if (n2 < 0) {
            throw new DSJException("getMixingPrefs failed: " + DSJException.hresultToHexString(n2), n2);
        }
        return n2;
    }

    public String[] getAvailableDeinterlacers(int n2) {
        Vector vector = new Vector();
        int n3 = this.VMRDeinterlace(this.a, n2, null, vector);
        if (n3 == -1) {
            throw new DSJException("No VideoInfo2", -39);
        }
        if (n3 == -2) {
            throw new DSJException("Mediatype not flagged as interlaced", -39);
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public void setDeinterlacingMode(int n2, String string) {
        this.a.stop();
        n2 = this.VMRDeinterlace(this.a, 0x100 | n2, string, null);
        this.a.play();
        if (n2 < 0) {
            throw new DSJException("Can't set Deinterlacer", n2);
        }
    }

    public String getDeinterlacingMode(int n2) {
        Vector vector = new Vector();
        this.VMRDeinterlace(this.a, 0x200 | n2, null, vector);
        return vector.get(0).toString();
    }

    public synchronized boolean setOverlayImage(BufferedImage bufferedImage, int[] nArray, Color color, float f2) {
        Object object;
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        if (bufferedImage == null) {
            this.renderAlphaBitmap(this.a, null, null, -1, -1.0f);
            this.a = false;
            return false;
        }
        if (!bufferedImage.getColorModel().hasAlpha()) {
            throw new DSJException("VMRControls: supplied overlay image has no alpha channel", -120);
        }
        if (this.a && (bufferedImage.getWidth() != this.b || bufferedImage.getHeight() != this.c)) {
            this.a = false;
        }
        try {
            object = bufferedImage.getWritableTile(bufferedImage.getWidth(), bufferedImage.getHeight());
            this.b = ((DataBufferByte)((Raster)object).getDataBuffer()).getData();
        }
        catch (Exception exception) {
            throw new DSJException("VMRControls: incompatible image buffer", -120);
        }
        if (bufferedImage.getType() != 6 && bufferedImage.getType() != 7) {
            int n2 = bufferedImage.getWidth() << 2;
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[4];
            int n3 = 0;
            for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
                for (int i3 = 0; i3 < n2; i3 += 4) {
                    System.arraycopy(this.b, n3 + i3, byArray2, 0, 4);
                    try {
                        byArray[0] = (byte)bufferedImage.getColorModel().getAlpha(byArray2);
                        byArray[1] = (byte)bufferedImage.getColorModel().getBlue(byArray2);
                        byArray[2] = (byte)bufferedImage.getColorModel().getGreen(byArray2);
                        byArray[3] = (byte)bufferedImage.getColorModel().getRed(byArray2);
                        this.b[n3 + i3] = byArray[0];
                        this.b[n3 + i3 + 1] = byArray[1];
                        this.b[n3 + i3 + 2] = byArray[2];
                        this.b[n3 + i3 + 3] = byArray[3];
                        continue;
                    }
                    catch (Exception exception) {
                        throw new DSJException("VMRControls: incompatible image buffer", -120);
                    }
                }
                n3 += n2;
            }
        }
        this.b = bufferedImage.getWidth();
        this.c = bufferedImage.getHeight();
        object = new int[]{this.a ? 65536 : 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray == null ? 0 : nArray[0], nArray == null ? 0 : nArray[1], nArray == null ? bufferedImage.getWidth() : nArray[2], nArray == null ? bufferedImage.getHeight() : nArray[3]};
        if (!this.a.getActive()) {
            throw new DSJException("Graph not active", -2);
        }
        this.a = this.renderAlphaBitmap(this.a, this.b, (int[])object, color == null ? -1 : color.getRGB(), f2);
        return this.a;
    }

    native long setupVMRControls(long var1, float[] var3);

    native int controlRenderer(long var1, int var3, int[] var4);

    native boolean addVMRFileSource(long var1, String var3, int var4, int var5);

    native boolean addVMRFilterSource(long var1, DSFilterInfo var3, int var4, int var5);

    native boolean addVMRGraphSource(long var1, long var3, int var5, int var6);

    native boolean renderAlphaBitmap(long var1, byte[] var3, int[] var4, int var5, float var6);

    native int grabBMP(long var1, byte[] var3, int var4, int var5);

    native int VMRDeinterlace(long var1, int var3, String var4, Vector var5);
}

