/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.DSCapture;
import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSMediaType;
import de.humatic.dsj.sbe.StreamBufferBDASource;
import de.humatic.dsj.sbe.StreamBufferCaptureSource;
import de.humatic.dsj.sbe.StreamBufferFileSource;
import de.humatic.dsj.sbe.StreamBufferSource;
import de.humatic.dsj.xml.XMLUtils;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSStreamBufferGraph
extends DSFiltergraph {
    private StreamBufferSource a;
    private long b;

    public DSStreamBufferGraph(int n2, StreamBufferSource streamBufferSource, PropertyChangeListener propertyChangeListener) {
        if (System.getProperty("os.name").indexOf("XP") < 0 && System.getProperty("os.name").indexOf("Vista") < 0 && System.getProperty("os.name").toLowerCase().indexOf("windows 7") < 0) {
            throw new DSJException("StreamBufferEngine requires Windows XP SP1 or higher", -1);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(n2, streamBufferSource, null, null);
    }

    public DSStreamBufferGraph(int n2, StreamBufferSource streamBufferSource, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2, PropertyChangeListener propertyChangeListener) {
        if (System.getProperty("os.name").indexOf("XP") < 0 && System.getProperty("os.name").indexOf("Vista") < 0 && System.getProperty("os.name").toLowerCase().indexOf("windows 7") < 0) {
            throw new DSJException("StreamBufferEngine requires Windows XP SP1 or higher", -1);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(n2, streamBufferSource, dSFilterInfo, dSFilterInfo2);
    }

    private void a(int n2, StreamBufferSource streamBufferSource, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2) {
        this.a = streamBufferSource;
        if (this.a instanceof StreamBufferCaptureSource) {
            try {
                if (!DSEnvironment.registerDeviceUse(this.a.getDeviceInfos()[0].getPath())) {
                    throw new DSJException("StreamBufferCaptureSource: device is busy: " + this.a.getDeviceInfos()[0].getName(), -200);
                }
                if (!DSEnvironment.registerDeviceUse(this.a.getDeviceInfos()[1].getPath())) {
                    throw new DSJException("StreamBufferCaptureSource: device is busy: " + this.a.getDeviceInfos()[1].getName(), -200);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.a(n2);
        this.type = 5;
        this.j = n2;
        if (dSFilterInfo == null || dSFilterInfo2 == null) {
            Node node = DSEnvironment.getClassNode("DSStreamBufferGraph", (Document)((Object)a));
            if (dSFilterInfo == null) {
                try {
                    dSFilterInfo = DSFilterInfo.filterInfoForName(XMLUtils.getElementByName(node, "mpegdecoder", null, false).getAttribute("name"));
                }
                catch (Exception exception) {
                    dSFilterInfo = DSFilterInfo.doNotRender();
                }
            }
            if (dSFilterInfo2 == null) {
                try {
                    dSFilterInfo2 = DSFilterInfo.filterInfoForName(XMLUtils.getElementByName(node, "audiodecoder", null, false).getAttribute("name"));
                }
                catch (Exception exception) {
                    dSFilterInfo2 = DSFilterInfo.doNotRender();
                }
            }
        }
        try {
            this.b = this.initInstance(5);
            this.setName(String.valueOf(this.b));
            this.initializeGraph(this.b, DSEnvironment.b());
            this.f = this.setupStreamBufferGraph(this.b, n2, this.a, this.a.getSrcFlags(), dSFilterInfo, dSFilterInfo2, this.a.getSrcParameters());
            long l2 = this.getNativeDevicePointer(this.b, 0);
            this.a.notifySource(this, l2);
            int n3 = this.lockProfile(this.b, "none");
            if (n3 < 0) {
                this.f = n3;
            }
        }
        catch (Exception exception) {
            this.e = true;
            throw new DSJException("dsj, unknown error in dll", -1);
        }
        if (this.f < 0) {
            this.e = true;
            throw new DSJException("DSStreamBufferGraph, constructor failed, errorCode: " + (this.f < -1000 ? DSJException.hresultToHexString(this.f) : String.valueOf(this.f)), this.f);
        }
        if ((this.f & 2) != 0) {
            this.o = false;
            this.j = n2 ^ 2;
        }
        if ((this.f & 8) != 0) {
            this.o = false;
            this.a(-15, 12);
        }
        if (this.o) {
            try {
                this.a = new DSFiltergraph.DSAudioStream(this);
            }
            catch (Exception exception) {
                this.o = false;
                throw new DSJException("error in dll, can't deliver audio.", -20);
            }
        }
        if (this.f == 1) {
            this.a = (StreamBufferSource)true;
            this.a = (StreamBufferSource)400;
            this.b = 0;
            this.getMovieInfo(this.b, (long[])this.a);
            this.a(this.b);
            this.d = true;
            return;
        }
        if (this.k) {
            this.getMovieInfo(this.b, (long[])this.a);
            this.a(this.b);
            this.d = true;
            return;
        }
        if (this.m) {
            this.e();
            this.getMovieInfo(this.b, (long[])this.a);
            this.b();
            this.a(this.b);
            this.d = true;
            return;
        }
        try {
            while (this.getBufferSize(this.b) == 0) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {}
        this.e();
        this.getMovieInfo(this.b, (long[])this.a);
        this.b();
        this.a(this.b);
        this.d = true;
        if (!(this.g || this.i || this.n)) {
            return;
        }
        this.c();
    }

    final void a() {
        if (this.a instanceof StreamBufferCaptureSource) {
            try {
                DSEnvironment.a(this.a.getDeviceInfos()[0].getPath());
            }
            catch (Exception exception) {}
            try {
                DSEnvironment.a(this.a.getDeviceInfos()[1].getPath());
            }
            catch (Exception exception) {}
        }
        this.b = -1L;
    }

    final long a() {
        return this.b;
    }

    public void setCaptureFile(String string) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {}
        this.setupRecorder(this.b, string);
    }

    public void record() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = (StreamBufferSource)8;
        int n2 = this.handleMovieTransport(this.b, (int[])this.a, this.e);
        if (n2 < 0) {
            throw new DSJException("SBE: record error", n2);
        }
    }

    public void referenceRecord(int n2, int n3) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 256;
        this.a[0] = (StreamBufferSource)n2;
        this.a[1] = (StreamBufferSource)n3;
        int n4 = this.handleMovieTransport(this.b, (int[])this.a, this.e);
        if (n4 < 0) {
            throw new DSJException("SBE record error", n4);
        }
    }

    public static DSFilterInfo[][] getStreamBufferSourceDevices(int n2, boolean bl) {
        DSFilterInfo[][] dSFilterInfoArrayArray = null;
        switch (n2) {
            case 0: {
                try {
                    DSFilterInfo[][] dSFilterInfoArray = DSCapture.queryDevices(1);
                    Vector<DSFilterInfo> vector = new Vector<DSFilterInfo>();
                    for (int i2 = 0; i2 < dSFilterInfoArray[0].length; ++i2) {
                        if (!bl || dSFilterInfoArray[0][i2].type == 2 || dSFilterInfoArray[0][i2].type == 3) {
                            vector.add(dSFilterInfoArray[0][i2]);
                            continue;
                        }
                        if (!DSStreamBufferGraph.a(dSFilterInfoArray[0][i2])) continue;
                        vector.add(dSFilterInfoArray[0][i2]);
                    }
                    dSFilterInfoArrayArray = new DSFilterInfo[2][];
                    if (vector.size() > 0) {
                        dSFilterInfoArrayArray[0] = new DSFilterInfo[vector.size()];
                        vector.toArray(dSFilterInfoArrayArray[0]);
                        vector.removeAllElements();
                    }
                    if (bl || dSFilterInfoArray[1].length <= 0) break;
                    dSFilterInfoArrayArray[1] = new DSFilterInfo[dSFilterInfoArray[1].length];
                    System.arraycopy(dSFilterInfoArray[1], 0, dSFilterInfoArrayArray[1], 0, dSFilterInfoArray[1].length);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                }
                break;
            }
            case 1: {
                DSFilterInfo[][] dSFilterInfoArrayArray2 = new DSFilterInfo[1][];
                dSFilterInfoArrayArray = dSFilterInfoArrayArray2;
                dSFilterInfoArrayArray2[0] = DSEnvironment.getFilters(23);
            }
        }
        return dSFilterInfoArrayArray;
    }

    private static boolean a(DSFilterInfo dSPinInfoArray) {
        try {
            dSPinInfoArray = dSPinInfoArray.getDownstreamPins();
            if (dSPinInfoArray == null) {
                return false;
            }
            for (int i2 = 0; i2 < dSPinInfoArray.length; ++i2) {
                if (dSPinInfoArray[i2].getName().equalsIgnoreCase("656")) {
                    return true;
                }
                DSMediaType[] dSMediaTypeArray = dSPinInfoArray[i2].getFormats();
                for (int i3 = 0; i3 < dSMediaTypeArray.length; ++i3) {
                    if (dSMediaTypeArray[i3].getMajorType() != 2 || dSMediaTypeArray[i3].getSubType() != 60 && dSMediaTypeArray[i3].getSubType() != 124 && dSMediaTypeArray[i3].getSubType() != 120 && dSMediaTypeArray[i3].getSubType() != 125 && dSMediaTypeArray[i3].getSubType() != 127) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            dSPinInfoArray = exception;
            exception.printStackTrace();
        }
        return false;
    }

    public static StreamBufferSource createSource(int n2, DSFilterInfo dSFilterInfo, int n3) {
        StreamBufferSource streamBufferSource = null;
        if (n2 == 0) {
            streamBufferSource = new StreamBufferCaptureSource(dSFilterInfo);
        } else if (n2 == 1) {
            streamBufferSource = new StreamBufferBDASource(dSFilterInfo, n3);
        } else if (n2 == 2) {
            streamBufferSource = new StreamBufferFileSource(dSFilterInfo);
        }
        return streamBufferSource;
    }

    public static StreamBufferSource createNonStandardSource(int n2, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2, int n3) {
        StreamBufferCaptureSource streamBufferCaptureSource = null;
        if (n2 == 0) {
            streamBufferCaptureSource = new StreamBufferCaptureSource(dSFilterInfo, dSFilterInfo2, n3);
        }
        return streamBufferCaptureSource;
    }

    public void controlSourceGraph(int[] nArray) {
        this.handleMovieTransport(this.b, nArray, 512);
    }

    native int setupStreamBufferGraph(long var1, int var3, StreamBufferSource var4, int var5, DSFilterInfo var6, DSFilterInfo var7, int[] var8);

    native int setupRecorder(long var1, String var3);

    native int lockProfile(long var1, String var3);

    public static void setupEnvironment(String string, int n2, int n3) {
        DSEnvironment.loadDLL();
        DSStreamBufferGraph.nativeSetupEnvironment(string, n2, n3);
    }

    static native void nativeSetupEnvironment(String var0, int var1, int var2);
}

