/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.AVCDevice;
import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilter;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSJUtils;
import de.humatic.dsj.DSMediaType;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.File;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSDVCam
extends DSFiltergraph
implements AVCDevice {
    public static final int CAMERA = 0;
    public static final int VCR = 1;
    public static final int PREVIEW = 0;
    public static final int T2F = 1;
    public static final int F2T = 2;
    public static final int C2F = 3;
    public static final int RECORDING = 4;
    public static final int NO_AUDIO = 2048;
    public static final int AVC = 0;
    public static final int UVC = 1;
    private int s;
    private int t;
    private String b = "";
    private String c = "";

    public DSDVCam(int n2, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(n2, DSFilterInfo.doNotRender());
    }

    public DSDVCam(int n2, DSFilterInfo dSFilterInfo, PropertyChangeListener propertyChangeListener) {
        boolean bl = false;
        DSFilterInfo.DSPinInfo[] dSPinInfoArray = dSFilterInfo.getDownstreamPins();
        for (int i2 = 0; i2 < dSPinInfoArray.length; ++i2) {
            DSMediaType[] dSMediaTypeArray = dSPinInfoArray[i2].getFormats();
            for (int i3 = 0; i3 < dSMediaTypeArray.length; ++i3) {
                if (dSMediaTypeArray[i3].getMajorType() != 3 && (dSMediaTypeArray[i3].getSubType() < 15 || dSMediaTypeArray[i3].getSubType() > 20)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            throw new DSJException("DSDVCam: FilterInfo does not point to a DV device", -1);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(n2, dSFilterInfo);
    }

    private void a(int n2, DSFilterInfo dSFilterInfo) {
        this.a(n2);
        this.type = 3;
        this.a = this.initInstance(3);
        this.setName(String.valueOf(this.a));
        this.initializeGraph(this.a, DSEnvironment.b());
        this.setBackground(Color.black);
        if (this.o) {
            this.j ^= 0x100;
        }
        try {
            this.f = this.setupDSDVCam(this.a, n2, dSFilterInfo);
        }
        catch (Exception exception) {
            this.e = true;
            throw new DSJException("dsj, unknown error in dll", -1);
        }
        String string = "DSDVCam, construction failed";
        if (this.f < 0) {
            this.e = true;
            switch (this.f) {
                case -300: {
                    string = "DSDVCam, no DV device found";
                    break;
                }
                case -303: {
                    string = "DSDVCam, DV device might be busy, can't render preview";
                }
            }
            throw new DSJException(string, this.f);
        }
        if (this.k) {
            this.getMovieInfo(this.a, this.a);
            this.a(this.a);
            this.d = true;
            return;
        }
        if (this.l || this.m) {
            this.e();
            this.getMovieInfo(this.a, this.a);
            this.b();
            this.a(this.a);
            this.d = true;
            return;
        }
        DSJUtils.logln(3, "DV - setup: " + this.f);
        try {
            int n3 = 0;
            while (this.getBufferSize(this.a) == 0 && n3++ < 20) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {}
        this.e();
        this.getMovieInfo(this.a, this.a);
        if ((this.f >> 12 & 1) != 0) {
            this.a(-305, 12);
        }
        this.t = this.f >> 15 & 1;
        this.b();
        this.a(this.a);
        this.d = true;
        if (this.k || !this.g && !this.i && !this.n) {
            return;
        }
        this.c();
    }

    public int getDeviceMode() {
        return this.f >> 8 & 0xF;
    }

    public int getOperationMode() {
        return this.f & 0xFF;
    }

    void setState(int n2) {
        this.f = this.f ^ 0xFF | n2;
    }

    public int getDeviceType() {
        return this.t;
    }

    final void a() {
        this.a = -1L;
    }

    public void rewind() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 0;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void scanBwd() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 2;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void stepBwd() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 4;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void fastFwd() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 1;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void scanFwd() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 3;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void stepFwd() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 5;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void pause() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 6;
        this.a[0] = this.a[0] == 0 ? 1 : 0;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void stop() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 7;
        this.a[0] = 0;
        int n2 = this.handleMovieTransport(this.a, this.a, this.e);
        if (n2 == -305) {
            throw new DSJException("DSDVCam, device has no tape", -305);
        }
    }

    public void record() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 8;
        this.a[2] = this.a[2] == 0 ? 1 : 0;
        this.handleMovieTransport(this.a, this.a, this.e);
    }

    public void grabToDisc() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 64;
        this.a[4] = 9;
        this.a[2] = this.a[2] == 0 ? 1 : 0;
        this.handleMovieTransport(this.a, this.a, this.e);
    }

    public void seekToTime(int n2, int n3, int n4, int n5) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.getDeviceMode() != 1) {
            throw new DSJException("DSDVCam: Device not in VCR mode", -4);
        }
        if (this.t == 1) {
            throw new DSJException("DSDVCam: seekToTime not supported for USB Devices", -4);
        }
        this.e = 128;
        this.a[4] = n2;
        this.a[5] = n3;
        this.a[6] = n4;
        this.a[7] = n5;
        this.handleMovieTransport(this.a, this.a, this.e);
    }

    public void seekToTime(int n2) {
        int n3 = n2 / 3600000;
        int n4 = n2 % 3600000 / 60000;
        int n5 = n2 % 60000 / 1000;
        n2 = (int)((float)n2 % this.getFrameRate());
        this.seekToTime(n3, n4, n5, n2);
    }

    public int sendRawAVC(byte[] byArray) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        return this.nativeSendRawCommand(this.a, 3, 0, byArray);
    }

    public Dimension setResolution() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        boolean bl = this.u;
        this.u = false;
        int n2 = this.nativeSetResolution(this.a);
        this.a = n2 >> 16;
        this.b = (String)(n2 & 0xFFFF);
        this.c = (String)this.a;
        this.d = (int)this.b;
        this.a(-1, 5);
        this.a = (float)this.a / (float)this.b;
        this.u = bl;
        return new Dimension(this.a, (int)this.b);
    }

    native int nativeSetResolution(long var1);

    native int setupDSDVCam(long var1, int var3, DSFilterInfo var4);

    public void writeFileToTape(String string, int n2) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.s = 2;
        if (n2 < 1) {
            n2 = 1;
        }
        this.f = this.writeToTape(this.a, string, n2);
        if (this.f < 0) {
            throw new DSJException("tape dump failed: " + DSJException.hresultToHexString(this.f), this.f);
        }
        this.a(-1, 4);
    }

    native int writeToTape(long var1, String var3, int var4);

    public void grabTapeToFile(String string, DSFilterInfo object, boolean bl, boolean bl2, int n2) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.s = 1;
        this.b(true);
        try {
            this.c = string.substring(string.lastIndexOf("/") + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 == 3) {
            try {
                if (string.toLowerCase().indexOf(".dv") < 0) {
                    string = string.substring(0, string.lastIndexOf(".")) + ".dv";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            File file = new File(string);
            if (!new File(file.getParent()).getAbsoluteFile().exists()) {
                new File(file.getParent()).getAbsoluteFile().mkdirs();
            }
            file.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DSDVCam.a(string)) {
            int n3 = ((DSFilterInfo)object).getPreferredFormat();
            object = object != null && ((DSFilterInfo)object).getName().indexOf("none") == -1 ? this.a((DSFilterInfo)object) : this.a();
            ((DSFilterInfo)object).setPreferredFormat(n3);
        }
        this.f = this.tapeToFile(this.a, string, (DSFilterInfo)object, bl, bl2, n2);
        this.b(false);
        this.a(-1, 4);
    }

    native int tapeToFile(long var1, String var3, DSFilterInfo var4, boolean var5, boolean var6, int var7);

    public void cameraToFile(String string, DSFilterInfo object, boolean bl, boolean bl2) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.s = 3;
        this.b(true);
        try {
            this.c = string.substring(string.lastIndexOf("/") + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            File file = new File(string);
            if (!new File(file.getParent()).getAbsoluteFile().exists()) {
                new File(file.getParent()).getAbsoluteFile().mkdirs();
            }
            file.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.b = string;
        if (DSDVCam.a(string)) {
            int n2 = ((DSFilterInfo)object).getPreferredFormat();
            object = object != null && ((DSFilterInfo)object).getName().indexOf("none") == -1 ? this.a((DSFilterInfo)object) : this.a();
            ((DSFilterInfo)object).setPreferredFormat(n2);
        }
        this.f = this.camToFile(this.a, this.b, (DSFilterInfo)(object == null ? DSFilterInfo.doNotRender() : object), bl, bl2);
        this.b(false);
        this.a(-1, 4);
    }

    native int camToFile(long var1, String var3, DSFilterInfo var4, boolean var5, boolean var6);

    public void changeCaptureFile(String string, boolean bl) {
        if (this.getState() == 0) {
            throw new DSJException("Graph is in preview mode", -51);
        }
        Object object = this;
        if (this.nativeGetParameter(((DSDVCam)object).a, 0, -1) == 1) {
            this.record();
        }
        this.stop();
        object = null;
        object = DSJUtils.c(this.c) ? this.findFilterByName("Mux") : (this.c.indexOf(".dv") < 0 ? this.findFilterByName("File Writer") : this.findFilterByName("dsj_Dump"));
        if (object == null) {
            object = this.findFilterByName(this.c);
        }
        if (object == null) {
            throw new DSJException("cant find FileWriter", -1);
        }
        ((DSFilter)object).setParameter("src", string);
        this.play();
        if (this.getDeviceMode() == 1) {
            this.pause();
            if (this.getExtTransportState() != 4296) {
                this.pause();
            }
        }
        if (bl) {
            this.record();
        }
        this.a(-1, 4);
    }

    public void setPreview() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.b(true);
        this.f = this.nativeSetPreview(this.a);
        this.b(false);
        this.a(-1, 4);
    }

    public int getExtTransportState() {
        return this.nativeGetParameter(this.a, 1, -1);
    }

    final long a() {
        return this.a;
    }

    native int nativeSetPreview(long var1);
}

