/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import components.ImageTableModel;
import components.PictogramTableCellRenderer;
import configuration.TConfiguration;
import configuration.TLanguage;
import database.DB;
import database.DBTasks;
import dialogs.AddImageFrame;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ExportSearchFrame
extends JDialog {
    private JPanel contentPane;
    private JTextField term1TextField;
    private JTextField term2TextField;
    private JTextField term3TextField;
    private JTextField imageNameTextField;
    private ImageTableModel imageTableModel;
    private String[] imageTableHeader;
    private JTable table;
    private JComboBox AndOr1ComboBox;
    private JComboBox AndOr2ComboBox;
    public static final int IS_INTEGRATED = 0;
    private int mode = -1;
    private String selectedImageName;
    private ExportSearchFrame mainFrame;
    private JProgressBar progressBar;
    private String queryLoaded;
    private JComboBox comboBox;
    private JLabel labelTotalImages;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ExportSearchFrame frame = new ExportSearchFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ExportSearchFrame(int mode) {
        this.mode = mode;
        this.init();
    }

    public ExportSearchFrame() {
        this.init();
    }

    private void init() {
        TLanguage.initLanguage(TConfiguration.getLanguage());
        this.imageTableHeader = new String[]{"", "", "", "", "", ""};
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("EXPORT_SEARCH_FRAME.TITLE"));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 720, 430);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, TLanguage.getString("EXPORT_SEARCH_FRAME.KEY_TERMS"), 4, 2, null, null));
        this.contentPane.add(panel);
        panel.setLayout(new FlowLayout(1, 5, 5));
        this.term1TextField = new JTextField();
        panel.add(this.term1TextField);
        this.term1TextField.setColumns(10);
        this.AndOr1ComboBox = new JComboBox();
        this.AndOr1ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("EXPORT_SEARCH_FRAME.AND"), TLanguage.getString("EXPORT_SEARCH_FRAME.OR")}));
        panel.add(this.AndOr1ComboBox);
        this.term2TextField = new JTextField();
        panel.add(this.term2TextField);
        this.term2TextField.setColumns(10);
        this.AndOr2ComboBox = new JComboBox();
        this.AndOr2ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("EXPORT_SEARCH_FRAME.AND"), TLanguage.getString("EXPORT_SEARCH_FRAME.OR")}));
        panel.add(this.AndOr2ComboBox);
        this.term3TextField = new JTextField();
        this.term3TextField.setColumns(10);
        panel.add(this.term3TextField);
        JButton btnBuscar = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.FIND"));
        btnBuscar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!ExportSearchFrame.this.term1TextField.getText().equals("")) {
                    String query = "SELECT COUNT(*) AS row_count, GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name IN (SELECT main.name FROM main WHERE word LIKE '" + ExportSearchFrame.this.term1TextField.getText() + "'";
                    if (ExportSearchFrame.this.comboBox.getSelectedItem().toString().compareTo("Todos") != 0) {
                        query = String.valueOf(query) + " AND idL = (SELECT id FROM language WHERE name LIKE '" + ExportSearchFrame.this.comboBox.getSelectedItem().toString() + "')";
                    }
                    query = String.valueOf(query) + ")";
                    if (!ExportSearchFrame.this.term2TextField.getText().equals("")) {
                        query = String.valueOf(query) + (ExportSearchFrame.this.AndOr1ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        query = String.valueOf(query) + "main.name IN (SELECT main.name FROM main WHERE word LIKE '" + ExportSearchFrame.this.term2TextField.getText() + "'";
                        if (ExportSearchFrame.this.comboBox.getSelectedItem().toString().compareTo("Todos") != 0) {
                            query = String.valueOf(query) + " AND idL = (SELECT id FROM language WHERE name LIKE '" + ExportSearchFrame.this.comboBox.getSelectedItem().toString() + "')";
                        }
                        query = String.valueOf(query) + ")";
                    }
                    if (!ExportSearchFrame.this.term3TextField.getText().equals("")) {
                        query = String.valueOf(query) + (ExportSearchFrame.this.AndOr2ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        query = String.valueOf(query) + "main.name IN (SELECT main.name FROM main WHERE word LIKE '" + ExportSearchFrame.this.term3TextField.getText() + "'";
                        if (ExportSearchFrame.this.comboBox.getSelectedItem().toString().compareTo("Todos") != 0) {
                            query = String.valueOf(query) + " AND idL = (SELECT id FROM language WHERE name LIKE '" + ExportSearchFrame.this.comboBox.getSelectedItem().toString() + "')";
                        }
                        query = String.valueOf(query) + ")";
                    }
                    query = String.valueOf(query) + " GROUP BY main.name";
                    ExportSearchFrame.this.queryLoaded = query;
                    try {
                        DB db = DB.getInstance();
                        ResultSet rs = db.query(query);
                        ExportSearchFrame.this.prepareTermsTable(rs);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        panel.add(btnBuscar);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(null, TLanguage.getString("EXPORT_SEARCH_FRAME.BY_IMAGE_NAME"), 4, 2, null, null));
        this.contentPane.add(panel_1);
        JLabel lblNombre = new JLabel(TLanguage.getString("EXPORT_SEARCH_FRAME.NAME"));
        panel_1.add(lblNombre);
        this.imageNameTextField = new JTextField();
        panel_1.add(this.imageNameTextField);
        this.imageNameTextField.setColumns(30);
        JButton btnBuscar_1 = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.FIND"));
        btnBuscar_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ExportSearchFrame.this.imageNameTextField.getText().length() >= 3) {
                    try {
                        DB db = DB.getInstance();
                        String query = "SELECT COUNT(*) AS row_count, GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name LIKE '" + ExportSearchFrame.this.imageNameTextField.getText() + "' GROUP BY nameNN";
                        ExportSearchFrame.this.queryLoaded = query;
                        ResultSet rs = db.query(query);
                        ExportSearchFrame.this.prepareTermsTable(rs);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        panel_1.add(btnBuscar_1);
        JPanel panel_5 = new JPanel();
        this.contentPane.add(panel_5);
        JLabel lblIdiomaDeLa = new JLabel(TLanguage.getString("FIND_IMAGE_FRAME.LANGUAGE_OF_THE_SEARCH"));
        panel_5.add(lblIdiomaDeLa);
        this.comboBox = new JComboBox();
        this.comboBox.addItem("Todos");
        this.comboBox.setSelectedIndex(0);
        String query = "SELECT name FROM language ORDER BY id asc";
        try {
            ResultSet rs = DB.getInstance().query(query);
            int pos = 1;
            while (rs.next()) {
                this.comboBox.addItem(rs.getString("name"));
                if (rs.getString("name").compareTo(TConfiguration.getLanguage()) == 0) {
                    this.comboBox.setSelectedIndex(pos);
                }
                ++pos;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        panel_5.add(this.comboBox);
        JPanel panel_6 = new JPanel();
        this.contentPane.add(panel_6);
        JLabel lblNewLabel = new JLabel(TLanguage.getString("FIND_IMAGE_FRAME.TOTAL_IMAGES_FOUND"));
        panel_6.add(lblNewLabel);
        this.labelTotalImages = new JLabel("0");
        panel_6.add(this.labelTotalImages);
        JPanel panel_2 = new JPanel();
        panel_2.setLayout(new BorderLayout(0, 0));
        panel_2.setBorder(new TitledBorder(null, TLanguage.getString("EXPORT_SEARCH_FRAME.RESULTS"), 4, 2, null, null));
        this.contentPane.add(panel_2);
        this.imageTableModel = new ImageTableModel();
        this.table = new JTable(this.imageTableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.setDefaultRenderer(String.class, new PictogramTableCellRenderer());
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ExportSearchFrame.this.table.getSelectedRow();
                int column = ExportSearchFrame.this.table.getSelectedColumn();
                String imageNameNN = ((ImageTableModel)ExportSearchFrame.this.table.getModel()).getImageName(row, column);
                ExportSearchFrame.this.selectedImageName = imageNameNN;
                if (imageNameNN != null && e.getClickCount() == 2) {
                    if (ExportSearchFrame.this.mode == 0) {
                        ExportSearchFrame.this.mainFrame.dispose();
                    } else {
                        AddImageFrame f = new AddImageFrame(imageNameNN);
                        f.setVisible(true);
                        f.pack();
                    }
                }
            }
        });
        this.table.setRowHeight(100);
        this.table.setSize(new Dimension(500, 100));
        JScrollPane scrollPane = new JScrollPane(this.table);
        panel_2.add(scrollPane);
        JPanel panel_3 = new JPanel();
        this.contentPane.add(panel_3);
        if (this.mode == 0) {
            JButton btnInsertar = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.INSERT"));
            panel_3.add(btnInsertar);
            btnInsertar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (ExportSearchFrame.this.selectedImageName == null) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                    } else {
                        ExportSearchFrame.this.mainFrame.dispose();
                    }
                }
            });
        }
        JButton btnCancelar = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.CANCEL"));
        btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportSearchFrame.this.mainFrame.dispose();
            }
        });
        JButton btnExportarBsqueda = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.EXPORT_SEARCH"));
        panel_3.add(btnExportarBsqueda);
        panel_3.add(btnCancelar);
        JPanel panel_4 = new JPanel();
        this.contentPane.add(panel_4);
        btnExportarBsqueda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ExportSearchFrame.this.queryLoaded == null) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.YOU_SHOULD_SELECT_AN_IMAGE"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                } else {
                    final JFileChooser f = new JFileChooser();
                    f.setFileSelectionMode(1);
                    int returnVal = f.showOpenDialog(ExportSearchFrame.this.contentPane);
                    if (returnVal == 0) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ExportSearchFrame.this.mainFrame.setEnabled(false);
                                DBTasks.exportDB(f.getSelectedFile().getAbsolutePath(), ExportSearchFrame.this.progressBar, ExportSearchFrame.this.queryLoaded);
                                JOptionPane.showMessageDialog(ExportSearchFrame.this.contentPane, TLanguage.getString("EXPORT_SEARCH_FRAME.IMPORT_OK"));
                                ExportSearchFrame.this.mainFrame.setEnabled(true);
                                ExportSearchFrame.this.progressBar.setValue(0);
                            }
                        }).start();
                    }
                }
            }
        });
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(680, 30));
        panel_4.add(this.progressBar);
    }

    private void prepareTermsTable(ResultSet rs) {
        try {
            this.imageTableModel.setDataVector(null, this.imageTableHeader);
            String imagePath = DB.getInstance().getImagesPath();
            Vector<String> listNames = new Vector<String>();
            int totalImages = 0;
            while (rs.next()) {
                listNames.add(String.valueOf(imagePath) + File.separator + rs.getString("name"));
                ++totalImages;
            }
            this.labelTotalImages.setText(String.valueOf(totalImages));
            this.imageTableModel.setData(listNames);
            this.imageTableModel.fireTableDataChanged();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getSelectedImageName() {
        return this.selectedImageName;
    }
}

