/*
 * Decompiled with CFR 0.152.
 */
package database;

import configuration.TConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB {
    protected Connection con;
    private static DB instance;
    private static Statement s;
    private static PreparedStatement ps;

    private DB() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.con = DriverManager.getConnection("jdbc:sqlite:" + TConfiguration.getDatabasePath());
            this.createTablesDB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DB getInstance() throws SQLException {
        if (instance == null) {
            try {
                instance = new DB();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException();
            }
        }
        return instance;
    }

    public ResultSet query(String sql) throws SQLException {
        s = this.con.createStatement();
        ResultSet rs = null;
        String finalSQL = DB.escapeQuery(sql);
        rs = s.executeQuery(finalSQL);
        return rs;
    }

    public static String escapeQuery(String sql) {
        String upperCaseSQL = sql.toUpperCase();
        String selectPart = "";
        String fromPart = "";
        if (upperCaseSQL.indexOf(" WHERE ") > 0) {
            selectPart = sql.substring(0, upperCaseSQL.indexOf(" WHERE "));
            fromPart = sql.substring(upperCaseSQL.indexOf(" WHERE "));
        } else {
            selectPart = sql;
        }
        return String.valueOf(selectPart) + fromPart.replace('*', '%');
    }

    public int update(String sql) throws SQLException {
        s = this.con.createStatement();
        int rows = 0;
        rows = s.executeUpdate(sql);
        return rows;
    }

    public void close() throws SQLException {
        this.con.close();
        this.con = null;
        instance = null;
    }

    public void activateTransactions() throws SQLException {
        this.con.setAutoCommit(false);
    }

    public void executeQueries() throws SQLException {
        this.con.setAutoCommit(true);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        ps = this.con.prepareStatement(sql);
        return ps;
    }

    public void executeBatch(String sql) throws SQLException {
        s = this.con.createStatement();
        s.addBatch(sql);
        s.executeBatch();
    }

    public String getImagesPath() throws FileNotFoundException, IOException {
        return TConfiguration.getImagesPath();
    }

    private void createTablesDB() {
        try {
            String query = "CREATE TABLE IF NOT EXISTS main (word VARCHAR(50), idL INTEGER, idT INTEGER, name VARCHAR(50), nameNN VARCHAR(50))";
            this.update(query);
            query = "CREATE TABLE IF NOT EXISTS language(id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            this.update(query);
            query = "CREATE TABLE IF NOT EXISTS type (id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            this.update(query);
            this.update("CREATE UNIQUE INDEX IF NOT EXISTS main_index ON main (word, idL, idT, name, nameNN)");
            String[] languages = new String[]{"Castellano", "Ingles", "Frances", "Catalan", "Italiano", "Aleman", "Portugues", "Portugues Brasil", "Gallego"};
            query = "INSERT OR IGNORE INTO language(id,name) VALUES (?,?)";
            PreparedStatement stmt = this.prepareStatement(query);
            int i = 0;
            while (i < languages.length) {
                stmt.setInt(1, i);
                stmt.setString(2, languages[i]);
                stmt.executeUpdate();
                ++i;
            }
            stmt.close();
            String[] types = new String[]{"nombreComun", "descriptivo", "verbo", "miscelanea", "nombrePropio", "contenidoSocial"};
            query = "INSERT OR IGNORE INTO type(id,name) VALUES (?,?)";
            stmt = this.prepareStatement(query);
            int i2 = 0;
            while (i2 < types.length) {
                stmt.setInt(1, i2);
                stmt.setString(2, types[i2]);
                stmt.executeUpdate();
                ++i2;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }
}

